/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.support;

import java.util.Map;
import net.neoremind.fountain.event.BaseLogEvent;
import net.neoremind.fountain.support.EventCallback;
import net.neoremind.fountain.support.TrxContext;
import net.neoremind.fountain.util.CollectionUtil;

public class EventListener {
    private Map<Class<? extends BaseLogEvent>, EventCallback> eventCallbackMap = CollectionUtil.createHashMap(5);

    private EventListener() {
    }

    public static EventListener factory() {
        return new EventListener();
    }

    public void addCallback(Class<? extends BaseLogEvent> clazz, EventCallback cb) {
        this.eventCallbackMap.put(clazz, cb);
    }

    public void handle(BaseLogEvent event, TrxContext trxContext) {
        EventCallback cb = this.eventCallbackMap.get(event.getClass());
        if (cb != null) {
            cb.handle(event, trxContext);
        }
    }
}

