/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.support;

import java.util.Arrays;
import net.neoremind.fountain.event.BaseLogEvent;
import net.neoremind.fountain.rowbaselog.event.FormatDescriptionEvent;
import net.neoremind.fountain.rowbaselog.event.GtidEvent;
import net.neoremind.fountain.rowbaselog.event.QueryLogEvent;
import net.neoremind.fountain.rowbaselog.event.RotateEvent;
import net.neoremind.fountain.rowbaselog.event.RowsLogEvent;
import net.neoremind.fountain.rowbaselog.event.RowsLogEventV1;
import net.neoremind.fountain.rowbaselog.event.RowsLogEventV2;
import net.neoremind.fountain.rowbaselog.event.XidLogEvent;
import net.neoremind.fountain.support.EventListener;
import net.neoremind.fountain.support.FormatDescriptionEventCallback;
import net.neoremind.fountain.support.GtIdEventCallback;
import net.neoremind.fountain.support.QueryLogEventCallback;
import net.neoremind.fountain.support.RotateEventCallback;
import net.neoremind.fountain.support.RowsLogEventCallback;
import net.neoremind.fountain.support.XidLogEventCallback;

public class TrxContext {
    private byte[] sid;
    private Long currGtId;
    private String binlogFileName;
    private Long nextBinlogPosition;
    private Long currBinlogPosition;
    private FormatDescriptionEvent fmtDescEvent;
    private boolean isChecksumSupport;
    private EventListener eventListener = EventListener.factory();

    private TrxContext() {
        this.eventListener.addCallback(FormatDescriptionEvent.class, new FormatDescriptionEventCallback());
        this.eventListener.addCallback(RowsLogEvent.class, new RowsLogEventCallback());
        this.eventListener.addCallback(RowsLogEventV1.class, new RowsLogEventCallback());
        this.eventListener.addCallback(RowsLogEventV2.class, new RowsLogEventCallback());
        this.eventListener.addCallback(GtidEvent.class, new GtIdEventCallback());
        this.eventListener.addCallback(RotateEvent.class, new RotateEventCallback());
        this.eventListener.addCallback(QueryLogEvent.class, new QueryLogEventCallback());
        this.eventListener.addCallback(XidLogEvent.class, new XidLogEventCallback());
    }

    public static TrxContext factory() {
        return new TrxContext();
    }

    public String toString() {
        return "TrxContext{currGtId=" + this.currGtId + ", binlogFileName='" + this.binlogFileName + '\'' + ", preBinlogPosition=" + this.currBinlogPosition + ", nextBinlogPosition=" + this.nextBinlogPosition + ", fmtDescEvent=" + this.fmtDescEvent + ", sid=" + Arrays.toString(this.sid) + ", isChecksumSupport=" + this.isChecksumSupport + '}';
    }

    public void handleEvent(BaseLogEvent event) {
        this.eventListener.handle(event, this);
    }

    public byte[] getSid() {
        return this.sid;
    }

    public void setSid(byte[] sid) {
        this.sid = sid;
    }

    public FormatDescriptionEvent getFmtDescEvent() {
        return this.fmtDescEvent;
    }

    public void setFmtDescEvent(FormatDescriptionEvent fmtDescEvent) {
        this.fmtDescEvent = fmtDescEvent;
    }

    public Long getCurrGtId() {
        return this.currGtId;
    }

    public void setCurrGtId(Long currGtId) {
        this.currGtId = currGtId;
    }

    public String getBinlogFileName() {
        return this.binlogFileName;
    }

    public void setBinlogFileName(String binlogFileName) {
        this.binlogFileName = binlogFileName;
    }

    public Long getNextBinlogPosition() {
        return this.nextBinlogPosition;
    }

    public void setNextBinlogPosition(Long nextBinlogPosition) {
        this.nextBinlogPosition = nextBinlogPosition;
    }

    public Long getCurrBinlogPosition() {
        return this.currBinlogPosition;
    }

    public void setCurrBinlogPosition(Long currBinlogPosition) {
        this.currBinlogPosition = currBinlogPosition;
    }

    public boolean isChecksumSupport() {
        return this.isChecksumSupport;
    }

    public void setIsChecksumSupport(boolean isChecksumSupport) {
        this.isChecksumSupport = isChecksumSupport;
    }
}

