/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.io.SegmentedStringWriter;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.smile.SmileFactory;
import org.codehaus.jackson.type.JavaType;
import org.codehaus.jackson.type.TypeReference;
import org.codehaus.jackson.util.ByteArrayBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static final ObjectMapperExt objectMapper = new ObjectMapperExt();
    private static final ObjectMapperExt objectMapperByte = new ObjectMapperExt((JsonFactory)new SmileFactory());

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static <T> T json2GenericObject(String jsonString, TypeReference<T> tr) {
        if (jsonString == null || "".equals(jsonString)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(jsonString, tr);
        }
        catch (Exception e) {
            log.warn("json error:" + e.getMessage());
            return null;
        }
    }

    public static String toJson(Object object) {
        String jsonString = "";
        try {
            jsonString = objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            log.warn("json error:" + e.getMessage());
        }
        return jsonString;
    }

    public static byte[] toJsonBytes(Object object) {
        byte[] smileData = null;
        try {
            smileData = objectMapperByte.writeValueAsBytes(object);
        }
        catch (Exception e) {
            log.warn("json error:" + e.getMessage());
        }
        return smileData;
    }

    public static String toJson(Object object, boolean ignoreEmpty) {
        String jsonString = "";
        try {
            jsonString = ignoreEmpty ? objectMapper.writeValueAsString(object, JsonSerialize.Inclusion.NON_EMPTY) : objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            log.warn("json error:" + e.getMessage());
        }
        return jsonString;
    }

    public static byte[] toJsonBytes(Object object, boolean ignoreEmpty) {
        byte[] smileData = null;
        try {
            smileData = ignoreEmpty ? objectMapperByte.writeValueAsBytes(object, JsonSerialize.Inclusion.NON_EMPTY) : objectMapperByte.writeValueAsBytes(object);
        }
        catch (Exception e) {
            log.warn("json error:" + e.getMessage());
        }
        return smileData;
    }

    public static Object json2Object(String jsonString, Class<?> c) {
        if (jsonString == null || "".equals(jsonString)) {
            return "";
        }
        try {
            objectMapper.getDeserializationConfig().set(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return objectMapper.readValue(jsonString, c);
        }
        catch (Exception e) {
            log.error("json error:" + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static Object bytes2Object(byte[] jsonBytes, Class<?> c) {
        if (jsonBytes == null || jsonBytes.length == 0) {
            return null;
        }
        try {
            objectMapperByte.getDeserializationConfig().set(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return objectMapperByte.readValue(jsonBytes, c);
        }
        catch (Exception e) {
            log.error("json error:" + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static Object json2Object(String jsonString, JavaType type) {
        if (jsonString == null || "".equals(jsonString)) {
            return "";
        }
        try {
            objectMapper.getDeserializationConfig().set(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return objectMapper.readValue(jsonString, type);
        }
        catch (Exception e) {
            log.warn("json error:" + e.getMessage());
            return "";
        }
    }

    public static Object convertValue(Object val, JavaType type) {
        return objectMapper.convertValue(val, type);
    }

    private static class ObjectMapperExt
    extends ObjectMapper {
        public ObjectMapperExt() {
        }

        public ObjectMapperExt(JsonFactory jf) {
            super(jf);
        }

        public String writeValueAsString(Object value, JsonSerialize.Inclusion inc) throws IOException, JsonGenerationException, JsonMappingException {
            if (inc == null) {
                return super.writeValueAsString(value);
            }
            SegmentedStringWriter sw = new SegmentedStringWriter(this._jsonFactory._getBufferRecycler());
            this.writeValueWithConf(this._jsonFactory.createJsonGenerator((Writer)sw), value, inc);
            return sw.getAndClear();
        }

        public byte[] writeValueAsBytes(Object value, JsonSerialize.Inclusion inc) throws IOException, JsonGenerationException, JsonMappingException {
            if (inc == null) {
                return super.writeValueAsBytes(value);
            }
            ByteArrayBuilder bb = new ByteArrayBuilder(this._jsonFactory._getBufferRecycler());
            this.writeValueWithConf(this._jsonFactory.createJsonGenerator((OutputStream)bb, JsonEncoding.UTF8), value, inc);
            byte[] result = bb.toByteArray();
            bb.release();
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void configAndWriteCloseable(JsonGenerator jgen, Object value, SerializationConfig cfg) throws IOException, JsonGenerationException, JsonMappingException {
            Closeable toClose = (Closeable)value;
            try {
                this._serializerProvider.serializeValue(cfg, jgen, value, this._serializerFactory);
                JsonGenerator tmpJgen = jgen;
                jgen = null;
                tmpJgen.close();
                Closeable tmpToClose = toClose;
                toClose = null;
                tmpToClose.close();
            }
            finally {
                if (jgen != null) {
                    try {
                        jgen.close();
                    }
                    catch (IOException ioe) {}
                }
                if (toClose != null) {
                    try {
                        toClose.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeValueWithConf(JsonGenerator jgen, Object value, JsonSerialize.Inclusion inc) throws IOException, JsonGenerationException, JsonMappingException {
            SerializationConfig cfg = this.copySerializationConfig();
            if ((cfg = cfg.withSerializationInclusion(inc)).isEnabled(SerializationConfig.Feature.INDENT_OUTPUT)) {
                jgen.useDefaultPrettyPrinter();
            }
            if (cfg.isEnabled(SerializationConfig.Feature.CLOSE_CLOSEABLE) && value instanceof Closeable) {
                this.configAndWriteCloseable(jgen, value, cfg);
                return;
            }
            boolean closed = false;
            try {
                this._serializerProvider.serializeValue(cfg, jgen, value, this._serializerFactory);
                closed = true;
                jgen.close();
            }
            finally {
                if (!closed) {
                    try {
                        jgen.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }
}

