/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.util;

import java.nio.ByteBuffer;
import net.neoremind.fountain.exception.LengthEncodedIntegerEOFExp;
import net.neoremind.fountain.exception.LengthEncodedIntegerErrExp;
import net.neoremind.fountain.exception.LengthEncodedIntegerNullExp;
import net.neoremind.fountain.util.UnsignedNumberHelper;

public class MysqlValueHelper {
    private static final int NULL_TERMINATED_STRING_DELIMITER = 0;

    private MysqlValueHelper() {
    }

    public static byte[] getFixedBytes(ByteBuffer buffer, int length) {
        byte[] result = new byte[length];
        buffer.get(result);
        return result;
    }

    public static long convertLengthCodedLength(ByteBuffer buffer) throws LengthEncodedIntegerEOFExp, LengthEncodedIntegerNullExp, LengthEncodedIntegerErrExp, RuntimeException {
        int magic = UnsignedNumberHelper.toUnsignedByte(buffer.get());
        if (magic < 251) {
            return magic;
        }
        if (magic == 252) {
            return UnsignedNumberHelper.convertLittleEndianUnsignedInt(buffer, 2);
        }
        if (magic == 253) {
            return UnsignedNumberHelper.convertLittleEndianUnsignedInt(buffer, 3);
        }
        if (magic == 254) {
            if (buffer.remaining() >= 8) {
                return UnsignedNumberHelper.convertLittleEndianLong(buffer, 8);
            }
            throw new LengthEncodedIntegerEOFExp();
        }
        if (magic == 251) {
            throw new LengthEncodedIntegerNullExp();
        }
        if (magic == 255) {
            throw new LengthEncodedIntegerErrExp();
        }
        throw new RuntimeException("unknown error.");
    }

    public static byte[] getNullTerminatedByte(ByteBuffer buffer) {
        int pos = buffer.position();
        byte[] array = buffer.array();
        int endPos = array.length - 1;
        for (int i = pos; i < array.length; ++i) {
            if (0 != array[i]) continue;
            endPos = i;
            break;
        }
        byte[] vBuf = new byte[endPos - pos];
        buffer.get(vBuf);
        buffer.position(buffer.position() + 1);
        return vBuf;
    }
}

