/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.BitSet;
import net.neoremind.fountain.exception.DataErrorException;
import net.neoremind.fountain.packet.PacketHeader;
import net.neoremind.fountain.packet.Position;

public class ProtocolHelper {
    private static final int NULL_TERMINATED_STRING_DELIMITER = 0;
    public static final int NULL_LENGTH = -1;
    public static final int TINYINT_8_MAX_VALUE = 256;
    public static final int SMALLINT_16_MAX_VALUE = 65536;
    public static final int MEDIUMINT_24_MAX_VALUE = 0x1000000;
    public static final long INTEGER_32_MAX_VALUE = 0x100000000L;
    public static final BigInteger BIGINT_64_MAX_VALUE = new BigInteger("18446744073709551616");

    public static PacketHeader getProtocolHeader(byte[] data) {
        if (data == null || data.length != 4) {
            return null;
        }
        return new PacketHeader((int)ProtocolHelper.getUnsignedIntByLittleEndian(data, new Position(), 3), data[3]);
    }

    public static byte[] getNullTerminatedByte(byte[] data, Position position) {
        byte b;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        int len = data.length;
        for (int i = position.getPosition(); i < len && (b = data[i]) != 0; ++i) {
            byteStream.write(b);
        }
        byte[] result = byteStream.toByteArray();
        position.increase(result.length + 1);
        return result;
    }

    public static String getNullTerminatedString(byte[] data, Position position) {
        return new String(ProtocolHelper.getNullTerminatedByte(data, position));
    }

    public static void writeNullTerminatedString(String str, ByteArrayOutputStream out) throws IOException {
        out.write(str.getBytes());
        out.write(0);
    }

    public static int getIntByLittleEndian(byte[] data, Position position, int length) {
        return (int)ProtocolHelper.getLongByLittleEndian(data, position, length);
    }

    public static long getLongByLittleEndian(byte[] data, Position position, int length) {
        int beginPos;
        long number = 0L;
        int offsetRadio = 0;
        for (int i = beginPos = position.getPosition(); i < beginPos + length - 1; ++i) {
            long tmp = 0xFF & data[i];
            if (offsetRadio > 0) {
                tmp <<= offsetRadio * 8;
            }
            number |= tmp;
            ++offsetRadio;
        }
        long tmp = 0xFF & data[beginPos + length - 1];
        position.increase(length);
        return number |= tmp << (length - 1) * 8;
    }

    public static long getUnsignedIntByLittleEndian(byte[] data, Position position, int length) {
        int beginPos;
        long number = 0L;
        int offsetRadio = 0;
        for (int i = beginPos = position.getPosition(); i < beginPos + length; ++i) {
            long tmp = 0xFF & data[i];
            if (offsetRadio > 0) {
                tmp <<= offsetRadio * 8;
            }
            number |= tmp;
            ++offsetRadio;
        }
        position.increase(length);
        return number;
    }

    public static BigInteger getUnsignedLongByLittleEndian(byte[] data, Position position, int length) {
        long long64 = ProtocolHelper.getLongByLittleEndian(data, position, length);
        return long64 >= 0L ? BigInteger.valueOf(long64) : BIGINT_64_MAX_VALUE.add(BigInteger.valueOf(long64));
    }

    public static void writeUnsignedIntByLittleEndian(int data, ByteArrayOutputStream out) {
        out.write((byte)(data & 0xFF));
        out.write((byte)(data >>> 8));
        out.write((byte)(data >>> 16));
        out.write((byte)(data >>> 24));
    }

    public static void writeUnsignedLongByLittleEndian(long data, ByteArrayOutputStream out) {
        out.write((byte)(data & 0xFFL));
        out.write((byte)(data >>> 8));
        out.write((byte)(data >>> 16));
        out.write((byte)(data >>> 24));
        out.write((byte)(data >>> 32));
        out.write((byte)(data >>> 40));
        out.write((byte)(data >>> 48));
        out.write((byte)(data >>> 56));
    }

    public static void writeIntWithByteByLittleEndian(int data, int byteCnt, ByteArrayOutputStream out) {
        if (byteCnt >= 1) {
            out.write((byte)(data & 0xFF));
        }
        if (byteCnt >= 2) {
            out.write((byte)(data >>> 8));
        }
        if (byteCnt >= 3) {
            out.write((byte)(data >>> 16));
        }
        if (byteCnt >= 4) {
            out.write((byte)(data >>> 24));
        }
    }

    public static float getFloatByLittleEndian(byte[] data, Position position) {
        int cnt = ProtocolHelper.getIntByLittleEndian(data, position, 4);
        return Float.intBitsToFloat(cnt);
    }

    public static double getDoubleByLittleEndian(byte[] data, Position position) {
        long cnt = ProtocolHelper.getLongByLittleEndian(data, position, 8);
        return Double.doubleToLongBits(cnt);
    }

    public static byte[] getFixedBytes(byte[] data, Position position, int length) {
        byte[] result = new byte[length];
        System.arraycopy(data, position.getPosition(), result, 0, length);
        position.increase(length);
        return result;
    }

    public static void writeLengthCodedBinary(byte[] data, ByteArrayOutputStream out) throws IOException {
        if (data.length < 251) {
            out.write(data.length);
        } else if (data.length < 65536) {
            out.write(252);
            ProtocolHelper.writeIntWithByteByLittleEndian(data.length, 2, out);
        } else if (data.length < 0x1000000) {
            out.write(253);
            ProtocolHelper.writeIntWithByteByLittleEndian(data.length, 3, out);
        } else {
            out.write(254);
            ProtocolHelper.writeIntWithByteByLittleEndian(data.length, 4, out);
        }
        out.write(data);
        out.toByteArray();
    }

    public static byte[] getLengthCodedBytes(byte[] data, Position position) {
        byte firstByte = (byte)ProtocolHelper.getUnsignedIntByLittleEndian(data, position, 1);
        if (firstByte == 251) {
            return new byte[0];
        }
        if (firstByte < 251) {
            return new byte[]{firstByte};
        }
        switch (firstByte) {
            case -4: {
                return ProtocolHelper.getFixedBytes(data, position, 2);
            }
            case -3: {
                return ProtocolHelper.getFixedBytes(data, position, 3);
            }
            case -2: {
                byte[] b = ProtocolHelper.getFixedBytes(data, position, 4);
                position.increase(4);
                return b;
            }
        }
        throw new DataErrorException("length coded length do not valid");
    }

    public static long getLengthCodedLength(byte[] data, Position position) {
        int firstByte = (int)ProtocolHelper.getUnsignedIntByLittleEndian(data, position, 1);
        if (firstByte == 251) {
            return -1L;
        }
        if (firstByte < 251) {
            return firstByte;
        }
        switch (firstByte) {
            case 252: {
                return ProtocolHelper.getUnsignedIntByLittleEndian(data, position, 2);
            }
            case 253: {
                return ProtocolHelper.getUnsignedIntByLittleEndian(data, position, 3);
            }
            case 254: {
                long result = ProtocolHelper.getUnsignedIntByLittleEndian(data, position, 4);
                position.increase(4);
                return result;
            }
        }
        throw new DataErrorException("length coded length do not valid");
    }

    public static void fillBitMap(byte[] data, Position position, int columnsLength, BitSet bitSet) {
        for (int index = 0; index < columnsLength; index += 8) {
            byte tmpByte = ProtocolHelper.getFixedBytes(data, position, 1)[0];
            if ((tmpByte & 1) != 0) {
                bitSet.set(index);
            }
            if ((tmpByte & 2) != 0) {
                bitSet.set(index + 1);
            }
            if ((tmpByte & 4) != 0) {
                bitSet.set(index + 2);
            }
            if ((tmpByte & 8) != 0) {
                bitSet.set(index + 3);
            }
            if ((tmpByte & 0x10) != 0) {
                bitSet.set(index + 4);
            }
            if ((tmpByte & 0x20) != 0) {
                bitSet.set(index + 5);
            }
            if ((tmpByte & 0x40) != 0) {
                bitSet.set(index + 6);
            }
            if ((tmpByte & 0x80) == 0) continue;
            bitSet.set(index + 7);
        }
    }

    public static final String toAsciiString(byte[] buffer, int startPos, int length) {
        char[] charArray = new char[length];
        int readpoint = startPos;
        for (int i = 0; i < length; ++i) {
            charArray[i] = (char)buffer[readpoint];
            ++readpoint;
        }
        return new String(charArray);
    }

    public static final String toAsciiString(byte[] buffer) {
        return ProtocolHelper.toAsciiString(buffer, 0, buffer.length);
    }
}

