/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.util;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import net.neoremind.fountain.exception.EOFException;
import net.neoremind.fountain.exception.HalfDataSocketTimeoutException;
import net.neoremind.fountain.exception.ParamErrorException;
import org.apache.commons.lang3.ArrayUtils;

public class SocketHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBuffer(Socket socket, int len) throws IOException {
        if (socket == null || len <= 0) {
            throw new ParamErrorException("Socket is null or len <= 0");
        }
        byte[] buffer = new byte[len];
        int pos = 0;
        Socket socket2 = socket;
        synchronized (socket2) {
            int cnt;
            for (int remainSize = len; remainSize > 0; remainSize -= cnt) {
                cnt = 0;
                try {
                    cnt = socket.getInputStream().read(buffer, pos, remainSize);
                }
                catch (SocketTimeoutException e) {
                    if (pos > 0) {
                        throw new HalfDataSocketTimeoutException();
                    }
                    throw e;
                }
                if (cnt == -1) {
                    throw new EOFException("Cannot read any bytes from socket stream");
                }
                pos += cnt;
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeByte(Socket socket, byte[] data) throws IOException {
        if (socket == null || ArrayUtils.isEmpty((byte[])data)) {
            throw new ParamErrorException("Channel is null or data is empty");
        }
        Socket socket2 = socket;
        synchronized (socket2) {
            socket.getOutputStream().write(data);
        }
    }
}

