/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.util;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class UnsignedNumberHelper {
    private static final int INT_SIZE = 4;
    private static final int LONG_SIZE = 8;
    private static final String DEFAULT_CHARSET = "utf-8";
    private static final long UNSIGNED_INT_MAX = 0xFFFFFFFFL;
    private static final int UNSIGNED_BYTE_MAX = 255;
    private static final ThreadLocal<String> charSet = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return UnsignedNumberHelper.DEFAULT_CHARSET;
        }
    };

    public static long toUnsignedInt(long value) {
        return value &= 0xFFFFFFFFL;
    }

    public static void configCharset(String charset) {
        charSet.set(charset);
    }

    public static int toUnsignedByte(int value) {
        return value &= 0xFF;
    }

    public static BigInteger convertLittleEndianLongByteArray2BigInteger(byte[] buf) {
        for (int i = 0; i < buf.length / 2; ++i) {
            byte tmp = buf[i];
            buf[i] = buf[buf.length - i - 1];
            buf[buf.length - i - 1] = tmp;
        }
        return new BigInteger(1, buf);
    }

    public static String convertByteArray2String(byte[] buf) {
        String str = null;
        try {
            str = new String(buf, charSet.get());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    public static String convertByteArray2String(byte[] buf, String chset) {
        String str = null;
        try {
            str = new String(buf, chset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    public static long convertLittleEndianUnsignedInt(ByteBuffer buff, int size) {
        if (size <= 0 || size > 4) {
            throw new IllegalArgumentException("size MUST be less 4.");
        }
        byte[] array = new byte[size];
        buff.get(array);
        ByteBuffer bbf = ByteBuffer.allocate(4);
        bbf.put(array);
        bbf.order(ByteOrder.LITTLE_ENDIAN);
        if (size < 4) {
            bbf.position(4);
        }
        bbf.flip();
        return (long)bbf.getInt() & 0xFFFFFFFFL;
    }

    public static long convertLittleEndianLong(ByteBuffer buff, int size) {
        if (size <= 0 || size > 8) {
            throw new IllegalArgumentException("size MUST be less 8.");
        }
        byte[] array = new byte[size];
        buff.get(array);
        ByteBuffer bbf = ByteBuffer.allocate(8);
        bbf.put(array);
        bbf.order(ByteOrder.LITTLE_ENDIAN);
        if (size < 8) {
            bbf.position(8);
        }
        bbf.flip();
        return bbf.getLong();
    }
}

