/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.haguard.zk;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.neoremind.haguard.AbstractHaGuard;
import net.neoremind.haguard.HaGuard;
import net.neoremind.simplezkclient.ZkClientProvider;
import net.neoremind.util.NetUtils;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkHaGuard
extends AbstractHaGuard
implements HaGuard,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ZkHaGuard.class);
    private ZkClientProvider zkClientProvider;
    private String latchPath;
    private LeaderLatch leaderLatch;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);

    public void init(String name) {
        if (!this.state.compareAndSet(State.LATENT, State.STARTED)) {
            logger.debug("ZkHaGuard can only be initialized once because LeaderLatch should be singleton");
            return;
        }
        if (this.zkClientProvider == null) {
            throw new IllegalStateException("ZkClientProvider should not be null");
        }
        logger.info("LeaderLatch will start soon by " + name);
        this.zkClientProvider.init();
        this.leaderLatch = new LeaderLatch(this.zkClientProvider.provideClient(), this.latchPath, NetUtils.getLocalHostIP());
        this.leaderLatch.addListener(new LeaderLatchListener(){

            public void isLeader() {
                logger.info("This instance is leader");
            }

            public void notLeader() {
                logger.warn("This instance is NOT leader");
            }
        });
        try {
            this.leaderLatch.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Leader latch init failed", e);
        }
        logger.info("LeaderLatch starts by " + name + " asynchronously");
    }

    @Override
    public void close() {
        if (this.latchPath != null) {
            try {
                this.leaderLatch.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Leader latch destroy failed", e);
            }
        }
        if (this.zkClientProvider != null) {
            this.zkClientProvider.destory();
        }
        this.state.compareAndSet(State.STARTED, State.DESTROYED);
    }

    public boolean takeToken(long timeout) {
        try {
            return this.leaderLatch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public boolean takeTokenWithDefaultTimeout() {
        return this.takeToken(this.getDefaultTimeoutMs());
    }

    public boolean hasToken() {
        return this.leaderLatch.hasLeadership();
    }

    public ZkClientProvider getZkClientProvider() {
        return this.zkClientProvider;
    }

    public void setZkClientProvider(ZkClientProvider zkClientProvider) {
        this.zkClientProvider = zkClientProvider;
    }

    public String getLatchPath() {
        return this.latchPath;
    }

    public void setLatchPath(String latchPath) {
        this.latchPath = latchPath;
    }

    public static enum State {
        LATENT,
        STARTED,
        DESTROYED;

    }
}

