/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.dj.swingsuite;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.Collator;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import net.nextencia.dj.swingsuite.FilterableTableHeader;
import net.nextencia.dj.swingsuite.JLink;
import net.nextencia.dj.swingsuite.JNumberEntryField;
import net.nextencia.dj.swingsuite.JTriStateCheckBox;
import net.nextencia.dj.swingsuite.LinkListener;
import net.nextencia.dj.swingsuite.TriStateCheckBoxListener;

public class DefaultTableHeaderFilter
implements FilterableTableHeader.TableHeaderFilter {
    private Map<Integer, FilterData> columnToFilterDataMap = new HashMap<Integer, FilterData>();
    private NumberFormat integerFormat;
    private NumberFormat doubleFormat;
    private DateFormat dateFormat;

    protected FilterDialog getModalDialog(JTable table, JComponent content, String title) {
        DefaultFilterDialog dialog = new DefaultFilterDialog();
        dialog.setModal(true);
        dialog.setTitle(title);
        dialog.getContentPane().add((Component)content, "Center");
        dialog.pack();
        dialog.setMinimumSize(dialog.getPreferredSize());
        dialog.setLocationRelativeTo(SwingUtilities.getWindowAncestor(table));
        return dialog;
    }

    @Override
    public boolean isFilterActive(int column) {
        return this.columnToFilterDataMap.containsKey(column);
    }

    private FilterData getFilterData(int column) {
        return this.columnToFilterDataMap.get(column);
    }

    private void setFilterData(int column, FilterData filterData) {
        if (filterData == null) {
            this.columnToFilterDataMap.remove(column);
        } else {
            this.columnToFilterDataMap.put(column, filterData);
        }
    }

    @Override
    public JPopupMenu getFilterEditor(FilterableTableHeader filterableTableHeader, TableModel tableModel, int column, int[] rows, final Comparator<Object> valueComparator) {
        HashMap<Object, String> valueToTextMap = new HashMap<Object, String>();
        for (int i = 0; i < rows.length; ++i) {
            int row = rows[i];
            Object o = tableModel.getValueAt(row, column);
            valueToTextMap.put(o, this.convertToString(o, tableModel, row, column));
        }
        Object[] values = valueToTextMap.keySet().toArray();
        Arrays.sort(values, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (valueComparator instanceof Collator) {
                    if (!(o1 instanceof String)) {
                        o1 = o1.toString();
                    }
                    if (!(o2 instanceof String)) {
                        o2 = o2.toString();
                    }
                }
                return valueComparator.compare(o1, o2);
            }
        });
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setLayout(new BorderLayout());
        FilterEditor filterEditor = new FilterEditor(column, filterableTableHeader, this, popupMenu, values, valueToTextMap);
        popupMenu.add((Component)filterEditor, "Center");
        return popupMenu;
    }

    protected String convertToString(Object value, TableModel tableModel, int row, int column) {
        if (value == null) {
            return "(empty)";
        }
        if (value instanceof Number) {
            String text = value instanceof Integer || value instanceof Long ? this.getIntegerFormat().format(value) : this.getDoubleFormat().format(value);
            boolean isWithUntypableChars = false;
            for (int i = text.length() - 1; i >= 0; --i) {
                switch (text.charAt(i)) {
                    case '\u00a0': 
                    case '\u2212': {
                        isWithUntypableChars = true;
                    }
                }
            }
            if (isWithUntypableChars && (text = text.replace('\u00a0', ' ')).startsWith("\u2212")) {
                text = '-' + text.substring(1);
            }
            return text;
        }
        if (value instanceof Date) {
            return this.getDateFormat().format(value);
        }
        return String.valueOf(value);
    }

    private NumberFormat getIntegerFormat() {
        if (this.integerFormat == null) {
            this.integerFormat = DecimalFormat.getIntegerInstance();
        }
        return this.integerFormat;
    }

    private NumberFormat getDoubleFormat() {
        if (this.doubleFormat == null) {
            this.doubleFormat = DecimalFormat.getInstance();
        }
        return this.doubleFormat;
    }

    private DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getDateInstance(3);
        }
        return this.dateFormat;
    }

    @Override
    public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry, int column) {
        FilterData filterData = this.getFilterData(column);
        return filterData == null || filterData.include(entry, column);
    }

    @Override
    public void clearFilter(int column) {
        this.setFilterData(column, null);
    }

    private static class DefaultFilterDialog
    extends JDialog
    implements FilterDialog {
        private DefaultFilterDialog() {
        }

        @Override
        public void openDialog() {
            this.setVisible(true);
        }

        @Override
        public void disposeDialog() {
            this.dispose();
        }
    }

    protected static interface FilterDialog {
        public void openDialog();

        public void disposeDialog();
    }

    private class FilterEditor
    extends JPanel {
        private boolean isAdjusting;
        private List<JComponent> mainFilterComponentList;
        private JTriStateCheckBox selectAllCheckBox;
        private List<JCheckBox> checkBoxList;
        private Set<Object> newAcceptedValueSet;
        private JButton okButton;
        private JTextField filterTextField;
        private JPanel contentPane;
        private FilterData filterData;
        private Object[] values;
        private Map<Object, String> valueToTextMap;
        private boolean isAddingToCurrentFilter;
        private int column;
        private FilterableTableHeader filterableTableHeader;
        private DefaultTableHeaderFilter headerFilter;
        private boolean isCustomFilterActive;
        private JPopupMenu popupMenu;
        private String filter;

        public FilterEditor(final int column, final FilterableTableHeader filterableTableHeader, final DefaultTableHeaderFilter headerFilter, final JPopupMenu popupMenu, Object[] values, Map<Object, String> valueToTextMap) {
            super(new BorderLayout());
            this.popupMenu = popupMenu;
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.column = column;
            this.filterableTableHeader = filterableTableHeader;
            this.headerFilter = headerFilter;
            this.filterData = DefaultTableHeaderFilter.this.getFilterData(column);
            if (this.filterData == null) {
                this.filterData = new FilterData();
            }
            this.isCustomFilterActive = this.filterData.getNumberFilter() != null;
            this.values = values;
            this.valueToTextMap = valueToTextMap;
            this.okButton = new JButton("OK");
            JPanel northPane = new JPanel(new BorderLayout());
            northPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
            this.filterTextField = new JTextField();
            this.filterTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FilterEditor.this.okButton.doClick();
                }
            });
            this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){
                private volatile Thread thread;

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.adjustFilter();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.adjustFilter();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.adjustFilter();
                }

                private void adjustFilter() {
                    this.thread = new Thread("Table filter delay"){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            final 1 current = this;
                            if (thread != current) {
                                return;
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (thread != current) {
                                        return;
                                    }
                                    String filter = FilterEditor.this.filterTextField.getText();
                                    if (filter.length() == 0) {
                                        filter = null;
                                    }
                                    FilterEditor.this.setFilter(filter);
                                    thread = null;
                                }
                            });
                        }
                    };
                    this.thread.setDaemon(true);
                    this.thread.start();
                }
            });
            northPane.add((Component)this.filterTextField, "Center");
            this.add((Component)northPane, "North");
            this.contentPane = new JPanel(new BorderLayout());
            this.populateContentPane();
            this.add((Component)this.contentPane, "Center");
            JPanel southPane = new JPanel(new BorderLayout());
            southPane.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            JPanel buttonPane = new JPanel(new GridLayout(1, 2));
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!FilterEditor.this.isCustomFilterActive) {
                        switch (FilterEditor.this.selectAllCheckBox.getState()) {
                            case SELECTED: {
                                if (FilterEditor.this.filter == null) {
                                    DefaultTableHeaderFilter.this.setFilterData(column, null);
                                    break;
                                }
                                if (FilterEditor.this.isAddingToCurrentFilter) {
                                    FilterEditor.this.newAcceptedValueSet.addAll(FilterEditor.this.filterData.getAcceptedValueSet());
                                }
                                FilterEditor.this.filterData.setAcceptedValueSet(FilterEditor.this.newAcceptedValueSet);
                                DefaultTableHeaderFilter.this.setFilterData(column, FilterEditor.this.filterData);
                                break;
                            }
                            case NOT_SELECTED: {
                                if (FilterEditor.this.isAddingToCurrentFilter) break;
                                FilterEditor.this.filterData.setAcceptedValueSet(new HashSet<Object>());
                                DefaultTableHeaderFilter.this.setFilterData(column, FilterEditor.this.filterData);
                                break;
                            }
                            case INDETERMINATE: {
                                if (FilterEditor.this.isAddingToCurrentFilter) {
                                    FilterEditor.this.newAcceptedValueSet.addAll(FilterEditor.this.filterData.getAcceptedValueSet());
                                }
                                FilterEditor.this.filterData.setAcceptedValueSet(FilterEditor.this.newAcceptedValueSet);
                                DefaultTableHeaderFilter.this.setFilterData(column, FilterEditor.this.filterData);
                            }
                        }
                    }
                    popupMenu.setVisible(false);
                    filterableTableHeader.notifyFilterChanged(new int[]{column}, new FilterableTableHeader.TableHeaderFilter[]{headerFilter});
                }
            });
            buttonPane.add(this.okButton);
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    popupMenu.setVisible(false);
                }
            });
            buttonPane.add(cancelButton);
            southPane.add((Component)buttonPane, "East");
            this.add((Component)southPane, "South");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FilterEditor.this.filterTextField.requestFocusInWindow();
                }
            });
        }

        private void populateContentPane() {
            this.contentPane.removeAll();
            JPanel centerPane = new JPanel(new BorderLayout());
            JPanel mainPane = new JPanel(new BorderLayout());
            ScrollablePanel checkBoxPane = new ScrollablePanel(new GridBagLayout());
            checkBoxPane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            checkBoxPane.setBackground(UIManager.getColor("TextField.background"));
            this.checkBoxList = new ArrayList<JCheckBox>();
            Insets emptyInsets = new Insets(0, 0, 0, 0);
            int y = 0;
            this.newAcceptedValueSet = new HashSet<Object>();
            this.mainFilterComponentList = new ArrayList<JComponent>();
            this.selectAllCheckBox = null;
            boolean isLimiting = false;
            String filterLC = this.filter;
            if (filterLC != null) {
                filterLC = filterLC.toLowerCase();
            }
            this.isAddingToCurrentFilter = false;
            int itemCount = 0;
            int maxItemCount = 2000;
            Set<Object> acceptedValueSet = this.filterData.getAcceptedValueSet();
            final NumberCustomFilter numberFilter = this.filterData.getNumberFilter();
            boolean hasNumbers = false;
            String groupingSeparator = null;
            String filterLCNoGroupingSeparator = null;
            for (int i = 0; i < this.values.length; ++i) {
                final Object value = this.values[i];
                if (itemCount >= maxItemCount) {
                    isLimiting = true;
                }
                boolean isNumber = value instanceof Number;
                hasNumbers |= isNumber;
                if (isLimiting) continue;
                String text = this.valueToTextMap.get(value);
                boolean isRetained = true;
                if (filterLC != null && !(isRetained = text.toLowerCase().contains(filterLC)) && isNumber) {
                    String newText;
                    if (groupingSeparator == null) {
                        char groupingSeparatorChar = ((DecimalFormat)DecimalFormat.getInstance()).getDecimalFormatSymbols().getGroupingSeparator();
                        if (groupingSeparatorChar == '\u00a0') {
                            groupingSeparatorChar = ' ';
                        }
                        groupingSeparator = String.valueOf(groupingSeparatorChar);
                        filterLCNoGroupingSeparator = filterLC.replace(groupingSeparator, "");
                    }
                    if ((newText = text.replace(groupingSeparator, "")).length() < text.length()) {
                        isRetained = newText.contains(filterLCNoGroupingSeparator);
                    }
                }
                if (!isRetained) continue;
                if (itemCount == 0) {
                    this.selectAllCheckBox = new JTriStateCheckBox("(Select all)");
                    this.selectAllCheckBox.setRollingStates(JTriStateCheckBox.CheckState.SELECTED, JTriStateCheckBox.CheckState.NOT_SELECTED);
                    this.selectAllCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                    this.selectAllCheckBox.setOpaque(false);
                    this.mainFilterComponentList.add(this.selectAllCheckBox);
                    checkBoxPane.add((Component)this.selectAllCheckBox, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, emptyInsets, 0, 0));
                    if (filterLC != null && acceptedValueSet != null) {
                        JCheckBox addSelectionCheckBox = new JCheckBox("Add selection to current filter");
                        addSelectionCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                        addSelectionCheckBox.setOpaque(false);
                        this.mainFilterComponentList.add(addSelectionCheckBox);
                        addSelectionCheckBox.addItemListener(new ItemListener(){

                            @Override
                            public void itemStateChanged(ItemEvent e) {
                                FilterEditor.this.isAddingToCurrentFilter = e.getStateChange() == 1;
                            }
                        });
                        checkBoxPane.add((Component)addSelectionCheckBox, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, emptyInsets, 0, 0));
                    }
                }
                JCheckBox checkBox = new JCheckBox(text);
                checkBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                checkBox.setOpaque(false);
                this.mainFilterComponentList.add(checkBox);
                boolean isSelected = acceptedValueSet == null || acceptedValueSet.contains(value);
                checkBox.setSelected(isSelected);
                if (isSelected) {
                    this.newAcceptedValueSet.add(value);
                }
                checkBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        boolean isSelected;
                        boolean bl = isSelected = e.getStateChange() == 1;
                        if (isSelected) {
                            FilterEditor.this.newAcceptedValueSet.add(value);
                        } else {
                            FilterEditor.this.newAcceptedValueSet.remove(value);
                        }
                        if (FilterEditor.this.isAdjusting) {
                            return;
                        }
                        FilterEditor.this.adjustSelectAllCheckBoxState();
                    }
                });
                this.checkBoxList.add(checkBox);
                checkBoxPane.add((Component)checkBox, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, emptyInsets, 0, 0));
                ++itemCount;
            }
            if (itemCount == 0) {
                JLabel noItemsLabel = new JLabel("No corresponding items.");
                noItemsLabel.setFont(noItemsLabel.getFont().deriveFont(2));
                checkBoxPane.add((Component)noItemsLabel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, emptyInsets, 0, 0));
            }
            checkBoxPane.add(Box.createVerticalGlue(), new GridBagConstraints(0, y++, 1, 1, 1.0, 1.0, 17, 2, emptyInsets, 0, 0));
            this.adjustSelectAllCheckBoxState();
            this.okButton.setEnabled(this.selectAllCheckBox != null && this.selectAllCheckBox.getState() != JTriStateCheckBox.CheckState.NOT_SELECTED);
            if (this.selectAllCheckBox != null) {
                this.selectAllCheckBox.addTriStateCheckBoxListener(new TriStateCheckBoxListener(){

                    @Override
                    public void stateChanged(JTriStateCheckBox triStateCheckBox, JTriStateCheckBox.CheckState checkState) {
                        FilterEditor.this.okButton.setEnabled(checkState != JTriStateCheckBox.CheckState.NOT_SELECTED);
                        if (FilterEditor.this.isAdjusting) {
                            return;
                        }
                        FilterEditor.this.isAdjusting = true;
                        for (JCheckBox checkBox : FilterEditor.this.checkBoxList) {
                            checkBox.setSelected(checkState == JTriStateCheckBox.CheckState.SELECTED);
                        }
                        FilterEditor.this.isAdjusting = false;
                    }
                });
                if (filterLC != null) {
                    this.selectAllCheckBox.setSelected(true);
                }
            }
            JScrollPane scrollPane = new JScrollPane(checkBoxPane);
            Dimension preferredSize = scrollPane.getPreferredSize();
            preferredSize.width = 200;
            preferredSize.height = 200;
            scrollPane.setPreferredSize(preferredSize);
            mainPane.add((Component)scrollPane, "Center");
            if (isLimiting) {
                mainPane.add((Component)new JLabel("Only the first " + maxItemCount + " unique items are displayed.", new ImageIcon(DefaultTableHeaderFilter.class.getResource("resource/warning_obj.png")), 10), "South");
            }
            centerPane.add((Component)mainPane, "Center");
            if (hasNumbers || numberFilter != null) {
                JPanel numberFilterPane = new JPanel(new GridBagLayout());
                JCheckBox numberFilterCheckBox = new JCheckBox("Number filter");
                final Runnable showDialogRunnable = new Runnable(){

                    @Override
                    public void run() {
                        JPanel contentPane = new JPanel(new BorderLayout());
                        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                        JPanel numberFilterContentPane = new JPanel(new GridBagLayout());
                        final JComboBox<Operator> operator1ComboBox = new JComboBox<Operator>(Operator.values());
                        numberFilterContentPane.add(operator1ComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
                        final JNumberEntryField<Object> value1NumberField = new JNumberEntryField<Object>(0.0, 14, null, null, true);
                        value1NumberField.setNumber(null);
                        numberFilterContentPane.add(value1NumberField, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 0), 0, 0));
                        final JComboBox<String> andComboBox = new JComboBox<String>(new String[]{" ", "and", "or"});
                        numberFilterContentPane.add(andComboBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 0), 0, 0));
                        final JComboBox<Operator> operator2ComboBox = new JComboBox<Operator>(Operator.values());
                        operator2ComboBox.setEnabled(false);
                        numberFilterContentPane.add(operator2ComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 0), 0, 0));
                        final JNumberEntryField<Object> value2NumberField = new JNumberEntryField<Object>(0.0, 14, null, null, true);
                        value2NumberField.setNumber(null);
                        value2NumberField.setEnabled(false);
                        andComboBox.addItemListener(new ItemListener(){

                            @Override
                            public void itemStateChanged(ItemEvent e) {
                                boolean isEnabled = andComboBox.getSelectedIndex() > 0;
                                operator2ComboBox.setEnabled(isEnabled);
                                value2NumberField.setEnabled(isEnabled);
                            }
                        });
                        numberFilterContentPane.add(value2NumberField, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 0, 0), 0, 0));
                        if (numberFilter != null) {
                            operator1ComboBox.setSelectedItem((Object)numberFilter.getOperator1());
                            value1NumberField.setNumber(numberFilter.getValue1());
                            Operator operator2 = numberFilter.getOperator2();
                            if (operator2 != null) {
                                andComboBox.setSelectedIndex(numberFilter.isOr() ? 2 : 1);
                                operator2ComboBox.setSelectedItem((Object)operator2);
                                value2NumberField.setNumber(numberFilter.getValue2());
                            }
                        }
                        contentPane.add((Component)numberFilterContentPane, "Center");
                        JPanel southPane = new JPanel(new BorderLayout());
                        southPane.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
                        JPanel buttonPane = new JPanel(new GridLayout(1, 2));
                        JButton okButton = new JButton("OK");
                        buttonPane.add(okButton);
                        JButton cancelButton = new JButton("Cancel");
                        buttonPane.add(cancelButton);
                        southPane.add((Component)buttonPane, "East");
                        contentPane.add((Component)southPane, "South");
                        FilterEditor.this.popupMenu.setVisible(false);
                        final FilterDialog dialog = DefaultTableHeaderFilter.this.getModalDialog(FilterEditor.this.filterableTableHeader.getTable(), contentPane, "Number filter");
                        okButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                NumberCustomFilter newNumberFilter = new NumberCustomFilter();
                                newNumberFilter.setFilter1((Operator)((Object)operator1ComboBox.getSelectedItem()), (Double)value1NumberField.getNumber());
                                switch (andComboBox.getSelectedIndex()) {
                                    case 0: {
                                        newNumberFilter.setFilter2(null, null, false);
                                        break;
                                    }
                                    case 1: {
                                        newNumberFilter.setFilter2((Operator)((Object)operator2ComboBox.getSelectedItem()), (Double)value2NumberField.getNumber(), false);
                                        break;
                                    }
                                    case 2: {
                                        newNumberFilter.setFilter2((Operator)((Object)operator2ComboBox.getSelectedItem()), (Double)value2NumberField.getNumber(), true);
                                    }
                                }
                                FilterEditor.this.filterData.setNumberFilter(newNumberFilter);
                                DefaultTableHeaderFilter.this.setFilterData(FilterEditor.this.column, FilterEditor.this.filterData);
                                dialog.disposeDialog();
                                FilterEditor.this.filterableTableHeader.notifyFilterChanged(new int[]{FilterEditor.this.column}, new FilterableTableHeader.TableHeaderFilter[]{FilterEditor.this.headerFilter});
                            }
                        });
                        cancelButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                dialog.disposeDialog();
                            }
                        });
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                value1NumberField.requestFocusInWindow();
                            }
                        });
                        dialog.openDialog();
                    }
                };
                numberFilterPane.add((Component)numberFilterCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, emptyInsets, 0, 0));
                final JLink<Object> configureLink = new JLink<Object>("(edit)", null);
                configureLink.setVisible(false);
                configureLink.addLinkListener((LinkListener<Object>)new LinkListener<Void>(){

                    @Override
                    public boolean linkActivated(JLink<Void> link, Void target) {
                        showDialogRunnable.run();
                        return false;
                    }
                });
                numberFilterPane.add(configureLink, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, emptyInsets, 0, 0));
                numberFilterCheckBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        boolean isWithFilter = e.getStateChange() == 1;
                        configureLink.setVisible(isWithFilter);
                        if (numberFilter == null && isWithFilter) {
                            showDialogRunnable.run();
                        }
                        FilterEditor.this.filterTextField.setEnabled(!isWithFilter);
                        for (JComponent component : FilterEditor.this.mainFilterComponentList) {
                            component.setEnabled(!isWithFilter);
                        }
                        FilterEditor.this.isCustomFilterActive = isWithFilter;
                    }
                });
                numberFilterCheckBox.setSelected(this.isCustomFilterActive);
                numberFilterPane.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, emptyInsets, 0, 0));
                centerPane.add((Component)numberFilterPane, "South");
            }
            this.contentPane.add((Component)centerPane, "Center");
            this.contentPane.revalidate();
            this.contentPane.repaint();
        }

        private void setFilter(String filter) {
            if (filter != null && filter.equals(this.filter) || filter == this.filter) {
                return;
            }
            this.filter = filter;
            this.populateContentPane();
        }

        private void adjustSelectAllCheckBoxState() {
            if (this.selectAllCheckBox == null) {
                return;
            }
            this.isAdjusting = true;
            boolean hasSelected = false;
            boolean hasDeselected = false;
            for (JCheckBox checkBox : this.checkBoxList) {
                if (checkBox.isSelected()) {
                    hasSelected = true;
                } else {
                    hasDeselected = true;
                }
                if (!hasSelected || !hasDeselected) continue;
                break;
            }
            this.selectAllCheckBox.setState(hasSelected ? (hasDeselected ? JTriStateCheckBox.CheckState.INDETERMINATE : JTriStateCheckBox.CheckState.SELECTED) : JTriStateCheckBox.CheckState.NOT_SELECTED);
            this.isAdjusting = false;
        }
    }

    private static class ScrollablePanel
    extends JPanel
    implements Scrollable {
        private int unit;

        public ScrollablePanel(LayoutManager layoutManager) {
            super(layoutManager);
            JCheckBox checkBox = new JCheckBox();
            checkBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.unit = checkBox.getPreferredSize().height + 2;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.unit;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.unit * 3;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.getParent().getHeight() > this.getPreferredSize().height;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return this.getParent().getWidth() > this.getPreferredSize().width;
        }
    }

    private static class FilterData {
        private Set<Object> acceptedValueSet;
        private NumberCustomFilter numberFilter;

        private FilterData() {
        }

        public void setAcceptedValueSet(Set<Object> acceptedValueSet) {
            this.acceptedValueSet = acceptedValueSet;
        }

        public Set<Object> getAcceptedValueSet() {
            return this.acceptedValueSet;
        }

        public void setNumberFilter(NumberCustomFilter numberFilter) {
            this.numberFilter = numberFilter;
        }

        public NumberCustomFilter getNumberFilter() {
            return this.numberFilter;
        }

        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry, int column) {
            if (this.numberFilter != null) {
                return this.numberFilter.include(entry, column);
            }
            return this.acceptedValueSet.contains(entry.getValue(column));
        }
    }

    private static class NumberCustomFilter {
        private Operator operator1;
        private Double value1;
        private boolean isOr;
        private Operator operator2;
        private Double value2;

        private NumberCustomFilter() {
        }

        public Operator getOperator1() {
            return this.operator1;
        }

        public Double getValue1() {
            return this.value1;
        }

        public void setFilter1(Operator operator1, Double value1) {
            this.operator1 = operator1;
            this.value1 = value1;
        }

        public boolean isOr() {
            return this.isOr;
        }

        public Operator getOperator2() {
            return this.operator2;
        }

        public Double getValue2() {
            return this.value2;
        }

        public void setFilter2(Operator operator1, Double value2, boolean isOr) {
            this.operator2 = operator1;
            this.value2 = value2;
            this.isOr = isOr;
        }

        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry, int column) {
            Object refValue = entry.getValue(column);
            boolean isIncluded1 = this.isIncluded(refValue, this.operator1, this.value1);
            if (isIncluded1 && this.isOr || this.operator2 == null || !isIncluded1 && !this.isOr) {
                return isIncluded1;
            }
            boolean isIncluded2 = this.isIncluded(refValue, this.operator2, this.value2);
            return isIncluded2;
        }

        private boolean isIncluded(Object refValue, Operator operator, Double value) {
            boolean isIncluded = false;
            switch (operator) {
                case EQUAL: {
                    isIncluded = refValue == null ? value == null : refValue instanceof Number && value != null && ((Number)refValue).doubleValue() == value.doubleValue();
                    break;
                }
                case DIFFERENT: {
                    isIncluded = refValue == null ? value != null : refValue instanceof Number && (value == null || ((Number)refValue).doubleValue() != value.doubleValue());
                    break;
                }
                case GREATER_THAN: {
                    isIncluded = refValue instanceof Number && value != null && ((Number)refValue).doubleValue() >= value;
                    break;
                }
                case STRICTLY_GREATER_THAN: {
                    isIncluded = refValue instanceof Number && value != null && ((Number)refValue).doubleValue() > value;
                    break;
                }
                case LESS_THAN: {
                    isIncluded = refValue instanceof Number && value != null && ((Number)refValue).doubleValue() <= value;
                    break;
                }
                case STRICTLY_LESS_THAN: {
                    isIncluded = refValue instanceof Number && value != null && ((Number)refValue).doubleValue() < value;
                }
            }
            return isIncluded;
        }
    }

    private static enum Operator {
        EQUAL{

            public String toString() {
                return "=";
            }
        }
        ,
        DIFFERENT{

            public String toString() {
                return "\u2260";
            }
        }
        ,
        GREATER_THAN{

            public String toString() {
                return "\u2265";
            }
        }
        ,
        STRICTLY_GREATER_THAN{

            public String toString() {
                return ">";
            }
        }
        ,
        LESS_THAN{

            public String toString() {
                return "\u2264";
            }
        }
        ,
        STRICTLY_LESS_THAN{

            public String toString() {
                return "<";
            }
        };

    }
}

