/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.dj.swingsuite;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventListener;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class FilterableTableHeader
extends JTableHeader {
    private static final ImageIcon FILTER_ICON = new ImageIcon(FilterableTableHeader.class.getResource("resource/TableColumnFilter16x12.png"));
    private static final ImageIcon FILTER_ACTIVE_ICON = new ImageIcon(FilterableTableHeader.class.getResource("resource/TableColumnFilterOn16x12.png"));
    private static final int ICON_WIDTH = 16;
    private static final int ICON_HEIGHT = 12;
    private static final int BOTTOM_OFFSET = 4;
    private static final int RIGHT_OFFSET = 4;
    private int columnWithPopupVisible = -1;
    private Point location;
    private int hoveredColumn = -1;
    private boolean isOnHitZone;
    private TableHeaderFilter[] headerFilters = new TableHeaderFilter[0];
    private int[] activeFilterIndexes = new int[0];
    private RowFilter<TableModel, Integer> rowFilter = new RowFilter<TableModel, Integer>(){

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            if (FilterableTableHeader.this.activeFilterIndexes.length == 0) {
                return true;
            }
            for (int i = 0; i < FilterableTableHeader.this.activeFilterIndexes.length; ++i) {
                int column = FilterableTableHeader.this.activeFilterIndexes[i];
                TableHeaderFilter headerFilter = FilterableTableHeader.this.headerFilters[column];
                if (headerFilter == null || !headerFilter.isFilterActive(column) || headerFilter.include(entry, column)) continue;
                return false;
            }
            return true;
        }
    };

    public FilterableTableHeader(JTable table) {
        super(table.getColumnModel());
        if (table.getRowSorter() == null) {
            throw new IllegalStateException("The table does not have a row sorter, which is mandatory to have a filtering header!");
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.activeFilterIndexes.length > 0 || this.location != null || this.columnWithPopupVisible >= 0) {
            TableColumnModel columnModel = this.getColumnModel();
            int height = this.getHeight();
            int offset = 0;
            int columnCount = columnModel.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                int width = columnModel.getColumn(i).getWidth();
                int modelColumn = this.table.convertColumnIndexToModel(i);
                if (modelColumn < this.headerFilters.length && this.headerFilters[modelColumn] != null) {
                    if (this.columnWithPopupVisible == i) {
                        g.drawImage(FILTER_ICON.getImage(), offset + width - 4 - 16, height - 4 - 12, null);
                        if (this.activeFilterIndexes.length == 0) {
                            break;
                        }
                    } else if (this.hoveredColumn == i) {
                        ImageIcon icon;
                        if (!this.isOnHitZone) {
                            if (this.headerFilters[modelColumn].isFilterActive(modelColumn)) {
                                icon = FILTER_ACTIVE_ICON;
                            } else {
                                ((Graphics2D)g).setComposite(AlphaComposite.getInstance(10, 0.5f));
                                icon = FILTER_ICON;
                            }
                        } else {
                            icon = FILTER_ICON;
                        }
                        g.drawImage(icon.getImage(), offset + width - 4 - 16, height - 4 - 12, null);
                        ((Graphics2D)g).setPaintMode();
                        if (this.activeFilterIndexes.length == 0) {
                            break;
                        }
                    } else if (this.headerFilters[modelColumn].isFilterActive(modelColumn)) {
                        ((Graphics2D)g).setComposite(AlphaComposite.getInstance(10, 0.5f));
                        g.drawImage(FILTER_ACTIVE_ICON.getImage(), offset + width - 4 - 16, height - 4 - 12, null);
                        ((Graphics2D)g).setPaintMode();
                    }
                }
                offset += width;
            }
        }
    }

    private void adjustZones() {
        TableColumnModel columnModel = this.getColumnModel();
        int height = this.getHeight();
        int offset = 0;
        int columnCount = columnModel.getColumnCount();
        int hoveredColumn = -1;
        boolean isOnHitZone = false;
        if (this.location != null) {
            for (int i = 0; i < columnCount; ++i) {
                int width = columnModel.getColumn(i).getWidth();
                int modelIndex = this.table.convertColumnIndexToModel(i);
                if (modelIndex < this.headerFilters.length && this.headerFilters[modelIndex] != null && this.location.x > offset && this.location.x <= offset + width) {
                    hoveredColumn = i;
                    isOnHitZone = this.location.x >= offset + width - 4 - 16 && this.location.x < offset + width - 4 && this.location.y >= height - 4 - 12 && this.location.y < height - 4;
                    break;
                }
                offset += width;
            }
        }
        if (this.hoveredColumn != hoveredColumn || this.isOnHitZone != isOnHitZone) {
            this.hoveredColumn = hoveredColumn;
            this.isOnHitZone = isOnHitZone;
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 501: {
                if (!this.isOnHitZone) break;
                if (e.getButton() == 1) {
                    this.showFilterPopup(e);
                } else if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
                return;
            }
            case 502: {
                if (!this.isOnHitZone || !e.isPopupTrigger()) break;
                this.showPopup(e);
                return;
            }
            case 500: {
                if (!this.isOnHitZone) break;
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
                return;
            }
        }
        super.processMouseEvent(e);
        this.processMouseEvent_(e);
    }

    private void showPopup(MouseEvent e) {
        this.columnWithPopupVisible = this.hoveredColumn;
        this.repaint();
        final int modelColumn = this.table.convertColumnIndexToModel(this.hoveredColumn);
        final TableHeaderFilter headerFilter = this.headerFilters[modelColumn];
        boolean hasOtherFilters = false;
        for (int i = 0; i < this.activeFilterIndexes.length; ++i) {
            if (this.activeFilterIndexes[i] == modelColumn) continue;
            hasOtherFilters = true;
            break;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem clearFilterMenuItem = new JMenuItem(this.getClearFilterLabelText());
        clearFilterMenuItem.setEnabled(headerFilter.isFilterActive(modelColumn));
        clearFilterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                headerFilter.clearFilter(modelColumn);
                FilterableTableHeader.this.notifyFilterChanged(new int[]{modelColumn}, new TableHeaderFilter[]{headerFilter});
            }
        });
        popupMenu.add(clearFilterMenuItem);
        JMenuItem clearAllFiltersMenuItem = new JMenuItem(this.getClearAllFiltersLabelText());
        clearAllFiltersMenuItem.setEnabled(hasOtherFilters);
        clearAllFiltersMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] columns = FilterableTableHeader.this.activeFilterIndexes;
                TableHeaderFilter[] clearedHeaderFilters = new TableHeaderFilter[FilterableTableHeader.this.activeFilterIndexes.length];
                for (int i = FilterableTableHeader.this.activeFilterIndexes.length - 1; i >= 0; --i) {
                    int column = FilterableTableHeader.this.activeFilterIndexes[i];
                    TableHeaderFilter headerFilter = FilterableTableHeader.this.headerFilters[column];
                    headerFilter.clearFilter(column);
                    clearedHeaderFilters[i] = headerFilter;
                }
                FilterableTableHeader.access$002(FilterableTableHeader.this, new int[0]);
                FilterableTableHeader.this.notifyFilterChanged(columns, clearedHeaderFilters);
            }
        });
        popupMenu.add(clearAllFiltersMenuItem);
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                FilterableTableHeader.this.columnWithPopupVisible = -1;
                FilterableTableHeader.this.location = null;
                FilterableTableHeader.this.adjustZones();
                FilterableTableHeader.this.repaint();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    protected String getClearFilterLabelText() {
        return "Clear filter";
    }

    protected String getClearAllFiltersLabelText() {
        return "Clear all filters";
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        this.processMouseEvent_(e);
    }

    private void processMouseEvent_(MouseEvent e) {
        Point newLocation = null;
        switch (e.getID()) {
            case 500: 
            case 502: 
            case 503: 
            case 504: {
                newLocation = e.getPoint();
            }
        }
        if (newLocation != null && !newLocation.equals(this.location) || newLocation == null && this.location != null) {
            this.location = newLocation;
            this.adjustZones();
            this.repaint();
        }
    }

    private void showFilterPopup(MouseEvent e) {
        int[] rows;
        int modelColumn = this.table.convertColumnIndexToModel(this.hoveredColumn);
        TableHeaderFilter headerFilter = this.headerFilters[modelColumn];
        TableRowSorter rowSorter = (TableRowSorter)this.table.getRowSorter();
        TableModel model = (TableModel)rowSorter.getModel();
        int otherFilterCount = 0;
        for (int i = 0; i < this.activeFilterIndexes.length; ++i) {
            if (this.activeFilterIndexes[i] == modelColumn) continue;
            ++otherFilterCount;
        }
        if (otherFilterCount == 0) {
            rows = new int[model.getRowCount()];
            for (int i = 0; i < rows.length; ++i) {
                rows[i] = i;
            }
        } else {
            int i;
            ArrayList<Integer> rowList = new ArrayList<Integer>();
            FilterEntry filterEntry = new FilterEntry();
            for (i = model.getRowCount() - 1; i >= 0; --i) {
                filterEntry.setModelIndex(i);
                boolean isIncluded = true;
                for (int j = 0; j < this.activeFilterIndexes.length; ++j) {
                    int filterColumn = this.activeFilterIndexes[j];
                    if (this.activeFilterIndexes[j] == modelColumn || this.headerFilters[filterColumn].include(filterEntry, filterColumn)) continue;
                    isIncluded = false;
                    break;
                }
                if (!isIncluded) continue;
                rowList.add(i);
            }
            rows = new int[rowList.size()];
            for (i = 0; i < rows.length; ++i) {
                rows[i] = (Integer)rowList.get(i);
            }
        }
        JPopupMenu popupMenu = headerFilter.getFilterEditor(this, model, modelColumn, rows, rowSorter.getComparator(modelColumn));
        int offset = 0;
        int columnCount = this.columnModel.getColumnCount();
        int x = 0;
        for (int i = 0; i < columnCount; ++i) {
            int width = this.columnModel.getColumn(i).getWidth();
            if (this.hoveredColumn == i) {
                x = offset + width;
                break;
            }
            offset += width;
        }
        Dimension preferredSize = popupMenu.getPreferredSize();
        popupMenu.addNotify();
        popupMenu.show(e.getComponent(), x - preferredSize.width - 4, this.getHeight() - 4);
        this.columnWithPopupVisible = this.hoveredColumn;
        this.repaint();
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                FilterableTableHeader.this.columnWithPopupVisible = -1;
                FilterableTableHeader.this.location = null;
                FilterableTableHeader.this.adjustZones();
                FilterableTableHeader.this.repaint();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    public void notifyFilterChanged(int[] columns, TableHeaderFilter[] headerFilters) {
        for (int i = 0; i < columns.length; ++i) {
            this.adjustFilterActiveIndexes(columns[i], headerFilters[i]);
        }
        this.repaint();
        for (TableHeaderFilterChangeListener listener : this.getFilterChangeListeners()) {
            listener.processFilterModification(columns);
        }
    }

    public void setHeaderFilter(int column, TableHeaderFilter headerFilter) {
        if (this.headerFilters.length <= column) {
            TableHeaderFilter[] newHeaderFilters = new TableHeaderFilter[column + 1];
            System.arraycopy(this.headerFilters, 0, newHeaderFilters, 0, this.headerFilters.length);
            this.headerFilters = newHeaderFilters;
        }
        this.headerFilters[column] = headerFilter;
        if (headerFilter == null) {
            int newLength;
            for (newLength = this.headerFilters.length; newLength > 0 && this.headerFilters[newLength - 1] == null; --newLength) {
            }
            if (newLength != this.headerFilters.length) {
                TableHeaderFilter[] newHeaderFilters = new TableHeaderFilter[newLength];
                System.arraycopy(this.headerFilters, 0, newHeaderFilters, 0, newLength);
                this.headerFilters = newHeaderFilters;
            }
        }
        this.adjustFilterActiveIndexes(column, headerFilter);
    }

    private void adjustFilterActiveIndexes(int column, TableHeaderFilter headerFilter) {
        for (int i = 0; i < this.activeFilterIndexes.length; ++i) {
            if (this.activeFilterIndexes[i] != column) continue;
            if (headerFilter != null && headerFilter.isFilterActive(column)) {
                return;
            }
            int[] newActiveFilterIndexes = new int[this.activeFilterIndexes.length - 1];
            System.arraycopy(this.activeFilterIndexes, 0, newActiveFilterIndexes, 0, i);
            System.arraycopy(this.activeFilterIndexes, i + 1, newActiveFilterIndexes, i, newActiveFilterIndexes.length - i);
            this.activeFilterIndexes = newActiveFilterIndexes;
            break;
        }
        if (headerFilter != null && headerFilter.isFilterActive(column)) {
            int[] newActiveFilterIndexes = new int[this.activeFilterIndexes.length + 1];
            System.arraycopy(this.activeFilterIndexes, 0, newActiveFilterIndexes, 0, this.activeFilterIndexes.length);
            newActiveFilterIndexes[this.activeFilterIndexes.length] = column;
            this.activeFilterIndexes = newActiveFilterIndexes;
        }
    }

    public RowFilter<TableModel, Integer> getRowFilter() {
        return this.rowFilter;
    }

    public void addFilterChangeListener(TableHeaderFilterChangeListener listener) {
        this.listenerList.add(TableHeaderFilterChangeListener.class, listener);
    }

    public void removeFilterChangeListener(TableHeaderFilterChangeListener listener) {
        this.listenerList.remove(TableHeaderFilterChangeListener.class, listener);
    }

    public TableHeaderFilterChangeListener[] getFilterChangeListeners() {
        return (TableHeaderFilterChangeListener[])this.listenerList.getListeners(TableHeaderFilterChangeListener.class);
    }

    static /* synthetic */ int[] access$002(FilterableTableHeader x0, int[] x1) {
        x0.activeFilterIndexes = x1;
        return x1;
    }

    public static interface TableHeaderFilterChangeListener
    extends EventListener {
        public void processFilterModification(int[] var1);
    }

    private class FilterEntry
    extends RowFilter.Entry<TableModel, Integer> {
        private int modelIndex;

        private FilterEntry() {
        }

        public void setModelIndex(int modelIndex) {
            this.modelIndex = modelIndex;
        }

        @Override
        public TableModel getModel() {
            return (TableModel)((TableRowSorter)FilterableTableHeader.this.table.getRowSorter()).getModel();
        }

        @Override
        public int getValueCount() {
            return this.getModel().getColumnCount();
        }

        @Override
        public Object getValue(int index) {
            return this.getModel().getValueAt(this.modelIndex, index);
        }

        @Override
        public String getStringValue(int index) {
            return ((TableRowSorter)FilterableTableHeader.this.table.getRowSorter()).getStringConverter().toString(this.getModel(), this.modelIndex, index);
        }

        @Override
        public Integer getIdentifier() {
            return this.modelIndex;
        }
    }

    public static interface TableHeaderFilter {
        public JPopupMenu getFilterEditor(FilterableTableHeader var1, TableModel var2, int var3, int[] var4, Comparator<Object> var5);

        public boolean isFilterActive(int var1);

        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> var1, int var2);

        public void clearFilter(int var1);
    }
}

