/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.dj.swingsuite;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class JDragSelectTree
extends JTree {
    private SelectionData selectionData;

    public JDragSelectTree() {
        this.init();
    }

    public JDragSelectTree(Hashtable<?, ?> value) {
        super(value);
        this.init();
    }

    public JDragSelectTree(Object[] value) {
        super(value);
        this.init();
    }

    public JDragSelectTree(TreeModel newModel) {
        super(newModel);
        this.init();
    }

    public JDragSelectTree(TreeNode root) {
        super(root);
        this.init();
    }

    public JDragSelectTree(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
        this.init();
    }

    public JDragSelectTree(Vector<?> value) {
        super(value);
        this.init();
    }

    private void init() {
        MouseInputAdapter mouseInputListener = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (JDragSelectTree.this.getSelectionModel().getSelectionMode() == 1) {
                    return;
                }
                if (e.getButton() == 1 && JDragSelectTree.this.getRowForLocation(e.getX(), e.getY()) < 0) {
                    int[] selectedRows = JDragSelectTree.this.getSelectionRows();
                    if (selectedRows == null) {
                        selectedRows = new int[]{};
                    }
                    JDragSelectTree.this.selectionData = new SelectionData(e.getPoint(), e.getModifiersEx(), selectedRows);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1) {
                    if (JDragSelectTree.this.selectionData != null && !JDragSelectTree.this.selectionData.isSelectionStarted()) {
                        this.maybeClearSelection(e);
                    }
                    JDragSelectTree.this.selectionData = null;
                    JDragSelectTree.this.repaint();
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.maybeClearSelection(e);
            }

            private void maybeClearSelection(MouseEvent e) {
                if (e.getClickCount() == 1 && !e.isControlDown() && !e.isShiftDown()) {
                    int closestRowForLocation = JDragSelectTree.this.getClosestRowForLocation(e.getX(), e.getY());
                    boolean isClearing = true;
                    if (closestRowForLocation >= 0) {
                        Rectangle rowBounds = JDragSelectTree.this.getRowBounds(closestRowForLocation);
                        if (JDragSelectTree.this.getComponentOrientation().isLeftToRight()) {
                            rowBounds.width += rowBounds.x;
                            rowBounds.x = 0;
                        } else {
                            rowBounds.width += JDragSelectTree.this.getWidth() - rowBounds.x;
                        }
                        if (rowBounds.contains(e.getPoint())) {
                            isClearing = false;
                        }
                    }
                    if (isClearing) {
                        JDragSelectTree.this.clearSelection();
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if ((e.getModifiersEx() & 0x400) != 0 && JDragSelectTree.this.selectionData != null) {
                    int[] rows;
                    boolean isShift;
                    Point currentLocation = e.getPoint();
                    Point pressedLocation = JDragSelectTree.this.selectionData.getPressedLocation();
                    JDragSelectTree.this.selectionData.setCurrentLocation(currentLocation);
                    if (Math.abs(currentLocation.x - pressedLocation.x) < 4 && Math.abs(currentLocation.y - pressedLocation.y) < 4) {
                        JDragSelectTree.this.repaint();
                        return;
                    }
                    JDragSelectTree.this.selectionData.setSelectionStarted();
                    int x1 = Math.max(0, Math.min(pressedLocation.x, currentLocation.x));
                    int x2 = Math.max(pressedLocation.x, currentLocation.x);
                    int y1 = Math.max(0, Math.min(pressedLocation.y, currentLocation.y));
                    int y2 = Math.max(pressedLocation.y, currentLocation.y);
                    int row1 = Math.max(0, JDragSelectTree.this.getClosestRowForLocation(x1, y1));
                    int row2 = Math.min(Math.max(0, JDragSelectTree.this.getClosestRowForLocation(x2, y2)), JDragSelectTree.this.getRowCount() - 1);
                    HashSet<Integer> newRowSet = new HashSet<Integer>();
                    int modifiers = JDragSelectTree.this.selectionData.getModifiers();
                    boolean isControl = (modifiers & 0x80) != 0;
                    boolean bl = isShift = (modifiers & 0x40) != 0;
                    if (JDragSelectTree.this.getSelectionModel().getSelectionMode() == 2) {
                        isControl = false;
                        isShift = false;
                    }
                    int[] originalSelectedRows = JDragSelectTree.this.selectionData.getSelectedRows();
                    if (isControl || isShift) {
                        for (int row : originalSelectedRows) {
                            newRowSet.add(row);
                        }
                    }
                    Rectangle rectangle = new Rectangle(x1, y1, x2 - x1, y2 - y1);
                    int[] newRows = isControl || isShift ? originalSelectedRows : new int[]{};
                    boolean isSelecting = false;
                    for (int i = row1; i <= row2; ++i) {
                        Rectangle rowBounds;
                        if (!isSelecting && (rowBounds = JDragSelectTree.this.getRowBounds(i)) != null && rowBounds.intersects(rectangle)) {
                            isSelecting = true;
                        }
                        if (isControl && newRowSet.contains(i)) {
                            newRowSet.remove(i);
                            continue;
                        }
                        newRowSet.add(i);
                    }
                    if (isSelecting) {
                        Integer[] newRowObjects = newRowSet.toArray(new Integer[0]);
                        newRows = new int[newRowObjects.length];
                        for (int i = 0; i < newRows.length; ++i) {
                            newRows[i] = newRowObjects[i];
                        }
                        Arrays.sort(newRows);
                    }
                    if ((rows = JDragSelectTree.this.getSelectionRows()) != newRows && !Arrays.equals(rows, newRows)) {
                        JDragSelectTree.this.setSelectionRows(newRows);
                    }
                    JDragSelectTree.this.repaint();
                    final int x = e.getX();
                    int y = e.getY();
                    final int closestRowForLocation = JDragSelectTree.this.getClosestRowForLocation(x, y);
                    if (closestRowForLocation >= 0) {
                        new Thread(){

                            @Override
                            public void run() {
                                try {
                                    1.sleep(50L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        Rectangle bounds = JDragSelectTree.this.getRowBounds(closestRowForLocation);
                                        if (bounds != null) {
                                            bounds.x = x;
                                            if (JDragSelectTree.this.getVisibleRect().x + 10 > x) {
                                                bounds.x -= 15;
                                            }
                                            bounds.width = 1;
                                            JDragSelectTree.this.scrollRectToVisible(bounds);
                                        }
                                    }
                                });
                            }
                        }.start();
                    }
                }
            }
        };
        this.addMouseListener(mouseInputListener);
        this.addMouseMotionListener(mouseInputListener);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.selectionData == null) {
            return;
        }
        Point pressedLocation = this.selectionData.getPressedLocation();
        Point currentLocation = this.selectionData.getCurrentLocation();
        if (pressedLocation != null && currentLocation != null && !pressedLocation.equals(currentLocation)) {
            int x1 = Math.min(pressedLocation.x, currentLocation.x);
            int x2 = Math.max(pressedLocation.x, currentLocation.x);
            int y1 = Math.min(pressedLocation.y, currentLocation.y);
            int y2 = Math.max(pressedLocation.y, currentLocation.y);
            Color color = UIManager.getColor("Tree.selectionBackground");
            if (color == null) {
                color = Color.BLUE;
            }
            if (color.getRed() > 128 && color.getGreen() > 128 && color.getBlue() > 128) {
                color = color.darker();
            }
            g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 70));
            g.fillRect(x1, y1, x2 - x1, y2 - y1);
            g.setColor(color);
            g.drawRect(x1, y1, x2 - x1, y2 - y1);
        }
    }

    private static class SelectionData {
        private Point pressedLocation;
        private int modifiers;
        private int[] selectedRows;
        private Point currentLocation;
        private boolean isSelectionStarted;

        public SelectionData(Point pressedLocation, int modifiers, int[] selectedRows) {
            this.pressedLocation = pressedLocation;
            this.modifiers = modifiers;
            this.selectedRows = selectedRows;
        }

        public void setCurrentLocation(Point currentLocation) {
            this.currentLocation = currentLocation;
        }

        public void setSelectionStarted() {
            this.isSelectionStarted = true;
        }

        public boolean isSelectionStarted() {
            return this.isSelectionStarted;
        }

        public Point getCurrentLocation() {
            return this.currentLocation;
        }

        public Point getPressedLocation() {
            return this.pressedLocation;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public int[] getSelectedRows() {
            return this.selectedRows;
        }
    }
}

