/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.dj.swingsuite;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingConstants;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class JExtendedLabel
extends JComponent
implements SwingConstants {
    private JScrollPane scrollPane;
    private TextComponentX textComponent;

    public JExtendedLabel(String text) {
        this(text, 10, true);
    }

    public JExtendedLabel(String text, boolean isSelectable) {
        this(text, 10, isSelectable);
    }

    public JExtendedLabel(String text, int horizontalAlignment) {
        this(text, horizontalAlignment, true);
    }

    public JExtendedLabel(String text, int horizontalAlignment, boolean isSelectable) {
        this.setLayout(new BorderLayout());
        this.textComponent = new TextComponentX(text);
        this.scrollPane = new JScrollPane(this.textComponent){

            @Override
            public void paint(Graphics g) {
                this.paintComponents(g);
            }

            @Override
            public boolean isShowing() {
                return true;
            }
        };
        this.scrollPane.setViewportView(this.textComponent);
        this.add((Component)this.scrollPane, "Center");
        this.setHorizontalAlignment(horizontalAlignment);
        this.adjustLook();
        this.setSelectable(isSelectable);
    }

    private void adjustLook() {
        JLabel label = new JLabel("M");
        this.setOpaque(label.isOpaque());
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        if (this.textComponent == null) {
            return;
        }
        this.textComponent.setOpaque(false);
        this.textComponent.setEditable(false);
        this.textComponent.setAlignmentX(label.getAlignmentX());
        this.textComponent.setAlignmentY(label.getAlignmentY());
        this.textComponent.setOpaque(false);
        this.textComponent.setBorder(label.getBorder());
        this.textComponent.setFont(label.getFont());
        this.textComponent.setForeground(label.getForeground());
        Insets margin = this.textComponent.getMargin();
        margin.left = 0;
        margin.right = 0;
        this.textComponent.setMargin(margin);
        if (label.isOpaque()) {
            this.textComponent.setBackground(label.getBackground());
        } else {
            this.textComponent.setBackground(new Color(0, 0, 0, 0));
        }
        label.setEnabled(false);
        this.textComponent.setDisabledTextColor(label.getForeground());
        this.textComponent.setCursor(Cursor.getPredefinedCursor(2));
    }

    public void setText(String text) {
        this.textComponent.setText(text);
    }

    public String getText() {
        return this.textComponent.getText();
    }

    @Override
    public void setFont(Font font) {
        this.textComponent.setFont(font);
    }

    @Override
    public Font getFont() {
        return this.textComponent.getFont();
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        int alignment = 0;
        switch (horizontalAlignment) {
            case 4: {
                alignment = 2;
                break;
            }
            case 0: {
                alignment = 1;
                break;
            }
            case 11: {
                alignment = this.getComponentOrientation().isLeftToRight() ? 2 : 0;
            }
        }
        AttributeSet paragraphAttributes = this.textComponent.getParagraphAttributes();
        if (StyleConstants.getAlignment(paragraphAttributes) == alignment) {
            return;
        }
        int selectionStart = this.textComponent.getSelectionStart();
        int selectionEnd = this.textComponent.getSelectionEnd();
        this.textComponent.selectAll();
        SimpleAttributeSet attributeSet = new SimpleAttributeSet();
        attributeSet.addAttributes(paragraphAttributes);
        StyleConstants.setAlignment(attributeSet, alignment);
        this.textComponent.setParagraphAttributes(attributeSet, false);
        this.textComponent.select(selectionStart, selectionEnd);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension preferredSize = this.textComponent.getPreferredSize();
        Insets insets = this.getInsets();
        preferredSize.width += insets.left + insets.right;
        preferredSize.height += insets.top + insets.bottom;
        return preferredSize;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.adjustLook();
    }

    public void setSelectable(boolean isSelectable) {
        this.scrollPane.setVisible(isSelectable);
    }

    public boolean isSelectable() {
        return this.scrollPane.isVisible();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.textComponent.setEnabled(isEnabled);
    }

    @Override
    public boolean isEnabled() {
        return this.textComponent.isEnabled();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Insets insets = this.getInsets();
        if (!this.scrollPane.isVisible()) {
            ((Graphics2D)g).translate(insets.left, insets.right);
            this.textComponent.setSize(this.getWidth(), this.getHeight());
            this.textComponent.paint(g);
            ((Graphics2D)g).translate(-insets.left, -insets.right);
        }
    }

    private class TextComponentX
    extends JTextPane {
        public TextComponentX(String text) {
            this.setText(text);
        }

        @Override
        public void setText(String text) {
            super.setText(text);
            this.setCaretPosition(0);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            Dimension size1 = JExtendedLabel.this.textComponent.getSize();
            Dimension size2 = JExtendedLabel.this.getSize();
            return size1.width <= size2.width && size1.height <= size2.height;
        }
    }
}

