/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.dj.swingsuite;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import net.nextencia.dj.swingsuite.PatternTextEntryMask;
import net.nextencia.dj.swingsuite.SwingSuiteUtilities;
import net.nextencia.dj.swingsuite.TextEntryFieldListener;
import net.nextencia.dj.swingsuite.TextEntryFormatter;
import net.nextencia.dj.swingsuite.TextEntryMask;
import net.nextencia.dj.swingsuite.TextEntryValidator;

public class JTextEntryField
extends JTextField {
    private JPopupMenu popup;
    private String lastValidText = "";
    private int maximumLength = -1;
    private boolean isFocused;
    private TextEntryMask textMask;
    private boolean isFocusTrappedOnInvalidText;
    private String lastDisplayedMessage;
    private String lastMessage;
    private boolean preventPopupRespawn;
    private TextEntryValidator validator;
    private TextEntryFormatter formatter;
    private boolean isTipDisplayedOnError = true;
    private boolean isValueForDisplayShown;
    private boolean isSelecting = true;
    private boolean isSelectingAllOnFocus;

    public JTextEntryField(String text) {
        this(text, 0);
    }

    public JTextEntryField(String text, int columns) {
        this(text, columns, -1);
    }

    public JTextEntryField(String text, int columns, int maxLength) {
        this(columns);
        this.setText(text);
        this.setMaximumLength(maxLength);
    }

    public JTextEntryField(String text, String mask) {
        this(text, 0, mask);
    }

    public JTextEntryField(String text, int columns, String pattern) {
        this(columns, new PatternTextEntryMask(pattern));
        this.setText(text);
    }

    public JTextEntryField(String text, int columns, TextEntryMask mask) {
        this(columns, mask);
        this.setText(text);
    }

    protected JTextEntryField(int columns) {
        this.init(columns);
    }

    protected JTextEntryField(int columns, TextEntryMask textMask) {
        if (textMask != null) {
            this.textMask = textMask;
            this.setText_(textMask.getDefaultText());
        }
        this.init(columns);
    }

    private void adjustFont() {
        if (this.textMask != null) {
            Font font = UIManager.getFont("FormattedTextField.font");
            if (font == null) {
                font = new JFormattedTextField().getFont();
            }
            this.setFont(font);
            return;
        }
        Font font = UIManager.getFont("TextField.font");
        if (font == null) {
            font = new JTextField().getFont();
        }
        this.setFont(font);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.adjustFont();
    }

    private void init(int columns) {
        this.adjustFont();
        this.setColumns(columns);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        JTextEntryField.this.exit();
                        break;
                    }
                    case 27: {
                        boolean isPopupVisible = JTextEntryField.this.isPopupVisible();
                        boolean isConsuming = isPopupVisible || !JTextEntryField.this.getText_().equals(JTextEntryField.this.lastValidText);
                        JTextEntryField.this.hidePopup();
                        boolean isTextValid = JTextEntryField.this.isTextValid(JTextEntryField.this.getText_());
                        if (!isPopupVisible || !isTextValid) {
                            JTextEntryField.this.setText(JTextEntryField.this.lastValidText);
                        }
                        if (isConsuming) {
                            e.consume();
                        }
                        JTextEntryField.this.selectAll();
                        if (isPopupVisible || !isTextValid) break;
                        JTextEntryField.this.exit();
                    }
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JTextEntryField.this.isFocused = true;
                JTextEntryField.this.addFocusHandler();
                if (!e.isTemporary()) {
                    if (JTextEntryField.this.isValueForDisplayShown) {
                        JTextEntryField.this.adjustValueForDisplay();
                    }
                    if (!JTextEntryField.this.isTextValid(JTextEntryField.this.getText_())) {
                        JTextEntryField.this.showPopup(false);
                    }
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                JTextEntryField.this.isFocused = false;
                if (!e.isTemporary()) {
                    boolean isTextValid = JTextEntryField.this.isTextValid(JTextEntryField.this.getText_());
                    if (JTextEntryField.this.isFocusTrappedOnInvalidText && !isTextValid) {
                        JTextEntryField.this.requestFocus();
                        return;
                    }
                    if (!isTextValid) {
                        JTextEntryField.this.setText(JTextEntryField.this.lastValidText);
                    }
                    JTextEntryField.this.hidePopup();
                    JTextEntryField.this.validateText();
                    JTextEntryField.this.adjustValueForDisplay();
                } else {
                    JTextEntryField.this.isSelecting = false;
                }
            }
        });
        this.setDocument(new ValidationDocument());
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                JTextEntryField.this.adjustPopupVisibility();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                JTextEntryField.this.adjustPopupVisibility();
            }
        });
        this.setSelectAllOnFocus(true);
    }

    public void setFocusTrappedOnInvalidText(boolean isFocusTrappedOnInvalidText) {
        this.isFocusTrappedOnInvalidText = isFocusTrappedOnInvalidText;
    }

    public boolean isFocusTrappedOnInvalidText() {
        return this.isFocusTrappedOnInvalidText;
    }

    private void addFocusHandler() {
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent e) {
                    MouseEvent me;
                    if (e.getID() == 1005) {
                        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                        return;
                    }
                    if (JTextEntryField.this.isFocusTrappedOnInvalidText) {
                        return;
                    }
                    if (e.getID() == 501 && (me = (MouseEvent)e).getComponent() != JTextEntryField.this && JTextEntryField.this.hasFocus()) {
                        JTextEntryField.this.exit();
                    }
                }
            }, 20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void exit() {
        String textForDisplay = this.getTextForDisplay();
        if (textForDisplay != null && !this.getValidText().equals(textForDisplay)) {
            FocusPanel p = new FocusPanel();
            this.add(p);
            this.revalidate();
            this.repaint();
            p.requestFocus();
        }
        this.validateText();
    }

    @Override
    public void setDocument(Document doc) {
        if (this.getDocument() instanceof ValidationDocument) {
            throw new IllegalStateException("The document cannot be set on a text entry field!");
        }
        super.setDocument(doc);
    }

    private String getText_() {
        return this.getText();
    }

    private void adjustPopupVisibility() {
        String text = this.getText_();
        if (this.isTextValid(text)) {
            this.hidePopup();
        } else {
            this.showPopup(this.maximumLength > 0 && text.length() > this.maximumLength);
        }
    }

    private boolean isPopupVisible() {
        return this.popup != null && this.popup.isVisible();
    }

    private void hidePopup() {
        if (this.lastDisplayedMessage != null && this.isTextValid(this.getText_())) {
            this.lastDisplayedMessage = null;
            this.fireErrorMessageChangedEvent(null);
        }
        this.lastMessage = null;
        if (this.popup != null) {
            if (this.popup.isVisible()) {
                this.popup.setVisible(false);
            }
            this.popup = null;
        }
    }

    private void showPopup(final boolean isMaxLengthPopup) {
        this.preventPopupRespawn = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (JTextEntryField.this.isShowing()) {
                    String[] lines;
                    String message;
                    if (!JTextEntryField.this.hasFocus()) {
                        return;
                    }
                    String text = JTextEntryField.this.getText_();
                    boolean isTextValid = JTextEntryField.this.isTextValid(text);
                    String string = message = !isTextValid ? JTextEntryField.this.getInvalidTextErrorMessage(text) : JTextEntryField.this.getMaximumLengthValidationErrorMessage();
                    if (!(isTextValid && !isMaxLengthPopup || message.equals(JTextEntryField.this.lastDisplayedMessage))) {
                        JTextEntryField.this.lastDisplayedMessage = message;
                        JTextEntryField.this.fireErrorMessageChangedEvent(JTextEntryField.this.lastDisplayedMessage);
                    }
                    if (!JTextEntryField.this.isTipDisplayedOnError() || message.equals(JTextEntryField.this.lastMessage)) {
                        return;
                    }
                    JTextEntryField.this.hidePopup();
                    if (isTextValid && !isMaxLengthPopup) {
                        return;
                    }
                    JTextEntryField.this.lastMessage = message;
                    final AWTEventListener mouseListener = new AWTEventListener(){

                        @Override
                        public void eventDispatched(AWTEvent e) {
                            if (e.getID() == 501 && ((MouseEvent)e).getComponent() == JTextEntryField.this) {
                                JTextEntryField.this.preventPopupRespawn = true;
                                JTextEntryField.this.hidePopup();
                                JTextEntryField.this.requestFocus();
                            }
                        }
                    };
                    JTextEntryField.this.popup = new JPopupMenu(){

                        @Override
                        public void setVisible(boolean isVisible) {
                            super.setVisible(isVisible);
                            if (!isVisible) {
                                try {
                                    Toolkit.getDefaultToolkit().removeAWTEventListener(mouseListener);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (JTextEntryField.this.popup == this) {
                                    JTextEntryField.this.hidePopup();
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (JTextEntryField.this.popup == null && !JTextEntryField.this.isTextValid(JTextEntryField.this.getText_())) {
                                            if (JTextEntryField.this.hasFocus() && JTextEntryField.this.isFocusTrappedOnInvalidText) {
                                                if (!JTextEntryField.this.preventPopupRespawn) {
                                                    JTextEntryField.this.showPopup(false);
                                                }
                                            } else {
                                                JTextEntryField.this.setText(JTextEntryField.this.lastValidText);
                                                JTextEntryField.this.selectAll();
                                            }
                                        }
                                    }
                                });
                            }
                        }
                    };
                    try {
                        Toolkit.getDefaultToolkit().addAWTEventListener(mouseListener, 16L);
                    }
                    catch (Exception e) {
                        JTextEntryField.this.preventPopupRespawn = true;
                    }
                    JTextEntryField.this.popup.setFocusable(false);
                    JTextEntryField.this.popup.setLayout(new BoxLayout(JTextEntryField.this.popup, 1));
                    for (String line : lines = message.split("\n")) {
                        JLabel popupLabel = new JLabel(" " + line + " ");
                        popupLabel.setForeground(Color.RED);
                        JTextEntryField.this.popup.add(popupLabel);
                    }
                    boolean isLeftToRight = JTextEntryField.this.getComponentOrientation().isLeftToRight();
                    boolean isLeft = true;
                    switch (JTextEntryField.this.getHorizontalAlignment()) {
                        case 4: {
                            isLeft = false;
                            break;
                        }
                        case 10: {
                            if (isLeftToRight) break;
                            isLeft = false;
                            break;
                        }
                        case 11: {
                            if (!isLeftToRight) break;
                            isLeft = false;
                        }
                    }
                    int sizeDiff = JTextEntryField.this.getWidth() - ((JTextEntryField)JTextEntryField.this).popup.getPreferredSize().width;
                    if (sizeDiff < 0) {
                        isLeft = !isLeft;
                    }
                    int x = isLeft ? 0 : Math.max(0, sizeDiff);
                    JTextEntryField.this.popup.show(JTextEntryField.this, x, JTextEntryField.this.getHeight());
                }
            }
        });
    }

    public void setMaximumLength(int maximumLength) {
        this.maximumLength = maximumLength;
        this.revalidateText();
    }

    protected void revalidateText() {
        this.setText(this.getValidText());
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    private String getDefaultValidText() {
        String text;
        String string = text = this.validator == null ? "" : this.validator.getDefaultValidText(this);
        if (this.textMask != null && !this.textMask.isTextValid(text)) {
            return this.textMask.getDefaultText();
        }
        return text;
    }

    public TextEntryValidator getValidator() {
        return this.validator;
    }

    public void setValidator(TextEntryValidator validator) {
        this.validator = validator;
        this.revalidateText();
    }

    private String getInvalidTextErrorMessage(String invalidText) {
        String message;
        if (this.validator != null && (message = this.validator.getInvalidTextErrorMessage(this, invalidText)) != null) {
            return message;
        }
        return SwingSuiteUtilities.getUIManagerMessage("TextEntryField.invalidInputMessage", "Invalid input", new Object[0]);
    }

    private String getMaximumLengthValidationErrorMessage() {
        return SwingSuiteUtilities.getUIManagerMessage("TextEntryField.maxTextLengthMessage", "Max length: {0}", this.maximumLength);
    }

    public void setFormatter(TextEntryFormatter formatter) {
        this.formatter = formatter;
        this.revalidateText();
    }

    public TextEntryFormatter getDisplayFormatter() {
        return this.formatter;
    }

    private String getTextForDisplay() {
        return this.formatter == null ? null : this.formatter.getTextForDisplay(this, this.getText_());
    }

    public void setTipDisplayedOnError(boolean isTipDisplayedOnError) {
        this.isTipDisplayedOnError = isTipDisplayedOnError;
        if (!isTipDisplayedOnError) {
            this.hidePopup();
        }
    }

    public boolean isTipDisplayedOnError() {
        return this.isTipDisplayedOnError;
    }

    private void validateText() {
        if (this.isValueForDisplayShown) {
            return;
        }
        String text = this.getText_();
        if (!this.isTextValid(text)) {
            return;
        }
        if (!this.lastValidText.equals(text)) {
            this.lastValidText = text;
            this.fireTextCommittedEvent();
        }
    }

    public String getValidText() {
        if (this.isValueForDisplayShown) {
            return this.lastValidText;
        }
        String text = this.getText_();
        if (this.isTextValid(text)) {
            return text;
        }
        return this.lastValidText;
    }

    private boolean isTextAllowed(String text) {
        if (this.isValueForDisplayShown) {
            return true;
        }
        if (this.validator != null) {
            return this.validator.isTextAllowed(this, text);
        }
        return true;
    }

    private boolean isTextValid(String text) {
        if (this.maximumLength >= 0 && text.length() > this.maximumLength) {
            return false;
        }
        if (this.textMask != null && !this.textMask.isTextValid(text)) {
            return false;
        }
        if (this.validator != null) {
            return this.validator.isTextValid(this, text);
        }
        return true;
    }

    private void adjustValueForDisplay() {
        String textToDisplay;
        boolean isValueForDisplayShown;
        boolean bl = isValueForDisplayShown = !this.isFocused;
        if (this.isValueForDisplayShown == isValueForDisplayShown) {
            return;
        }
        if (isValueForDisplayShown) {
            String valueForDisplay = this.getTextForDisplay();
            if (valueForDisplay == null) {
                return;
            }
            textToDisplay = valueForDisplay;
        } else {
            textToDisplay = this.lastValidText;
        }
        if (isValueForDisplayShown) {
            this.isValueForDisplayShown = isValueForDisplayShown;
        }
        if (this.getText_().equals(textToDisplay)) {
            this.isValueForDisplayShown = isValueForDisplayShown;
            return;
        }
        this.setText_(textToDisplay);
        if (!isValueForDisplayShown) {
            this.isValueForDisplayShown = isValueForDisplayShown;
        }
    }

    private void setText_(String text) {
        super.setText(text);
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        String validText = this.isTextValid(text) ? text : (this.isTextValid(this.lastValidText) ? this.lastValidText : this.getDefaultValidText());
        this.setText_(validText);
        this.isValueForDisplayShown = false;
        this.validateText();
        this.adjustValueForDisplay();
    }

    @Override
    public void selectAll() {
        if (this.isSelecting) {
            super.selectAll();
        }
        this.isSelecting = true;
    }

    public void setSelectAllOnFocus(boolean isSelectingAllOnFocus) {
        this.isSelectingAllOnFocus = isSelectingAllOnFocus;
        SwingSuiteUtilities.setSelectAllOnFocus(this, isSelectingAllOnFocus);
    }

    public boolean isSelectingAllOnFocus() {
        return this.isSelectingAllOnFocus;
    }

    private void fireTextCommittedEvent() {
        for (TextEntryFieldListener listener : this.getTextEntryFieldListeners()) {
            listener.textCommitted(this);
        }
    }

    private void fireErrorMessageChangedEvent(String errorMessage) {
        for (TextEntryFieldListener listener : this.getTextEntryFieldListeners()) {
            listener.errorMessageChanged(this, errorMessage);
        }
    }

    public void addTextEntryFieldListener(TextEntryFieldListener textEntryFieldListener) {
        this.listenerList.add(TextEntryFieldListener.class, textEntryFieldListener);
    }

    public void removeTextEntryFieldListener(TextEntryFieldListener textEntryFieldListener) {
        this.listenerList.remove(TextEntryFieldListener.class, textEntryFieldListener);
    }

    public TextEntryFieldListener[] getTextEntryFieldListeners() {
        return (TextEntryFieldListener[])this.listenerList.getListeners(TextEntryFieldListener.class);
    }

    private class FocusPanel
    extends JPanel {
        public FocusPanel() {
            this.setSize(0, 0);
            this.setFocusable(true);
            this.setOpaque(false);
            this.enableEvents(8L);
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (!e.isTemporary()) {
                        FocusPanel.this.destroy();
                    }
                }
            });
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            if (e.getID() != 401 || e.getKeyCode() == 27) {
                return;
            }
            if (e.getKeyCode() == 113 || e.getKeyChar() != '\uffff') {
                JTextEntryField.this.requestFocus();
            }
        }

        @Override
        public void transferFocus() {
            this.destroy();
            JTextEntryField.this.transferFocus();
        }

        @Override
        public void transferFocusBackward() {
            this.destroy();
            JTextEntryField.this.transferFocusBackward();
        }

        private void destroy() {
            JTextEntryField.this.remove(this);
            JTextEntryField.this.revalidate();
            JTextEntryField.this.repaint();
        }
    }

    private class ValidationDocument
    extends PlainDocument {
        private boolean isInserting;

        private ValidationDocument() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (this.isInserting) {
                super.insertString(offs, str, a);
                return;
            }
            this.isInserting = true;
            try {
                String oldText;
                String result;
                String text;
                boolean isInsertingInMask = false;
                if (JTextEntryField.this.textMask != null && (text = JTextEntryField.this.getText_()).length() > 0) {
                    int caretPosition = JTextEntryField.this.getCaretPosition();
                    if (offs == caretPosition) {
                        offs = JTextEntryField.this.textMask.getNextValidInputPosition(caretPosition);
                    }
                    if (JTextEntryField.this.textMask.insertText(text, str, offs) == null) {
                        JTextEntryField.this.setCaretPosition(JTextEntryField.this.textMask.getNextValidInputPosition(JTextEntryField.this.getCaretPosition()));
                        return;
                    }
                    isInsertingInMask = true;
                }
                if (!JTextEntryField.this.isTextAllowed(result = (oldText = JTextEntryField.this.getText_()).substring(0, offs) + str + oldText.substring(offs))) {
                    return;
                }
                if (JTextEntryField.this.maximumLength < 0 || JTextEntryField.this.isValueForDisplayShown) {
                    super.insertString(offs, str, a);
                    if (isInsertingInMask) {
                        int addedLength = str.length();
                        String text2 = JTextEntryField.this.getText_();
                        text2 = text2.substring(0, offs + addedLength) + text2.substring(offs + addedLength * 2);
                        text2 = JTextEntryField.this.textMask.insertText(text2, text2, 0);
                        JTextEntryField.this.setText_(text2);
                        JTextEntryField.this.setCaretPosition(JTextEntryField.this.textMask.getNextValidInputPosition(offs + addedLength));
                    }
                    return;
                }
                int oldCaretPosition = JTextEntryField.this.getCaretPosition();
                super.insertString(offs, str, a);
                String text3 = JTextEntryField.this.getText_();
                if (text3.length() > JTextEntryField.this.maximumLength) {
                    JTextEntryField.this.setText_(oldText);
                    JTextEntryField.this.setCaretPosition(oldCaretPosition);
                    JTextEntryField.this.showPopup(true);
                    return;
                }
            }
            finally {
                this.isInserting = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(int offs, int len) throws BadLocationException {
            if (this.isInserting) {
                super.remove(offs, len);
                return;
            }
            String text = JTextEntryField.this.getText_();
            boolean isRemovingInMask = false;
            if (JTextEntryField.this.textMask != null) {
                text = JTextEntryField.this.textMask.removeText(text, offs, len);
                if (text == null) {
                    return;
                }
                isRemovingInMask = true;
            }
            if (isRemovingInMask) {
                this.isInserting = true;
                try {
                    JTextEntryField.this.setText_(text);
                }
                finally {
                    this.isInserting = false;
                }
                JTextEntryField.this.setCaretPosition(offs);
            } else {
                super.remove(offs, len);
            }
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (!this.isInserting) {
                String oldText = JTextEntryField.this.getText_();
                if (length > 0) {
                    String newText = oldText.substring(0, offset) + text + oldText.substring(Math.min(oldText.length(), offset + length));
                    if (!JTextEntryField.this.isTextAllowed(newText)) {
                        return;
                    }
                    if (oldText.length() > 0 && JTextEntryField.this.textMask != null && !JTextEntryField.this.textMask.isTextValid(newText)) {
                        return;
                    }
                }
            }
            super.replace(offset, length, text, attrs);
        }
    }
}

