/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.dj.swingsuite;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.nextencia.dj.swingsuite.JTextEntryField;
import net.nextencia.dj.swingsuite.TextEntryValidator;

public class JTimeEditor
extends JPanel {
    public static final int MINUTE_PRECISION = 1;
    public static final int SECOND_PRECISION = 2;
    public static final int MILLISECOND_PRECISION = 3;
    private JPanel editorPane = new JPanel(new GridBagLayout());
    private TimeEntryField hourEntryField;
    private TimeEntryField minuteEntryField;
    private TimeEntryField secondEntryField;
    private TimeEntryField millisecondEntryField;
    private JSpinner spinner;
    private Calendar calendar;
    private TimeEntryField focusedField;

    public JTimeEditor(int precision) {
        this(null, precision);
    }

    public JTimeEditor(Calendar calendar, int precision) {
        super(new BorderLayout());
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTimeEditor.this.fireActionPerformed();
            }
        };
        this.hourEntryField = this.createTimeEntryField(2, "00", 24);
        this.hourEntryField.setBorder(BorderFactory.createEmptyBorder());
        this.hourEntryField.addActionListener(actionListener);
        this.editorPane.setBackground(this.hourEntryField.getBackground());
        int x = 0;
        this.editorPane.add((Component)this.hourEntryField, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 1, 1));
        this.editorPane.add((Component)new JLabel(":"), new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 1, 1));
        this.minuteEntryField = this.createTimeEntryField(2, "00", 60);
        this.minuteEntryField.setBorder(BorderFactory.createEmptyBorder());
        this.minuteEntryField.addActionListener(actionListener);
        this.editorPane.add((Component)this.minuteEntryField, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 1, 1));
        this.addNavigationListener(this.hourEntryField, this.minuteEntryField);
        if (precision > 1) {
            this.editorPane.add((Component)new JLabel(":"), new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 1, 1));
            this.secondEntryField = this.createTimeEntryField(2, "00", 60);
            this.secondEntryField.setBorder(BorderFactory.createEmptyBorder());
            this.secondEntryField.addActionListener(actionListener);
            this.editorPane.add((Component)this.secondEntryField, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 1, 1));
            this.addNavigationListener(this.minuteEntryField, this.secondEntryField);
            if (precision > 2) {
                this.editorPane.add((Component)new JLabel("."), new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 1, 1));
                this.millisecondEntryField = this.createTimeEntryField(3, "000", 1000);
                this.millisecondEntryField.setBorder(BorderFactory.createEmptyBorder());
                this.millisecondEntryField.addActionListener(actionListener);
                this.editorPane.add((Component)this.millisecondEntryField, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 1, 1));
                this.addNavigationListener(this.secondEntryField, this.millisecondEntryField);
            }
        }
        this.editorPane.setMinimumSize(this.editorPane.getPreferredSize());
        this.editorPane.setPreferredSize(this.editorPane.getPreferredSize());
        this.spinner = new JSpinner();
        this.spinner.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TextField.border"), BorderFactory.createEmptyBorder(1, 0, 1, 1)));
        this.spinner.setEditor(this.editorPane);
        this.spinner.getModel().addChangeListener(new ChangeListener(){
            private int startValue;
            {
                this.startValue = (Integer)JTimeEditor.this.spinner.getModel().getValue();
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                int newValue = (Integer)JTimeEditor.this.spinner.getModel().getValue();
                if (JTimeEditor.this.focusedField == null) {
                    JTimeEditor.this.focusedField = JTimeEditor.this.hourEntryField;
                }
                if (newValue > this.startValue) {
                    JTimeEditor.this.focusedField.adjust(1);
                } else if (newValue < this.startValue) {
                    JTimeEditor.this.focusedField.adjust(-1);
                }
                this.startValue = newValue;
            }
        });
        this.add((Component)this.spinner, "Center");
        this.setTime(calendar);
    }

    private void addNavigationListener(final TimeEntryField mainField, final TimeEntryField nextField) {
        FieldListener fieldListener = new FieldListener(mainField, nextField);
        mainField.addFocusListener(fieldListener);
        mainField.addKeyListener(fieldListener);
        nextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 37: 
                    case 226: {
                        if (nextField.getSelectionStart() != 0) break;
                        mainField.requestFocus();
                    }
                }
            }
        });
    }

    public void setTime(Calendar calendar) {
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        this.calendar = (Calendar)calendar.clone();
        this.hourEntryField.setTimeValue(calendar.get(11));
        this.minuteEntryField.setTimeValue(calendar.get(12));
        if (this.secondEntryField != null) {
            this.secondEntryField.setTimeValue(calendar.get(13));
            if (this.millisecondEntryField != null) {
                this.millisecondEntryField.setTimeValue(calendar.get(14));
            }
        }
    }

    public Calendar getTime() {
        this.calendar.set(11, this.hourEntryField.getTimeValue());
        this.calendar.set(12, this.minuteEntryField.getTimeValue());
        if (this.secondEntryField != null) {
            this.calendar.set(13, this.secondEntryField.getTimeValue());
            if (this.millisecondEntryField != null) {
                this.calendar.set(14, this.millisecondEntryField.getTimeValue());
            }
        }
        return (Calendar)this.calendar.clone();
    }

    private TimeEntryField createTimeEntryField(int fieldLength, String defaultString, int maxBound) {
        final TimeEntryField timeEntryField = new TimeEntryField(fieldLength, defaultString, maxBound);
        if (this.focusedField == null) {
            this.focusedField = timeEntryField;
        }
        timeEntryField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JTimeEditor.this.focusedField = timeEntryField;
            }

            @Override
            public void focusLost(FocusEvent e) {
                timeEntryField.setTimeValue(timeEntryField.getTimeValue());
            }
        });
        return timeEntryField;
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public synchronized ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    private void fireActionPerformed() {
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        ActionEvent e = new ActionEvent(this, 1001, "action", EventQueue.getMostRecentEventTime(), modifiers);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.hourEntryField.setEnabled(isEnabled);
        this.minuteEntryField.setEnabled(isEnabled);
        if (this.secondEntryField != null) {
            this.secondEntryField.setEnabled(isEnabled);
        }
        if (this.millisecondEntryField != null) {
            this.millisecondEntryField.setEnabled(isEnabled);
        }
        this.spinner.setEnabled(isEnabled);
        this.editorPane.setBackground(this.hourEntryField.getBackground());
    }

    private static class TimeEntryField
    extends JTextEntryField {
        private int maxBound;

        public TimeEntryField(final int fieldLength, String defaultString, final int maxBound) {
            super(defaultString, fieldLength);
            this.maxBound = maxBound;
            this.setHorizontalAlignment(4);
            this.setValidator(new TextEntryValidator(){

                @Override
                public boolean isTextAllowed(JTextEntryField textEntryField, String text) {
                    int hour;
                    if (text.length() > fieldLength) {
                        return false;
                    }
                    if (text.length() == 0) {
                        return true;
                    }
                    try {
                        hour = Integer.parseInt(text);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                    return hour >= 0 && hour < maxBound;
                }
            });
        }

        public int getMaxBound() {
            return this.maxBound;
        }

        public void adjust(int count) {
            int value;
            try {
                value = Integer.parseInt(this.getText());
            }
            catch (NumberFormatException e) {
                value = 0;
            }
            this.setTimeValue(value += count);
            this.selectAll();
        }

        public int getTimeValue() {
            try {
                return Integer.parseInt(this.getText());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        public void setTimeValue(int value) {
            value = (value % this.maxBound + this.maxBound) % this.maxBound;
            int columns = this.getColumns();
            String sValue = String.valueOf(value);
            char[] chars = new char[columns - sValue.length()];
            Arrays.fill(chars, '0');
            this.setText(new String(chars) + sValue);
        }
    }

    private class FieldListener
    extends KeyAdapter
    implements FocusListener {
        private TimeEntryField mainField;
        private TimeEntryField nextField;
        private int downCount = 0;

        public FieldListener(TimeEntryField mainField, TimeEntryField nextField) {
            this.mainField = mainField;
            this.nextField = nextField;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            ++this.downCount;
            switch (e.getKeyCode()) {
                case 39: 
                case 227: {
                    if (this.mainField.getCaretPosition() != this.mainField.getText().length()) break;
                    this.nextField.requestFocus();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.downCount = Math.max(0, this.downCount - 1);
            if (e.getModifiers() != 0 || this.downCount > 0) {
                return;
            }
            char keyChar = e.getKeyChar();
            if (keyChar >= '0' && keyChar <= '9') {
                int length = this.mainField.getText().length();
                if (this.mainField.getCaretPosition() == length) {
                    if (this.mainField.getColumns() == length) {
                        this.nextField.requestFocus();
                    } else {
                        int timeValue = this.mainField.getTimeValue();
                        if (timeValue * 10 >= this.mainField.getMaxBound()) {
                            this.nextField.requestFocus();
                        }
                    }
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.downCount = 0;
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.downCount = 0;
        }
    }
}

