/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.dj.swingsuite;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import net.nextencia.dj.swingsuite.jna.platform.WindowUtils;

public class RichDnDManager {
    private static final RichDnDImageProvider DEFAULT_IMAGE_PROVIDER = new RichDnDImageProvider(){

        @Override
        public Icon getDnDImage(Component c, int x, int y, int width, int height, Point mouseLocation) {
            BufferedImage img = new BufferedImage(width, height, 2);
            Graphics g = img.getGraphics();
            g.translate(-x, -y);
            c.paint(g);
            g.dispose();
            return new ImageIcon(img);
        }
    };
    private static final RichDnDImageProvider TREE_IMAGE_PROVIDER = new RichDnDImageProvider(){

        @Override
        public Icon getDnDImage(Component c, int x, int y, int width, int height, Point mouseLocation) {
            BufferedImage img = new BufferedImage(width, height, 2);
            Graphics g = img.getGraphics();
            g.translate(-x, -y);
            JTree tree = (JTree)c;
            int leadIndex = tree.hasFocus() ? tree.getLeadSelectionRow() : -1;
            TreeCellRenderer cellRenderer = tree.getCellRenderer();
            TreeModel treeModel = tree.getModel();
            int[] selectionRows = tree.getSelectionRows();
            for (int row : selectionRows == null ? new int[]{} : selectionRows) {
                Rectangle rowBounds = tree.getRowBounds(row);
                g.translate(rowBounds.x, rowBounds.y);
                Object lastPathComponent = tree.getPathForRow(row).getLastPathComponent();
                Component rendererComponent = cellRenderer.getTreeCellRendererComponent(tree, lastPathComponent, true, tree.isExpanded(row), treeModel.isLeaf(lastPathComponent), row, leadIndex == row);
                rendererComponent.setSize(rowBounds.width, rowBounds.height);
                rendererComponent.invalidate();
                rendererComponent.validate();
                rendererComponent.paint(g);
                g.translate(-rowBounds.x, -rowBounds.y);
            }
            g.dispose();
            return new ImageIcon(img);
        }
    };
    private static final RichDnDImageProvider LIST_IMAGE_PROVIDER = new RichDnDImageProvider(){

        @Override
        public Icon getDnDImage(Component c, int x, int y, int width, int height, Point mouseLocation) {
            BufferedImage img = new BufferedImage(width, height, 2);
            Graphics g = img.getGraphics();
            g.translate(-x, -y);
            JList list = (JList)c;
            int leadIndex = list.hasFocus() ? list.getLeadSelectionIndex() : -1;
            ListCellRenderer cellRenderer = list.getCellRenderer();
            int[] selectedIndices = list.getSelectedIndices();
            for (int index : selectedIndices == null ? new int[]{} : selectedIndices) {
                Rectangle rowBounds = list.getCellBounds(index, index);
                g.translate(rowBounds.x, rowBounds.y);
                Component rendererComponent = cellRenderer.getListCellRendererComponent(list, list.getModel().getElementAt(index), index, true, leadIndex == index);
                rendererComponent.setSize(rowBounds.width, rowBounds.height);
                rendererComponent.invalidate();
                rendererComponent.validate();
                rendererComponent.paint(g);
                g.translate(-rowBounds.x, -rowBounds.y);
            }
            g.dispose();
            return new ImageIcon(img);
        }
    };
    private static String IMAGE_PROVIDER_PROPERTY = "richDnDImageProvider";
    private static boolean isValid;
    private static boolean isActive;
    private static DragSource dragSource;
    private static RichDragSourceListener richDragSourceListener;
    private static Method setWindowOpaqueMethod;

    public static void unregister(JComponent c) {
        c.putClientProperty(IMAGE_PROVIDER_PROPERTY, null);
    }

    public static void register(JComponent c) {
        RichDnDImageProvider imageProvider = DEFAULT_IMAGE_PROVIDER;
        if (c instanceof RichDnDImageProvider) {
            imageProvider = (RichDnDImageProvider)((Object)c);
        } else if (c instanceof JTree) {
            imageProvider = TREE_IMAGE_PROVIDER;
        } else if (c instanceof JList) {
            imageProvider = LIST_IMAGE_PROVIDER;
        }
        RichDnDManager.register(c, imageProvider);
    }

    public static void register(JComponent c, RichDnDImageProvider imageProvider) {
        if (!isActive) {
            RichDnDManager.setActive(true);
        }
        c.putClientProperty(IMAGE_PROVIDER_PROPERTY, imageProvider);
    }

    private RichDnDManager() {
    }

    private static Rectangle getClip(Component c) {
        Container parent = c.getParent();
        if (parent != null) {
            Rectangle parentClip = RichDnDManager.getClip(parent);
            Point location = c.getLocation();
            parentClip.x -= location.x;
            parentClip.y -= location.y;
            return parentClip.intersection(new Rectangle(c.getWidth(), c.getHeight()));
        }
        return new Rectangle(c.getWidth(), c.getHeight());
    }

    private static void setActive(boolean isActive) {
        if (RichDnDManager.isActive == isActive) {
            return;
        }
        if (isActive) {
            isValid = false;
            try {
                Class<?> awtUtilitiesClass = Class.forName("com.sun.awt.AWTUtilities");
                try {
                    Class<?> awtUtilitiesTranslucencyClass = Class.forName("com.sun.awt.AWTUtilities$Translucency");
                    if (!((Boolean)awtUtilitiesClass.getDeclaredMethod("isTranslucencySupported", awtUtilitiesTranslucencyClass).invoke(null, awtUtilitiesTranslucencyClass.getDeclaredField("PERPIXEL_TRANSLUCENT").get(null))).booleanValue()) {
                        return;
                    }
                    Method isTranslucencyCapableMethod = awtUtilitiesClass.getDeclaredMethod("isTranslucencyCapable", GraphicsConfiguration.class);
                    for (GraphicsDevice device : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                        for (GraphicsConfiguration config : device.getConfigurations()) {
                            boolean isTranslucencyCapable = (Boolean)isTranslucencyCapableMethod.invoke(null, config);
                            if (isTranslucencyCapable) continue;
                            return;
                        }
                    }
                    setWindowOpaqueMethod = awtUtilitiesClass.getDeclaredMethod("setWindowOpaque", Window.class, Boolean.TYPE);
                }
                catch (Throwable t) {
                    return;
                }
            }
            catch (Throwable t) {
                try {
                    Class<?> windowTranslucencyClass = Class.forName("java.awt.GraphicsDevice$WindowTranslucency");
                    Object perPixelTranslucent = windowTranslucencyClass.getDeclaredField("PERPIXEL_TRANSLUCENT").get(null);
                    Method isTranslucencyCapableMethod = GraphicsConfiguration.class.getDeclaredMethod("isTranslucencyCapable", new Class[0]);
                    for (GraphicsDevice device : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                        if (!((Boolean)GraphicsDevice.class.getDeclaredMethod("isWindowTranslucencySupported", windowTranslucencyClass).invoke((Object)device, perPixelTranslucent)).booleanValue()) {
                            return;
                        }
                        for (GraphicsConfiguration config : device.getConfigurations()) {
                            if (((Boolean)isTranslucencyCapableMethod.invoke((Object)config, new Object[0])).booleanValue()) continue;
                            return;
                        }
                    }
                }
                catch (Throwable th) {
                    return;
                }
            }
            isValid = true;
            dragSource = DragSource.getDefaultDragSource();
            richDragSourceListener = new RichDragSourceListener();
            dragSource.addDragSourceListener(richDragSourceListener);
            dragSource.addDragSourceMotionListener(richDragSourceListener);
        } else {
            dragSource.removeDragSourceListener(richDragSourceListener);
            dragSource.removeDragSourceMotionListener(richDragSourceListener);
        }
        RichDnDManager.isActive = isActive;
    }

    private static class RichDragSourceListener
    implements DragSourceListener,
    DragSourceMotionListener {
        private boolean isStarted;
        private static JWindow dragWindow;
        private Rectangle clip;
        private Point dragOrigin;

        private RichDragSourceListener() {
        }

        private void startDnD(DragSourceDragEvent dsde) {
            if (!isValid) {
                return;
            }
            if (this.isStarted) {
                this.adjusteWindowLocation(dsde);
            } else {
                this.isStarted = true;
                DragGestureEvent trigger = dsde.getDragSourceContext().getTrigger();
                Component c = trigger.getComponent();
                if (!(c instanceof JComponent)) {
                    return;
                }
                RichDnDImageProvider imageProvider = (RichDnDImageProvider)((JComponent)c).getClientProperty(IMAGE_PROVIDER_PROPERTY);
                if (imageProvider == null) {
                    return;
                }
                this.dragOrigin = trigger.getDragOrigin();
                this.clip = RichDnDManager.getClip(c);
                Icon icon = imageProvider.getDnDImage(c, this.clip.x, this.clip.y, this.clip.width, this.clip.height, this.dragOrigin);
                if (icon != null) {
                    dragWindow = new JWindow(){

                        @Override
                        public boolean contains(int x, int y) {
                            return false;
                        }

                        @Override
                        public void paint(Graphics g) {
                            if (!(g instanceof Graphics2D)) {
                                this.dispose();
                            }
                            Graphics2D g2d = (Graphics2D)g;
                            g2d.setComposite(AlphaComposite.getInstance(2, 0.4f));
                            super.paint(g);
                            g2d.setComposite(AlphaComposite.getInstance(1));
                            int x = ((RichDragSourceListener)this).dragOrigin.x - ((RichDragSourceListener)this).clip.x;
                            int y = ((RichDragSourceListener)this).dragOrigin.y - ((RichDragSourceListener)this).clip.y;
                            g.drawLine(x, y, x, y);
                        }
                    };
                    dragWindow.getContentPane().add(new JLabel(icon));
                    dragWindow.pack();
                    this.adjusteWindowLocation(dsde);
                    try {
                        if (setWindowOpaqueMethod == null) {
                            dragWindow.setBackground(new Color(0, 0, 0, 0));
                        } else {
                            setWindowOpaqueMethod.invoke(null, dragWindow, false);
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        this.dispose();
                        return;
                    }
                    if (System.getProperty("os.name").startsWith("Windows")) {
                        try {
                            Class.forName("com.sun.jna.Native");
                            Class.forName("com.sun.jna.examples.WindowUtils");
                            WindowUtils.setWindowClickThrough(dragWindow, true);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    dragWindow.setVisible(true);
                } else {
                    this.dispose();
                }
            }
        }

        private void stopDnD() {
            if (this.isStarted) {
                this.isStarted = false;
                this.dispose();
            }
        }

        private void dispose() {
            if (dragWindow != null) {
                dragWindow.dispose();
                dragWindow = null;
            }
            this.clip = null;
            this.dragOrigin = null;
        }

        private void adjusteWindowLocation(DragSourceDragEvent dsde) {
            if (dragWindow != null) {
                Point location = dsde.getLocation();
                dragWindow.setLocation(location.x - this.dragOrigin.x + this.clip.x, location.y - this.dragOrigin.y + this.clip.y);
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            this.stopDnD();
        }

        @Override
        public void dragMouseMoved(DragSourceDragEvent dsde) {
            this.startDnD(dsde);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }
    }

    public static interface RichDnDImageProvider {
        public Icon getDnDImage(Component var1, int var2, int var3, int var4, int var5, Point var6);
    }
}

