/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.dj.swingsuite;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SedRegExpPattern {
    private List<SedRegExp> sedRegExpList;

    public SedRegExpPattern(String regExp) {
        String originalRegExp = regExp;
        if (!regExp.startsWith("/")) {
            throw new IllegalArgumentException("Invalid expression format: " + originalRegExp);
        }
        regExp = regExp.substring(1);
        StringBuilder sb = new StringBuilder();
        char[] chars = regExp.toCharArray();
        int index1 = -1;
        int index2 = -1;
        this.sedRegExpList = new ArrayList<SedRegExp>(3);
        block9: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case ';': {
                    this.sedRegExpList.add(new SedRegExp(sb.toString(), index1, index2, originalRegExp));
                    index1 = -1;
                    index2 = -1;
                    sb = new StringBuilder();
                    if (++i < chars.length && chars[i] == '/') continue block9;
                    throw new IllegalArgumentException("Invalid expression format: " + originalRegExp);
                }
                case '\\': {
                    if (++i >= chars.length) {
                        throw new IllegalArgumentException("Invalid expression format: " + originalRegExp);
                    }
                    switch (chars[i]) {
                        case '/': {
                            sb.append('/');
                            continue block9;
                        }
                        case ';': {
                            sb.append(';');
                            continue block9;
                        }
                    }
                    sb.append('\\').append(chars[i]);
                    continue block9;
                }
                case '/': {
                    if (index1 == -1) {
                        index1 = sb.length();
                        continue block9;
                    }
                    if (index2 == -1) {
                        index2 = sb.length();
                        continue block9;
                    }
                    throw new IllegalArgumentException("Invalid expression format: " + originalRegExp);
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (index1 == -1) {
            throw new IllegalArgumentException("Invalid expression format: " + originalRegExp);
        }
        this.sedRegExpList.add(new SedRegExp(sb.toString(), index1, index2, originalRegExp));
    }

    public String apply(String text) {
        for (SedRegExp sedRegExp : this.sedRegExpList) {
            text = SedRegExpPattern.applySedRegularExpression(sedRegExp, text);
        }
        return text;
    }

    private static String applySedRegularExpression(SedRegExp sedRegExp, String text) {
        Pattern pattern = sedRegExp.getPattern();
        String replacement = sedRegExp.getReplacement();
        boolean isGlobal = sedRegExp.isGlobal();
        Matcher matcher = pattern.matcher(text);
        if (replacement == null) {
            int groupCount = matcher.groupCount();
            StringBuilder sb = new StringBuilder();
            while (matcher.find()) {
                if (groupCount > 0) {
                    for (int i = 0; i < groupCount; ++i) {
                        String group = matcher.group(i + 1);
                        if (group == null) continue;
                        sb.append(group);
                    }
                } else {
                    String group = matcher.group();
                    if (group != null) {
                        sb.append(group);
                    }
                }
                if (isGlobal) continue;
            }
            return sb.toString();
        }
        if (isGlobal) {
            return matcher.replaceAll(replacement);
        }
        return matcher.replaceFirst(replacement);
    }

    private static class SedRegExp {
        private Pattern pattern;
        private String replacement;
        private boolean isGlobal;

        public SedRegExp(String regExp, int index1, int index2, String originalRegExp) {
            String toFind = regExp.substring(0, index1);
            this.replacement = index2 == -1 ? null : regExp.substring(index1, index2);
            String modifiers = index2 == -1 ? regExp.substring(index1) : regExp.substring(index2);
            this.isGlobal = false;
            int flags = 0;
            block9: for (int i = 0; i < modifiers.length(); ++i) {
                char c = modifiers.charAt(i);
                switch (c) {
                    case 'g': {
                        this.isGlobal = true;
                        continue block9;
                    }
                    case 'i': {
                        flags |= 2;
                        continue block9;
                    }
                    case 'd': {
                        flags |= 1;
                        continue block9;
                    }
                    case 'm': {
                        flags |= 8;
                        continue block9;
                    }
                    case 's': {
                        flags |= 0x20;
                        continue block9;
                    }
                    case 'u': {
                        flags |= 0x40;
                        continue block9;
                    }
                    case 'x': {
                        flags |= 4;
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid expression format: " + originalRegExp);
                    }
                }
            }
            this.pattern = Pattern.compile(toFind, flags);
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public boolean isGlobal() {
            return this.isGlobal;
        }
    }
}

