/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.dj.swingsuite;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import net.nextencia.dj.swingsuite.AutoScrollActivator;

public class SwingSuiteUtilities {
    public static final boolean IS_JAVA_6_OR_GREATER = System.getProperty("java.version").compareTo("1.6") >= 0;
    private static final SelectAllOnFocusListener SELECT_ALL_ON_FOCUS_LISTENER = new SelectAllOnFocusListener();

    private SwingSuiteUtilities() {
    }

    static void setComponentTreeEnabled(Component component, boolean isEnabled) {
        component.setEnabled(isEnabled);
        if (component instanceof Container) {
            int componentCount = ((Container)component).getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                SwingSuiteUtilities.setComponentTreeEnabled(((Container)component).getComponent(i), isEnabled);
            }
        }
    }

    public static void setSelectAllOnFocus(JTextComponent component, boolean isSelectingAllOnFocus) {
        component.removeFocusListener(SELECT_ALL_ON_FOCUS_LISTENER);
        component.removeMouseListener(SELECT_ALL_ON_FOCUS_LISTENER);
        component.removeMouseMotionListener(SELECT_ALL_ON_FOCUS_LISTENER);
        if (isSelectingAllOnFocus) {
            int i;
            int i2;
            MouseListener[] mouseListeners = component.getMouseListeners();
            for (i2 = 0; i2 < mouseListeners.length; ++i2) {
                component.removeMouseListener(mouseListeners[i2]);
            }
            component.addMouseListener(SELECT_ALL_ON_FOCUS_LISTENER);
            for (i2 = 0; i2 < mouseListeners.length; ++i2) {
                component.addMouseListener(mouseListeners[i2]);
            }
            MouseMotionListener[] mouseMotionListeners = component.getMouseMotionListeners();
            for (i = 0; i < mouseMotionListeners.length; ++i) {
                component.removeMouseMotionListener(mouseMotionListeners[i]);
            }
            component.addMouseMotionListener(SELECT_ALL_ON_FOCUS_LISTENER);
            for (i = 0; i < mouseMotionListeners.length; ++i) {
                component.addMouseMotionListener(mouseMotionListeners[i]);
            }
            component.addFocusListener(SELECT_ALL_ON_FOCUS_LISTENER);
        }
    }

    public static boolean isSelectingAllOnFocus(JTextComponent textComponent) {
        for (FocusListener focusListener : textComponent.getFocusListeners()) {
            if (!SELECT_ALL_ON_FOCUS_LISTENER.equals(focusListener)) continue;
            return true;
        }
        return false;
    }

    static String getUIManagerMessage(String managerKey, String defaultMessage, Object ... params) {
        String message = UIManager.getString(managerKey);
        return MessageFormat.format(message != null ? message : defaultMessage, params);
    }

    public static void adjustToolbarButtonFocus(AbstractButton toolBarButton) {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel.isNativeLookAndFeel() && System.getProperty("os.name").startsWith("Windows") && !Boolean.parseBoolean(System.getProperty("swing.noxp")) && !lookAndFeel.getClass().getName().endsWith("WindowsClassicLookAndFeel")) {
            toolBarButton.setFocusPainted(false);
        }
    }

    public static void setAutoScrollEnabled(JComponent component, boolean isEnabled) {
        AutoScrollActivator.setAutoScrollEnabled(component, isEnabled);
    }

    public static void autoFitTableColumns(JTable table, int maxWidth) {
        SwingSuiteUtilities.autoFitTableColumn(table, -1, maxWidth);
    }

    public static void autoFitTableColumn(JTable table, int columnIndex, int maxWidth) {
        int viewCol;
        TableModel model = table.getModel();
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        int rowCount = table.getRowCount();
        int rowMargin = table.getRowMargin();
        TableColumnModel columnModel = table.getColumnModel();
        int n = viewCol = columnIndex >= 0 ? columnIndex : model.getColumnCount() - 1;
        while (viewCol >= 0) {
            TableColumn tableColumn = columnModel.getColumn(viewCol);
            int headerWidth = headerRenderer.getTableCellRendererComponent((JTable)table, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)viewCol).getPreferredSize().width;
            int cellWidth = 0;
            for (int viewRow = 0; viewRow < rowCount; ++viewRow) {
                Component comp = table.getCellRenderer(viewRow, viewCol).getTableCellRendererComponent(table, table.getValueAt(viewRow, viewCol), false, false, viewRow, viewCol);
                int preferredWidth = comp.getPreferredSize().width;
                if (Math.max(headerWidth, cellWidth = Math.max(cellWidth, preferredWidth += 10)) + rowMargin >= maxWidth) break;
            }
            tableColumn.setPreferredWidth(Math.min(Math.max(headerWidth += 20, cellWidth) + rowMargin, maxWidth));
            if (columnIndex >= 0) break;
            --viewCol;
        }
    }

    public static String decodeURL(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encodeURL(String s) {
        String encodedString;
        try {
            encodedString = URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception e) {
            encodedString = URLEncoder.encode(s);
        }
        return encodedString.replaceAll("\\+", "%20");
    }

    public static String escapeXML(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer((int)((double)s.length() * 1.1));
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String convertWildcardsToRegExp(String wildcardString) {
        return "\\Q" + wildcardString.replace("\\E", "\\\\E").replace("\\Q", "\\\\Q").replace("?", "\\E.\\Q").replace("*", "\\E.*\\Q");
    }

    public static void setPreferredLookAndFeel() {
        try {
            String systemLookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
            if (!"com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(systemLookAndFeelClassName)) {
                UIManager.setLookAndFeel(systemLookAndFeelClassName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class SelectAllOnFocusListener
    extends MouseAdapter
    implements MouseMotionListener,
    FocusListener {
        private boolean isSettingFocus;
        private Point mouseLocation = null;

        private SelectAllOnFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.isSettingFocus = true;
            ((JTextComponent)e.getComponent()).selectAll();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.isSettingFocus = false;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                this.mouseLocation = e.getPoint();
                this.isSettingFocus = false;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                if (this.isSettingFocus) {
                    e.consume();
                }
                this.isSettingFocus = false;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                this.mouseLocation = null;
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if ((e.getModifiersEx() & 0x400) != 0 && this.mouseLocation != null) {
                if (this.isSettingFocus && Math.abs(this.mouseLocation.x - e.getX()) < 5) {
                    e.consume();
                } else {
                    ((JTextComponent)e.getComponent()).setCaretPosition(((JTextComponent)e.getComponent()).viewToModel(this.mouseLocation));
                    this.mouseLocation = null;
                }
            }
        }
    }
}

