/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.rrdiagram.grammar.model;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.nextencia.rrdiagram.grammar.model.Choice;
import net.nextencia.rrdiagram.grammar.model.Expression;
import net.nextencia.rrdiagram.grammar.model.Grammar;
import net.nextencia.rrdiagram.grammar.model.Literal;
import net.nextencia.rrdiagram.grammar.model.Repetition;
import net.nextencia.rrdiagram.grammar.model.Rule;
import net.nextencia.rrdiagram.grammar.model.RuleReference;
import net.nextencia.rrdiagram.grammar.model.Sequence;
import net.nextencia.rrdiagram.grammar.model.SpecialSequence;

public class BNFToGrammar {
    private static boolean isNoop(Expression expression) {
        return expression instanceof Sequence && ((Sequence)expression).getExpressions().length == 0;
    }

    public Grammar convert(String string) {
        try {
            return this.convert(new StringReader(string));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Grammar convert(Reader reader) throws IOException {
        int x;
        StringBuilder sb = new StringBuilder();
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        block4: while ((x = reader.read()) != -1) {
            char c = (char)x;
            block0 : switch (c) {
                case '=': {
                    Chunk chunk = new Chunk(ChunkType.GROUP);
                    String expressionText = BNFToGrammar.loadExpression(chunk, reader, ';');
                    if (expressionText.endsWith(";")) {
                        expressionText = expressionText.substring(0, expressionText.length() - 1);
                    }
                    String ruleName = sb.toString();
                    sb.delete(0, sb.length());
                    if (ruleName.endsWith(":") && (ruleName = ruleName.substring(0, ruleName.length() - 1)).endsWith(":")) {
                        ruleName = ruleName.substring(0, ruleName.length() - 1);
                    }
                    ruleName = ruleName.trim();
                    Rule rule = BNFToGrammar.createRule(ruleName, chunk, expressionText);
                    ruleList.add(rule);
                    break;
                }
                case '(': {
                    int x2;
                    if (reader.read() != 42) {
                        throw new IllegalStateException("Expecting start of a comment after '(' but could not find '*'!");
                    }
                    char lastChar = '\u0000';
                    while ((x2 = reader.read()) != -1) {
                        char c2 = (char)x2;
                        if (c2 == ')' && lastChar == '*') break block0;
                        lastChar = c2;
                    }
                    continue block4;
                }
                default: {
                    if (Character.isWhitespace(c) && sb.length() <= 0) continue block4;
                    sb.append(c);
                }
            }
        }
        return new Grammar(ruleList.toArray(new Rule[0]));
    }

    private static Rule createRule(String name, Chunk chunk, String originalExpressionText) {
        chunk.prune();
        Expression expression = chunk.getExpression();
        return new Rule(name, expression, originalExpressionText);
    }

    private static String loadExpression(Chunk parentChunk, Reader reader, char stopChar) throws IOException {
        int x;
        boolean isLiteral;
        StringBuilder expressionTextSB = new StringBuilder();
        char lastChar = '\u0000';
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        boolean isInSpecialGroup = false;
        char specialGroupChar = '\u0000';
        boolean bl = isLiteral = parentChunk.getType() == ChunkType.LITERAL;
        while ((x = reader.read()) != -1) {
            char c = (char)x;
            expressionTextSB.append(c);
            if (isLiteral) {
                if (c == stopChar) {
                    String s = sb.toString();
                    parentChunk.setText(s);
                    return expressionTextSB.toString();
                }
                sb.append(c);
                continue;
            }
            if (isFirst && parentChunk.getType() == ChunkType.GROUP) {
                switch (c) {
                    case '*': {
                        isInSpecialGroup = true;
                        specialGroupChar = c;
                        break;
                    }
                    case '?': {
                        isInSpecialGroup = true;
                        specialGroupChar = c;
                    }
                }
            }
            isFirst = false;
            if (isInSpecialGroup) {
                if (c == ')' && lastChar == specialGroupChar) {
                    switch (specialGroupChar) {
                        case '*': {
                            parentChunk.setType(ChunkType.COMMENT);
                            break;
                        }
                        case '?': {
                            parentChunk.setType(ChunkType.SPECIAL_SEQUENCE);
                        }
                    }
                    String comment = sb.toString();
                    comment = comment.substring(1, comment.length() - 1).trim();
                    parentChunk.setText(comment);
                    return expressionTextSB.toString();
                }
                if (sb.length() > 0 || !Character.isWhitespace(c)) {
                    sb.append(c);
                }
            } else {
                String content;
                if (c == stopChar) {
                    content = sb.toString().trim();
                    if (content.length() > 0) {
                        parentChunk.addChunk(new Chunk(ChunkType.RULE, content));
                    }
                    return expressionTextSB.toString();
                }
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case ',': {
                        content = sb.toString().trim();
                        if (content.length() > 0) {
                            parentChunk.addChunk(new Chunk(ChunkType.RULE, content));
                        }
                        sb.delete(0, sb.length());
                        break;
                    }
                    case '|': {
                        content = sb.toString().trim();
                        if (content.length() > 0) {
                            parentChunk.addChunk(new Chunk(ChunkType.RULE, content));
                        }
                        sb.delete(0, sb.length());
                        parentChunk.addChunk(new Chunk(ChunkType.ALTERNATION));
                        break;
                    }
                    case '*': 
                    case '+': 
                    case '?': {
                        content = sb.toString().trim();
                        if (content.length() > 0) {
                            parentChunk.addChunk(new Chunk(ChunkType.RULE, content));
                        }
                        sb.delete(0, sb.length());
                        parentChunk.addChunk(new Chunk(ChunkType.REPETITION_TOKEN, String.valueOf(c)));
                        break;
                    }
                    case '\"': {
                        content = sb.toString().trim();
                        if (content.length() > 0) {
                            parentChunk.addChunk(new Chunk(ChunkType.RULE, content));
                        }
                        sb.delete(0, sb.length());
                        Chunk literalChunk = new Chunk(ChunkType.LITERAL);
                        String subExpressionText = BNFToGrammar.loadExpression(literalChunk, reader, '\"');
                        expressionTextSB.append(subExpressionText);
                        parentChunk.addChunk(literalChunk);
                        break;
                    }
                    case '\'': {
                        content = sb.toString().trim();
                        if (content.length() > 0) {
                            parentChunk.addChunk(new Chunk(ChunkType.RULE, content));
                        }
                        sb.delete(0, sb.length());
                        Chunk literalChunk = new Chunk(ChunkType.LITERAL);
                        String subExpressionText = BNFToGrammar.loadExpression(literalChunk, reader, '\'');
                        expressionTextSB.append(subExpressionText);
                        parentChunk.addChunk(literalChunk);
                        break;
                    }
                    case '(': {
                        content = sb.toString().trim();
                        if (content.length() > 0) {
                            parentChunk.addChunk(new Chunk(ChunkType.RULE, content));
                        }
                        sb.delete(0, sb.length());
                        Chunk groupChunk = new Chunk(ChunkType.GROUP);
                        String subExpressionText = BNFToGrammar.loadExpression(groupChunk, reader, ')');
                        expressionTextSB.append(subExpressionText);
                        parentChunk.addChunk(groupChunk);
                        break;
                    }
                    case '[': {
                        content = sb.toString().trim();
                        if (content.length() > 0) {
                            parentChunk.addChunk(new Chunk(ChunkType.RULE, content));
                        }
                        sb.delete(0, sb.length());
                        Chunk optionChunk = new Chunk(ChunkType.OPTION);
                        String subExpressionText = BNFToGrammar.loadExpression(optionChunk, reader, ']');
                        expressionTextSB.append(subExpressionText);
                        parentChunk.addChunk(optionChunk);
                        break;
                    }
                    case '{': {
                        content = sb.toString().trim();
                        if (content.length() > 0) {
                            parentChunk.addChunk(new Chunk(ChunkType.RULE, content));
                        }
                        sb.delete(0, sb.length());
                        Chunk repetitionChunk = new Chunk(ChunkType.REPETITION);
                        repetitionChunk.setMinCount(0);
                        String subExpressionText = BNFToGrammar.loadExpression(repetitionChunk, reader, '}');
                        expressionTextSB.append(subExpressionText);
                        parentChunk.addChunk(repetitionChunk);
                        break;
                    }
                    default: {
                        if (sb.length() <= 0 && Character.isWhitespace(c)) break;
                        sb.append(c);
                    }
                }
            }
            lastChar = c;
        }
        return expressionTextSB.toString();
    }

    private static class Chunk {
        private ChunkType type;
        private String text;
        private int minCount;
        private Integer maxCount;
        private List<Chunk> chunkList;

        public Chunk(ChunkType type) {
            this(type, null);
        }

        public Chunk(ChunkType type, String text) {
            this.type = type;
            this.text = text;
        }

        public ChunkType getType() {
            return this.type;
        }

        public void setType(ChunkType type) {
            this.type = type;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setMinCount(int minCount) {
            this.minCount = minCount;
        }

        public void setMaxCount(Integer maxCount) {
            this.maxCount = maxCount;
        }

        public void addChunk(Chunk chunk) {
            if (this.chunkList == null) {
                this.chunkList = new ArrayList<Chunk>();
            }
            this.chunkList.add(chunk);
        }

        /*
         * WARNING - void declaration
         */
        private void prune() {
            boolean hasAlternation = false;
            block9: for (int i = this.chunkList.size() - 1; i >= 0; --i) {
                Chunk chunk = this.chunkList.get(i);
                switch (chunk.getType()) {
                    case REPETITION_TOKEN: {
                        Chunk newChunk;
                        if ("*".equals(chunk.text)) {
                            void var5_9;
                            this.chunkList.remove(i);
                            Chunk previousChunk2 = this.chunkList.get(i - 1);
                            Object var5_7 = null;
                            if (previousChunk2.getType() == ChunkType.RULE) {
                                try {
                                    Integer n = Integer.parseInt(previousChunk2.text);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (var5_9 != null) {
                                Chunk nextChunk = this.chunkList.get(i);
                                if (nextChunk.getType() == ChunkType.OPTION) {
                                    Chunk newChunk2 = new Chunk(ChunkType.REPETITION);
                                    newChunk2.setMinCount(0);
                                    newChunk2.setMaxCount((Integer)var5_9);
                                    for (Chunk c : nextChunk.chunkList) {
                                        newChunk2.addChunk(c);
                                    }
                                    this.chunkList.remove(i);
                                    this.chunkList.set(i - 1, newChunk2);
                                    continue block9;
                                }
                                Chunk newChunk2 = new Chunk(ChunkType.REPETITION);
                                newChunk2.setMinCount(var5_9.intValue());
                                newChunk2.setMaxCount((Integer)var5_9);
                                newChunk2.addChunk(nextChunk);
                                this.chunkList.remove(i);
                                this.chunkList.set(i - 1, newChunk2);
                                continue block9;
                            }
                            Chunk newChunk3 = new Chunk(ChunkType.REPETITION);
                            newChunk3.setMinCount(0);
                            newChunk3.addChunk(previousChunk2);
                            this.chunkList.set(i - 1, newChunk3);
                            continue block9;
                        }
                        if ("+".equals(chunk.text)) {
                            this.chunkList.remove(i);
                            newChunk = new Chunk(ChunkType.REPETITION);
                            newChunk.setMinCount(1);
                            Chunk chunk2 = this.chunkList.get(i - 1);
                            newChunk.addChunk(chunk2);
                            this.chunkList.set(i - 1, newChunk);
                            continue block9;
                        }
                        if (!"?".equals(chunk.text)) continue block9;
                        this.chunkList.remove(i);
                        newChunk = new Chunk(ChunkType.OPTION);
                        Chunk chunk3 = this.chunkList.get(i - 1);
                        newChunk.addChunk(chunk3);
                        this.chunkList.set(i - 1, newChunk);
                        continue block9;
                    }
                    case COMMENT: {
                        this.chunkList.remove(i);
                    }
                    case ALTERNATION: {
                        hasAlternation = true;
                        continue block9;
                    }
                    case GROUP: {
                        if (chunk.chunkList == null) continue block9;
                        chunk.prune();
                        if (chunk.chunkList.size() != 1) continue block9;
                        this.chunkList.set(i, chunk.chunkList.get(0));
                        continue block9;
                    }
                    case OPTION: 
                    case REPETITION: {
                        chunk.prune();
                    }
                }
            }
            if (hasAlternation) {
                ArrayList alternationSequenceList = new ArrayList();
                alternationSequenceList.add(new ArrayList());
                for (Chunk chunk : this.chunkList) {
                    if (chunk.getType() == ChunkType.ALTERNATION) {
                        alternationSequenceList.add(new ArrayList());
                        continue;
                    }
                    List list = (List)alternationSequenceList.get(alternationSequenceList.size() - 1);
                    list.add(chunk);
                }
                Chunk choiceChunk = new Chunk(ChunkType.CHOICE);
                for (List list : alternationSequenceList) {
                    if (list.size() == 1) {
                        choiceChunk.addChunk((Chunk)list.get(0));
                        continue;
                    }
                    Chunk groupChunk = new Chunk(ChunkType.GROUP);
                    for (Chunk c : list) {
                        groupChunk.addChunk(c);
                    }
                    choiceChunk.addChunk(groupChunk);
                }
                this.chunkList.clear();
                this.chunkList.add(choiceChunk);
            }
        }

        private Expression getExpression() {
            switch (this.type) {
                case GROUP: {
                    if (this.chunkList == null) {
                        return new Sequence(new Expression[0]);
                    }
                    if (this.chunkList.size() == 1) {
                        return this.chunkList.get(0).getExpression();
                    }
                    ArrayList<Expression> expressionList = new ArrayList<Expression>();
                    for (Chunk chunk : this.chunkList) {
                        expressionList.add(chunk.getExpression());
                    }
                    return new Sequence(expressionList.toArray(new Expression[0]));
                }
                case CHOICE: {
                    if (this.chunkList.size() == 1) {
                        return this.chunkList.get(0).getExpression();
                    }
                    ArrayList<Expression> expressionList = new ArrayList<Expression>();
                    boolean hasLine = false;
                    for (Chunk chunk : this.chunkList) {
                        Repetition repetition;
                        Expression expression = chunk.getExpression();
                        if (expression instanceof Repetition && (repetition = (Repetition)expression).getMinRepetitionCount() == 0) {
                            expression = repetition.getMaxRepetitionCount() == null || repetition.getMaxRepetitionCount() != 1 ? new Repetition(repetition.getExpression(), 1, repetition.getMaxRepetitionCount()) : repetition.getExpression();
                            hasLine = true;
                        }
                        if (expression instanceof Choice) {
                            for (Expression exp : ((Choice)expression).getExpressions()) {
                                expressionList.add(exp);
                            }
                            continue;
                        }
                        expressionList.add(expression);
                    }
                    if (hasLine && (expressionList.isEmpty() || !BNFToGrammar.isNoop((Expression)expressionList.get(expressionList.size() - 1)))) {
                        expressionList.add(new Sequence(new Expression[0]));
                    }
                    return new Choice(expressionList.toArray(new Expression[0]));
                }
                case RULE: {
                    return new RuleReference(this.text);
                }
                case LITERAL: {
                    return new Literal(this.text);
                }
                case SPECIAL_SEQUENCE: {
                    return new SpecialSequence(this.text);
                }
                case OPTION: {
                    if (this.chunkList.size() == 1) {
                        Chunk subChunk = this.chunkList.get(0);
                        if (subChunk.getType() == ChunkType.CHOICE) {
                            Chunk newChunk = new Chunk(ChunkType.CHOICE);
                            for (Chunk cChunk : subChunk.chunkList) {
                                newChunk.addChunk(cChunk);
                            }
                            newChunk.addChunk(new Chunk(ChunkType.GROUP));
                            return newChunk.getExpression();
                        }
                        return new Repetition(subChunk.getExpression(), 0, 1);
                    }
                    ArrayList<Expression> expressionList = new ArrayList<Expression>();
                    for (Chunk chunk : this.chunkList) {
                        expressionList.add(chunk.getExpression());
                    }
                    return new Repetition(new Sequence(expressionList.toArray(new Expression[0])), 0, 1);
                }
                case REPETITION: {
                    if (this.chunkList.size() == 1) {
                        return new Repetition(this.chunkList.get(0).getExpression(), this.minCount, this.maxCount);
                    }
                    ArrayList<Expression> expressionList = new ArrayList<Expression>();
                    for (Chunk chunk : this.chunkList) {
                        expressionList.add(chunk.getExpression());
                    }
                    return new Repetition(new Sequence(expressionList.toArray(new Expression[0])), this.minCount, this.maxCount);
                }
            }
            throw new IllegalStateException("Type should not be reachable: " + (Object)((Object)this.type));
        }

        public String toString() {
            String s = String.valueOf((Object)this.type);
            if (this.text != null) {
                s = s + " (" + this.text + ")";
            }
            return s;
        }
    }

    private static enum ChunkType {
        RULE,
        REPETITION_TOKEN,
        ALTERNATION,
        GROUP,
        COMMENT,
        SPECIAL_SEQUENCE,
        LITERAL,
        OPTION,
        REPETITION,
        CHOICE;

    }
}

