/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.rrdiagram.grammar.model;

import java.util.ArrayList;
import java.util.Arrays;
import net.nextencia.rrdiagram.grammar.model.Expression;
import net.nextencia.rrdiagram.grammar.model.GrammarToBNF;
import net.nextencia.rrdiagram.grammar.model.GrammarToRRDiagram;
import net.nextencia.rrdiagram.grammar.model.Sequence;
import net.nextencia.rrdiagram.grammar.rrdiagram.RRChoice;
import net.nextencia.rrdiagram.grammar.rrdiagram.RRElement;

public class Choice
extends Expression {
    private Expression[] expressions;

    public Choice(Expression ... expressions) {
        this.expressions = expressions;
    }

    public Expression[] getExpressions() {
        return this.expressions;
    }

    @Override
    protected RRElement toRRElement(GrammarToRRDiagram grammarToRRDiagram) {
        RRElement[] rrElements = new RRElement[this.expressions.length];
        for (int i = 0; i < rrElements.length; ++i) {
            rrElements[i] = this.expressions[i].toRRElement(grammarToRRDiagram);
        }
        return new RRChoice(rrElements);
    }

    @Override
    protected void toBNF(GrammarToBNF grammarToBNF, StringBuilder sb, boolean isNested) {
        ArrayList<Expression> expressionList = new ArrayList<Expression>();
        boolean hasNoop = false;
        for (Expression expression : this.expressions) {
            if (expression instanceof Sequence && ((Sequence)expression).getExpressions().length == 0) {
                hasNoop = true;
                continue;
            }
            expressionList.add(expression);
        }
        if (expressionList.isEmpty()) {
            sb.append("( )");
        } else if (hasNoop && expressionList.size() == 1) {
            boolean isUsingMultiplicationTokens = grammarToBNF.isUsingMultiplicationTokens();
            if (!isUsingMultiplicationTokens) {
                sb.append("[ ");
            }
            ((Expression)expressionList.get(0)).toBNF(grammarToBNF, sb, isUsingMultiplicationTokens);
            if (!isUsingMultiplicationTokens) {
                sb.append(" ]");
            }
        } else {
            boolean isUsingMultiplicationTokens = grammarToBNF.isUsingMultiplicationTokens();
            if (hasNoop && !isUsingMultiplicationTokens) {
                sb.append("[ ");
            } else if (hasNoop || isNested && expressionList.size() > 1) {
                sb.append("( ");
            }
            int count = expressionList.size();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    sb.append(" | ");
                }
                ((Expression)expressionList.get(i)).toBNF(grammarToBNF, sb, false);
            }
            if (hasNoop && !isUsingMultiplicationTokens) {
                sb.append(" ]");
            } else if (hasNoop || isNested && expressionList.size() > 1) {
                sb.append(" )");
                if (hasNoop) {
                    sb.append("?");
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Choice)) {
            return false;
        }
        return Arrays.equals(this.expressions, ((Choice)o).expressions);
    }
}

