/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.rrdiagram.grammar.model;

import net.nextencia.rrdiagram.grammar.model.Expression;
import net.nextencia.rrdiagram.grammar.model.GrammarToBNF;
import net.nextencia.rrdiagram.grammar.model.GrammarToRRDiagram;
import net.nextencia.rrdiagram.grammar.rrdiagram.RRChoice;
import net.nextencia.rrdiagram.grammar.rrdiagram.RRElement;
import net.nextencia.rrdiagram.grammar.rrdiagram.RRLine;
import net.nextencia.rrdiagram.grammar.rrdiagram.RRLoop;

public class Repetition
extends Expression {
    private Expression expression;
    private int minRepetitionCount;
    private Integer maxRepetitionCount;

    public Repetition(Expression expression, int minRepetitionCount, Integer maxRepetitionCount) {
        this.expression = expression;
        this.minRepetitionCount = minRepetitionCount;
        this.maxRepetitionCount = maxRepetitionCount;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public int getMinRepetitionCount() {
        return this.minRepetitionCount;
    }

    public Integer getMaxRepetitionCount() {
        return this.maxRepetitionCount;
    }

    @Override
    protected RRElement toRRElement(GrammarToRRDiagram grammarToRRDiagram) {
        RRElement rrElement = this.expression.toRRElement(grammarToRRDiagram);
        if (this.minRepetitionCount == 0) {
            if (this.maxRepetitionCount == null || this.maxRepetitionCount > 1) {
                return new RRChoice(new RRLoop(rrElement, null, 0, this.maxRepetitionCount == null ? null : Integer.valueOf(this.maxRepetitionCount - 1)), new RRLine());
            }
            return new RRChoice(rrElement, new RRLine());
        }
        return new RRLoop(rrElement, null, this.minRepetitionCount - 1, this.maxRepetitionCount == null ? null : Integer.valueOf(this.maxRepetitionCount - 1));
    }

    @Override
    protected void toBNF(GrammarToBNF grammarToBNF, StringBuilder sb, boolean isNested) {
        boolean isUsingMultiplicationTokens = grammarToBNF.isUsingMultiplicationTokens();
        if (this.maxRepetitionCount == null) {
            if (this.minRepetitionCount > 0) {
                if (this.minRepetitionCount == 1 && isUsingMultiplicationTokens) {
                    this.expression.toBNF(grammarToBNF, sb, true);
                    sb.append("+");
                } else {
                    if (isNested) {
                        sb.append("( ");
                    }
                    if (this.minRepetitionCount > 1) {
                        sb.append(this.minRepetitionCount);
                        sb.append(" * ");
                    }
                    this.expression.toBNF(grammarToBNF, sb, false);
                    if (grammarToBNF.isCommaSeparator()) {
                        sb.append(" ,");
                    }
                    sb.append(" ");
                    sb.append("{ ");
                    this.expression.toBNF(grammarToBNF, sb, false);
                    sb.append(" }");
                    if (isNested) {
                        sb.append(" )");
                    }
                }
            } else if (isUsingMultiplicationTokens) {
                this.expression.toBNF(grammarToBNF, sb, true);
                sb.append("*");
            } else {
                sb.append("{ ");
                this.expression.toBNF(grammarToBNF, sb, false);
                sb.append(" }");
            }
        } else if (this.minRepetitionCount == 0) {
            if (this.maxRepetitionCount == 1 && isUsingMultiplicationTokens) {
                this.expression.toBNF(grammarToBNF, sb, true);
                sb.append("?");
            } else {
                if (this.maxRepetitionCount > 1) {
                    sb.append(this.maxRepetitionCount);
                    sb.append(" * ");
                }
                sb.append("[ ");
                this.expression.toBNF(grammarToBNF, sb, false);
                sb.append(" ]");
            }
        } else if (this.minRepetitionCount == this.maxRepetitionCount) {
            sb.append(this.minRepetitionCount);
            sb.append(" * ");
            this.expression.toBNF(grammarToBNF, sb, isNested);
        } else {
            if (isNested) {
                sb.append("( ");
            }
            sb.append(this.minRepetitionCount);
            sb.append(" * ");
            this.expression.toBNF(grammarToBNF, sb, false);
            if (grammarToBNF.isCommaSeparator()) {
                sb.append(" ,");
            }
            sb.append(" ");
            sb.append(this.maxRepetitionCount - this.minRepetitionCount);
            sb.append(" * ");
            sb.append("[ ");
            this.expression.toBNF(grammarToBNF, sb, false);
            sb.append(" ]");
            if (isNested) {
                sb.append(" )");
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Repetition)) {
            return false;
        }
        Repetition exp2 = (Repetition)o;
        return this.expression.equals(exp2.expression) && this.minRepetitionCount == exp2.minRepetitionCount && this.maxRepetitionCount == null ? exp2.maxRepetitionCount == null : this.maxRepetitionCount.equals(exp2.maxRepetitionCount);
    }
}

