/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.rrdiagram.grammar.model;

import net.nextencia.rrdiagram.grammar.model.Expression;
import net.nextencia.rrdiagram.grammar.model.GrammarToBNF;
import net.nextencia.rrdiagram.grammar.model.GrammarToRRDiagram;
import net.nextencia.rrdiagram.grammar.rrdiagram.RRDiagram;

public class Rule {
    private String name;
    private Expression expression;
    private String originalExpressionText;

    public Rule(String name, Expression expression) {
        this(name, expression, null);
    }

    public Rule(String name, Expression expression, String originalExpressionText) {
        this.name = name;
        this.expression = expression;
        this.originalExpressionText = originalExpressionText;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalExpressionText() {
        return this.originalExpressionText;
    }

    RRDiagram toRRDiagram(GrammarToRRDiagram grammarToRRDiagram) {
        return new RRDiagram(this.expression.toRRElement(grammarToRRDiagram));
    }

    String toBNF(GrammarToBNF grammarToBNF) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append(" ");
        switch (grammarToBNF.getRuleDefinitionSign()) {
            case EQUAL: {
                sb.append("=");
                break;
            }
            case COLON_EQUAL: {
                sb.append(":=");
                break;
            }
            case COLON_COLON_EQUAL: {
                sb.append("::=");
            }
        }
        sb.append(" ");
        this.expression.toBNF(grammarToBNF, sb, false);
        sb.append(";");
        return sb.toString();
    }

    public String toString() {
        return this.toBNF(new GrammarToBNF());
    }
}

