/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.rrdiagram.grammar.model;

import net.nextencia.rrdiagram.grammar.model.Expression;
import net.nextencia.rrdiagram.grammar.model.GrammarToBNF;
import net.nextencia.rrdiagram.grammar.model.GrammarToRRDiagram;
import net.nextencia.rrdiagram.grammar.rrdiagram.RRBreak;
import net.nextencia.rrdiagram.grammar.rrdiagram.RRElement;
import net.nextencia.rrdiagram.grammar.rrdiagram.RRText;

public class RuleReference
extends Expression {
    private String ruleName;

    public RuleReference(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    @Override
    protected RRElement toRRElement(GrammarToRRDiagram grammarToRRDiagram) {
        String ruleConsideredAsLineBreak = grammarToRRDiagram.getRuleConsideredAsLineBreak();
        if (ruleConsideredAsLineBreak != null && ruleConsideredAsLineBreak.equals(this.ruleName)) {
            return new RRBreak();
        }
        GrammarToRRDiagram.RuleLinkProvider ruleLinkProvider = grammarToRRDiagram.getRuleLinkProvider();
        return new RRText(RRText.Type.RULE, this.ruleName, ruleLinkProvider == null ? null : ruleLinkProvider.getLink(this.ruleName));
    }

    @Override
    protected void toBNF(GrammarToBNF grammarToBNF, StringBuilder sb, boolean isNested) {
        sb.append(this.ruleName);
        String ruleConsideredAsLineBreak = grammarToBNF.getRuleConsideredAsLineBreak();
        if (ruleConsideredAsLineBreak != null && ruleConsideredAsLineBreak.equals(this.ruleName)) {
            sb.append("\n");
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof RuleReference)) {
            return false;
        }
        return this.ruleName.equals(((RuleReference)o).ruleName);
    }
}

