/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.rrdiagram.grammar.model;

import java.util.ArrayList;
import java.util.Arrays;
import net.nextencia.rrdiagram.grammar.model.Expression;
import net.nextencia.rrdiagram.grammar.model.GrammarToBNF;
import net.nextencia.rrdiagram.grammar.model.GrammarToRRDiagram;
import net.nextencia.rrdiagram.grammar.model.Literal;
import net.nextencia.rrdiagram.grammar.model.Repetition;
import net.nextencia.rrdiagram.grammar.model.RuleReference;
import net.nextencia.rrdiagram.grammar.rrdiagram.RRElement;
import net.nextencia.rrdiagram.grammar.rrdiagram.RRLoop;
import net.nextencia.rrdiagram.grammar.rrdiagram.RRSequence;

public class Sequence
extends Expression {
    private Expression[] expressions;

    public Sequence(Expression ... expressions) {
        this.expressions = expressions;
    }

    public Expression[] getExpressions() {
        return this.expressions;
    }

    @Override
    protected RRElement toRRElement(GrammarToRRDiagram grammarToRRDiagram) {
        ArrayList<RRElement> rrElementList = new ArrayList<RRElement>();
        for (int i = 0; i < this.expressions.length; ++i) {
            Expression expression = this.expressions[i];
            RRElement rrElement = expression.toRRElement(grammarToRRDiagram);
            if (i < this.expressions.length - 1 && this.expressions[i + 1] instanceof Repetition) {
                Integer maxRepetitionCount;
                Repetition repetition = (Repetition)this.expressions[i + 1];
                Expression repetitionExpression = repetition.getExpression();
                if (repetitionExpression instanceof Sequence) {
                    Expression[] subExpressions = ((Sequence)repetitionExpression).getExpressions();
                    if (subExpressions.length == 2 && subExpressions[0] instanceof Literal && expression.equals(subExpressions[1]) && ((maxRepetitionCount = repetition.getMaxRepetitionCount()) == null || maxRepetitionCount > 1)) {
                        rrElement = new RRLoop(expression.toRRElement(grammarToRRDiagram), subExpressions[0].toRRElement(grammarToRRDiagram), repetition.getMinRepetitionCount(), maxRepetitionCount == null ? null : maxRepetitionCount);
                        ++i;
                    }
                } else if (expression instanceof RuleReference) {
                    RuleReference ruleLink = (RuleReference)expression;
                    if (repetitionExpression instanceof RuleReference && ((RuleReference)repetitionExpression).getRuleName().equals(ruleLink.getRuleName()) && ((maxRepetitionCount = repetition.getMaxRepetitionCount()) == null || maxRepetitionCount > 1)) {
                        rrElement = new RRLoop(ruleLink.toRRElement(grammarToRRDiagram), null, repetition.getMinRepetitionCount(), maxRepetitionCount == null ? null : maxRepetitionCount);
                        ++i;
                    }
                }
            }
            rrElementList.add(rrElement);
        }
        return new RRSequence(rrElementList.toArray(new RRElement[0]));
    }

    @Override
    protected void toBNF(GrammarToBNF grammarToBNF, StringBuilder sb, boolean isNested) {
        if (this.expressions.length == 0) {
            sb.append("( )");
            return;
        }
        if (isNested && this.expressions.length > 1) {
            sb.append("( ");
        }
        boolean isCommaSeparator = grammarToBNF.isCommaSeparator();
        for (int i = 0; i < this.expressions.length; ++i) {
            if (i > 0) {
                if (isCommaSeparator) {
                    sb.append(" ,");
                }
                sb.append(" ");
            }
            this.expressions[i].toBNF(grammarToBNF, sb, this.expressions.length == 1 && isNested || !isCommaSeparator);
        }
        if (isNested && this.expressions.length > 1) {
            sb.append(" )");
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Sequence)) {
            return false;
        }
        return Arrays.equals(this.expressions, ((Sequence)o).expressions);
    }
}

