/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.rrdiagram.grammar.rrdiagram;

import net.nextencia.rrdiagram.grammar.rrdiagram.RRDiagram;
import net.nextencia.rrdiagram.grammar.rrdiagram.RRDiagramToSVG;
import net.nextencia.rrdiagram.grammar.rrdiagram.RRElement;

public class RRSequence
extends RRElement {
    private RRElement[] rrElements;

    public RRSequence(RRElement ... rrElements) {
        this.rrElements = rrElements;
    }

    public RRElement[] getRRElements() {
        return this.rrElements;
    }

    @Override
    protected void computeLayoutInfo(RRDiagramToSVG rrDiagramToSVG) {
        int width = 0;
        int aboveConnector = 0;
        int belowConnector = 0;
        for (int i = 0; i < this.rrElements.length; ++i) {
            RRElement rrElement = this.rrElements[i];
            rrElement.computeLayoutInfo(rrDiagramToSVG);
            if (i > 0) {
                width += 10;
            }
            RRElement.LayoutInfo layoutInfo = rrElement.getLayoutInfo();
            width += layoutInfo.getWidth();
            int height = layoutInfo.getHeight();
            int connectorOffset = layoutInfo.getConnectorOffset();
            aboveConnector = Math.max(aboveConnector, connectorOffset);
            belowConnector = Math.max(belowConnector, height - connectorOffset);
        }
        this.setLayoutInfo(new RRElement.LayoutInfo(width, aboveConnector + belowConnector, aboveConnector));
    }

    @Override
    protected void toSVG(RRDiagramToSVG rrDiagramToSVG, int xOffset, int yOffset, RRDiagram.SvgContent svgContent) {
        RRElement.LayoutInfo layoutInfo = this.getLayoutInfo();
        int connectorOffset = layoutInfo.getConnectorOffset();
        int widthOffset = 0;
        for (int i = 0; i < this.rrElements.length; ++i) {
            RRElement rrElement = this.rrElements[i];
            RRElement.LayoutInfo layoutInfo2 = rrElement.getLayoutInfo();
            int width2 = layoutInfo2.getWidth();
            int connectorOffset2 = layoutInfo2.getConnectorOffset();
            int xOffset2 = widthOffset + xOffset;
            int yOffset2 = yOffset + connectorOffset - connectorOffset2;
            if (i > 0) {
                svgContent.addLineConnector(xOffset2 - 10, yOffset + connectorOffset, xOffset2, yOffset + connectorOffset);
            }
            rrElement.toSVG(rrDiagramToSVG, xOffset2, yOffset2, svgContent);
            widthOffset += 10;
            widthOffset += width2;
        }
    }
}

