/*
 * Decompiled with CFR 0.152.
 */
package net.nextencia.rrdiagram.grammar.rrdiagram;

import java.awt.Font;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import net.nextencia.rrdiagram.common.Utils;
import net.nextencia.rrdiagram.grammar.rrdiagram.RRDiagram;
import net.nextencia.rrdiagram.grammar.rrdiagram.RRDiagramToSVG;
import net.nextencia.rrdiagram.grammar.rrdiagram.RRElement;

public class RRText
extends RRElement {
    private Type type;
    private String text;
    private String link;
    private int fontYOffset;

    public RRText(Type type, String text, String link) {
        this.type = type;
        this.text = text;
        this.link = link;
    }

    public Type getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public String getLink() {
        return this.link;
    }

    @Override
    protected void computeLayoutInfo(RRDiagramToSVG rrDiagramToSVG) {
        Font font;
        Insets insets;
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
        switch (this.type) {
            case RULE: {
                insets = rrDiagramToSVG.getRuleInsets();
                font = rrDiagramToSVG.getRuleFont();
                break;
            }
            case LITERAL: {
                insets = rrDiagramToSVG.getLiteralInsets();
                font = rrDiagramToSVG.getLiteralFont();
                break;
            }
            case SPECIAL_SEQUENCE: {
                insets = rrDiagramToSVG.getSpecialSequenceInsets();
                font = rrDiagramToSVG.getSpecialSequenceFont();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type: " + (Object)((Object)this.type));
            }
        }
        LineMetrics lineMetrics = font.getLineMetrics(this.text, fontRenderContext);
        this.fontYOffset = Math.round(lineMetrics.getDescent());
        Rectangle2D stringBounds = font.getStringBounds(this.text, fontRenderContext);
        int width = (int)Math.round(stringBounds.getWidth());
        int height = (int)Math.round(stringBounds.getHeight());
        int connectorOffset = insets.top + height - this.fontYOffset;
        this.setLayoutInfo(new RRElement.LayoutInfo(width += insets.left + insets.right, height += insets.top + insets.bottom, connectorOffset));
    }

    @Override
    protected void toSVG(RRDiagramToSVG rrDiagramToSVG, int xOffset, int yOffset, RRDiagram.SvgContent svgContent) {
        RRDiagramToSVG.BoxShape shape;
        String cssTextClass;
        String cssClass;
        Font font;
        Insets insets;
        RRElement.LayoutInfo layoutInfo = this.getLayoutInfo();
        int width = layoutInfo.getWidth();
        int height = layoutInfo.getHeight();
        if (this.link != null) {
            svgContent.addElement("<a xlink:href=\"" + Utils.escapeXML(this.link) + "\">");
        }
        switch (this.type) {
            case RULE: {
                insets = rrDiagramToSVG.getRuleInsets();
                font = rrDiagramToSVG.getRuleFont();
                cssClass = svgContent.getDefinedCSSClass("r");
                cssTextClass = svgContent.getDefinedCSSClass("i");
                if (cssClass == null) {
                    String ruleBorderColor = Utils.convertColorToHtml(rrDiagramToSVG.getRuleBorderColor());
                    String ruleFillColor = Utils.convertColorToHtml(rrDiagramToSVG.getRuleFillColor());
                    Font ruleFont = rrDiagramToSVG.getRuleFont();
                    String ruleTextColor = Utils.convertColorToHtml(rrDiagramToSVG.getRuleTextColor());
                    cssClass = svgContent.setCSSClass("r", "fill:" + ruleFillColor + ";stroke:" + ruleBorderColor + ";");
                    cssTextClass = svgContent.setCSSClass("i", "fill:" + ruleTextColor + ";" + Utils.convertFontToCss(ruleFont));
                }
                shape = rrDiagramToSVG.getRuleShape();
                break;
            }
            case LITERAL: {
                insets = rrDiagramToSVG.getLiteralInsets();
                font = rrDiagramToSVG.getLiteralFont();
                cssClass = svgContent.getDefinedCSSClass("l");
                cssTextClass = svgContent.getDefinedCSSClass("j");
                if (cssClass == null) {
                    String literalBorderColor = Utils.convertColorToHtml(rrDiagramToSVG.getLiteralBorderColor());
                    String literalFillColor = Utils.convertColorToHtml(rrDiagramToSVG.getLiteralFillColor());
                    Font literalFont = rrDiagramToSVG.getLiteralFont();
                    String literalTextColor = Utils.convertColorToHtml(rrDiagramToSVG.getLiteralTextColor());
                    cssClass = svgContent.setCSSClass("l", "fill:" + literalFillColor + ";stroke:" + literalBorderColor + ";");
                    cssTextClass = svgContent.setCSSClass("j", "fill:" + literalTextColor + ";" + Utils.convertFontToCss(literalFont));
                }
                shape = rrDiagramToSVG.getLiteralShape();
                break;
            }
            case SPECIAL_SEQUENCE: {
                insets = rrDiagramToSVG.getSpecialSequenceInsets();
                font = rrDiagramToSVG.getSpecialSequenceFont();
                cssClass = svgContent.getDefinedCSSClass("s");
                cssTextClass = svgContent.getDefinedCSSClass("k");
                if (cssClass == null) {
                    String specialSequenceBorderColor = Utils.convertColorToHtml(rrDiagramToSVG.getSpecialSequenceBorderColor());
                    String specialSequenceFillColor = Utils.convertColorToHtml(rrDiagramToSVG.getSpecialSequenceFillColor());
                    Font specialSequenceFont = rrDiagramToSVG.getSpecialSequenceFont();
                    String specialSequenceTextColor = Utils.convertColorToHtml(rrDiagramToSVG.getSpecialSequenceTextColor());
                    cssClass = svgContent.setCSSClass("s", "fill:" + specialSequenceFillColor + ";stroke:" + specialSequenceBorderColor + ";");
                    cssTextClass = svgContent.setCSSClass("k", "fill:" + specialSequenceTextColor + ";" + Utils.convertFontToCss(specialSequenceFont));
                }
                shape = rrDiagramToSVG.getSpecialSequenceShape();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type: " + (Object)((Object)this.type));
            }
        }
        switch (shape) {
            case RECTANGLE: {
                svgContent.addElement("<rect class=\"" + cssClass + "\" x=\"" + xOffset + "\" y=\"" + yOffset + "\" width=\"" + width + "\" height=\"" + height + "\"/>");
                break;
            }
            case ROUNDED_RECTANGLE: {
                int rx = (insets.left + insets.right + insets.top + insets.bottom) / 4;
                svgContent.addElement("<rect class=\"" + cssClass + "\" x=\"" + xOffset + "\" y=\"" + yOffset + "\" width=\"" + width + "\" height=\"" + height + "\" rx=\"" + rx + "\"/>");
                break;
            }
            case HEXAGON: {
                int connectorOffset = layoutInfo.getConnectorOffset();
                svgContent.addLineConnector(xOffset, yOffset + connectorOffset, xOffset + insets.left, yOffset + connectorOffset);
                svgContent.addElement("<polygon class=\"" + cssClass + "\" points=\"" + xOffset + " " + (yOffset + height / 2) + " " + (xOffset + insets.left) + " " + yOffset + " " + (xOffset + width - insets.right) + " " + yOffset + " " + (xOffset + width) + " " + (yOffset + height / 2) + " " + (xOffset + width - insets.right) + " " + (yOffset + height) + " " + (xOffset + insets.left) + " " + (yOffset + height) + "\"/>");
                svgContent.addLineConnector(xOffset + width, yOffset + connectorOffset, xOffset + width - insets.right, yOffset + connectorOffset);
            }
        }
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
        Rectangle2D stringBounds = font.getStringBounds(this.text, fontRenderContext);
        int textXOffset = xOffset + insets.left;
        int textYOffset = yOffset + insets.top + (int)Math.round(stringBounds.getHeight()) - this.fontYOffset;
        svgContent.addElement("<text class=\"" + cssTextClass + "\" x=\"" + textXOffset + "\" y=\"" + textYOffset + "\">" + Utils.escapeXML(this.text) + "</text>");
        if (this.link != null) {
            svgContent.addElement("</a>");
        }
    }

    public static enum Type {
        LITERAL,
        RULE,
        SPECIAL_SEQUENCE;

    }
}

