/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.digest;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import net.nicoulaj.maven.plugins.checksum.Constants;
import net.nicoulaj.maven.plugins.checksum.digest.CRC32FileDigester;
import net.nicoulaj.maven.plugins.checksum.digest.CksumFileDigester;
import net.nicoulaj.maven.plugins.checksum.digest.FileDigester;
import net.nicoulaj.maven.plugins.checksum.digest.MessageDigestFileDigester;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DigesterFactory {
    private static DigesterFactory instance;
    protected Map<String, FileDigester> digesters = new HashMap<String, FileDigester>(Constants.SUPPORTED_ALGORITHMS.length);

    private DigesterFactory() {
    }

    public static synchronized DigesterFactory getInstance() {
        if (instance == null) {
            instance = new DigesterFactory();
        }
        return instance;
    }

    public synchronized FileDigester getFileDigester(String algorithm) throws NoSuchAlgorithmException {
        FileDigester digester = this.digesters.get(algorithm);
        if (digester == null) {
            if ("CRC32".equals(algorithm)) {
                digester = new CRC32FileDigester();
            } else if ("Cksum".equals(algorithm)) {
                digester = new CksumFileDigester();
            } else {
                try {
                    digester = new MessageDigestFileDigester(algorithm);
                }
                catch (NoSuchAlgorithmException e) {
                    if (Security.getProvider("BC") == null) {
                        Security.addProvider((Provider)new BouncyCastleProvider());
                        digester = new MessageDigestFileDigester(algorithm);
                    }
                    throw e;
                }
            }
            this.digesters.put(algorithm, digester);
        }
        return digester;
    }
}

