/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.execution.target;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.nicoulaj.maven.plugins.checksum.artifacts.ArtifactListener;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTarget;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTargetCloseException;
import net.nicoulaj.maven.plugins.checksum.mojo.ChecksumFile;
import org.codehaus.plexus.util.FileUtils;

public class ShasumSummaryFileTarget
implements ExecutionTarget {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String SHASUM_FIELD_SEPARATOR = " *";
    public static final String SHASUM_BINARY_FILE = "*";
    protected Map<ChecksumFile, Map<String, String>> filesHashcodes;
    protected SortedSet<String> algorithms;
    protected File summaryFile;
    protected final Iterable<? extends ArtifactListener> artifactListeners;

    public ShasumSummaryFileTarget(File summaryFile, Iterable<? extends ArtifactListener> artifactListeners) {
        this.summaryFile = summaryFile;
        this.artifactListeners = artifactListeners;
    }

    @Override
    public void init() {
        this.filesHashcodes = new HashMap<ChecksumFile, Map<String, String>>();
        this.algorithms = new TreeSet<String>();
    }

    @Override
    public void write(String digest, ChecksumFile file, String algorithm) {
        if (!this.filesHashcodes.containsKey(file)) {
            this.filesHashcodes.put(file, new HashMap());
        }
        Map<String, String> fileHashcodes = this.filesHashcodes.get(file);
        fileHashcodes.put(algorithm, digest);
        this.algorithms.add(algorithm);
    }

    @Override
    public void close(final String subPath) throws ExecutionTargetCloseException {
        StringBuilder sb = new StringBuilder();
        if (this.algorithms.size() != 1) {
            throw new ExecutionTargetCloseException("Must use only one type of hash");
        }
        Map.Entry[] entries = this.filesHashcodes.entrySet().toArray(new Map.Entry[0]);
        Arrays.sort(entries, new Comparator<Map.Entry<ChecksumFile, Map<String, String>>>(){

            @Override
            public int compare(Map.Entry<ChecksumFile, Map<String, String>> o1, Map.Entry<ChecksumFile, Map<String, String>> o2) {
                ChecksumFile f1 = o1.getKey();
                ChecksumFile f2 = o2.getKey();
                return f1.getRelativePath(f1, subPath).compareTo(f2.getRelativePath(f2, subPath));
            }
        });
        for (Map.Entry entry : entries) {
            ChecksumFile file = (ChecksumFile)entry.getKey();
            Map fileHashcodes = (Map)entry.getValue();
            for (String algorithm : this.algorithms) {
                if (!fileHashcodes.containsKey(algorithm)) continue;
                sb.append((String)fileHashcodes.get(algorithm));
            }
            sb.append(SHASUM_FIELD_SEPARATOR).append(file.getRelativePath((ChecksumFile)entry.getKey(), subPath)).append(LINE_SEPARATOR);
        }
        FileUtils.mkdir((String)this.summaryFile.getParent());
        try {
            FileUtils.fileWrite((String)this.summaryFile.getPath(), (String)"US-ASCII", (String)sb.toString());
            for (ArtifactListener artifactListener : this.artifactListeners) {
                artifactListener.artifactCreated(this.summaryFile, "sum", null, null);
            }
        }
        catch (IOException e) {
            throw new ExecutionTargetCloseException(e.getMessage());
        }
    }
}

