/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.smooth.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class Collect {
    private Collect() {
    }

    @SafeVarargs
    public static <E> List<E> listOf(E ... elements) {
        return Collections.unmodifiableList(Arrays.asList(elements));
    }

    @SafeVarargs
    public static <E> Set<E> setOf(E ... elements) {
        HashSet result = new HashSet();
        Collections.addAll(result, elements);
        return Collections.unmodifiableSet(result);
    }

    public static <E> List<E> iteratorToList(Iterator<E> iter) {
        return Collections.unmodifiableList((List)Collect.iteratorToCollection(iter, new ArrayList()));
    }

    public static <E> Set<E> iteratorToSet(Iterator<E> iter) {
        return Collections.unmodifiableSet((Set)Collect.iteratorToCollection(iter, new HashSet()));
    }

    public static <E> Iterator<E> enumerationToIterator(final Enumeration<E> enumeration) {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public E next() {
                return enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove operation is not supported");
            }
        };
    }

    private static <E> Collection<E> iteratorToCollection(Iterator<E> iter, Collection<E> collection) {
        while (iter.hasNext()) {
            collection.add(iter.next());
        }
        return collection;
    }
}

