/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.smooth.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.ninjacat.smooth.functions.Func;
import net.ninjacat.smooth.functions.Predicate;

public final class Lists {
    private Lists() {
    }

    public static <E, R> List<R> map(List<E> list, Func<R, E> mapFunc) {
        ArrayList<R> result = new ArrayList<R>(list.size());
        for (E e : list) {
            result.add(mapFunc.apply(e));
        }
        return Collections.unmodifiableList(result);
    }

    public static <E> List<E> filter(List<E> list, Predicate<E> filterFunc) {
        ArrayList<E> result = new ArrayList<E>();
        for (E e : list) {
            if (!filterFunc.matches(e)) continue;
            result.add(e);
        }
        return Collections.unmodifiableList(result);
    }

    public static <T> List<T> of(T ... elements) {
        return Arrays.asList(elements);
    }
}

