/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.smooth.collections;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.ninjacat.smooth.functions.Func;
import net.ninjacat.smooth.utils.Pair;

public final class Maps {
    private Maps() {
    }

    public static <K, V> Map<K, V> of(Object ... pairs) {
        if (0 != pairs.length % 2) {
            throw new IllegalArgumentException("Initializer should have even number of elements");
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < pairs.length; i += 2) {
            map.put(pairs[i], pairs[i + 1]);
        }
        return map;
    }

    public static <K, V> Map<K, V> of(Pair<K, V> ... pairs) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Pair<K, V> pair : pairs) {
            map.put(pair.getLeft(), pair.getRight());
        }
        return map;
    }

    public static <K, V> Map<K, V> toMap(Iterable<V> list, Func<K, V> keyGenerator) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (V item : list) {
            map.put(keyGenerator.apply(item), item);
        }
        return map;
    }

    public static <K, V> Map<K, V> toUnmodifiableMap(Iterable<V> list, Func<K, V> keyGenerator) {
        return Collections.unmodifiableMap(Maps.toMap(list, keyGenerator));
    }
}

