/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.smooth.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import net.ninjacat.smooth.concurrent.Future;
import net.ninjacat.smooth.functions.Func;
import net.ninjacat.smooth.functions.Procedure;

class ChainableFuture<E, T>
extends Future<E> {
    ChainableFuture(Future<T> parent, final Func<E, T> transform, ExecutorService executorService) {
        super(executorService);
        Procedure onPrevSuccess = new Procedure<T>(){

            @Override
            public void call(final T t) {
                ChainableFuture.this.doIt(new Callable<E>(){

                    @Override
                    public E call() throws Exception {
                        return transform.apply(t);
                    }
                });
            }
        };
        Procedure<Throwable> onPrevFailed = new Procedure<Throwable>(){

            @Override
            public void call(final Throwable throwable) {
                ChainableFuture.this.doIt(new Callable<E>(){

                    @Override
                    public E call() throws Exception {
                        throw (Exception)throwable;
                    }
                });
            }
        };
        parent.onSuccess(onPrevSuccess);
        parent.onFailure(onPrevFailed);
    }
}

