/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.smooth.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.ninjacat.smooth.concurrent.ChainableFuture;
import net.ninjacat.smooth.functions.Func;
import net.ninjacat.smooth.functions.Procedure;
import net.ninjacat.smooth.utils.Try;
import net.ninjacat.smooth.validator.Validators;

public class Future<E> {
    private static final ExecutorService DEFAULT_EXECUTOR_SERVICE = Executors.newCachedThreadPool();
    private final ExecutorService executor;
    private final CountDownLatch latch;
    private volatile Procedure<E> successHandler;
    private volatile Procedure<Throwable> failHandler;
    private volatile Try<E> result;
    private volatile boolean executedOnce;

    public Future() {
        this(null);
    }

    public Future(ExecutorService executor) {
        this.executor = null == executor ? DEFAULT_EXECUTOR_SERVICE : executor;
        this.result = null;
        this.latch = new CountDownLatch(1);
    }

    public static <E> Future<E> run(Callable<E> block) {
        return new Future<E>().doIt(block);
    }

    public final <T> Future<T> then(Func<T, E> transform) {
        return new ChainableFuture<T, E>(this, transform, this.executor);
    }

    public final Future<E> onSuccess(Procedure<E> onSuccess) {
        Validators.validateNull(this.successHandler, new IllegalStateException("Cannot reassign onSuccess handler"));
        if (null != this.result && this.result.isSuccessful()) {
            onSuccess.call(this.result.getValue());
        } else {
            this.successHandler = onSuccess;
        }
        return this;
    }

    public final Future<E> onFailure(Procedure<Throwable> onFailure) {
        Validators.validateNull(this.failHandler, new IllegalStateException("Cannot reassign onFailure handler"));
        if (null != this.result && !this.result.isSuccessful()) {
            onFailure.call(this.result.getFailure());
        } else {
            this.failHandler = onFailure;
        }
        return this;
    }

    public final Future<E> doIt(final Callable<E> callable) {
        if (this.executedOnce) {
            throw new IllegalStateException("Cannot execute more than once");
        }
        this.executedOnce = true;
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                Future.this.result = Try.execute(callable);
                if (Future.this.result.isSuccessful()) {
                    Future.this.reportSuccess(Future.this.result.getValue());
                } else {
                    Future.this.reportFailure(Future.this.result.getFailure());
                }
                Future.this.latch.countDown();
            }
        });
        return this;
    }

    public Try<E> getResult() {
        try {
            this.latch.await();
            return this.result;
        }
        catch (InterruptedException e) {
            return Try.failure(e);
        }
    }

    public boolean isCompleted() {
        return this.latch.getCount() == 0L;
    }

    private void reportSuccess(E value) {
        if (null != this.successHandler) {
            this.successHandler.call(value);
        }
    }

    private void reportFailure(Throwable fail) {
        if (null != this.failHandler) {
            this.failHandler.call(fail);
        }
    }
}

