/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.smooth.functions;

import net.ninjacat.smooth.functions.Predicate;

public final class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> not(final Predicate<T> predicate) {
        return new Predicate<T>(){

            @Override
            public boolean matches(T t) {
                return !predicate.matches(t);
            }
        };
    }

    public static <T> Predicate<T> isNull() {
        return new Predicate<T>(){

            @Override
            public boolean matches(T t) {
                return null == t;
            }
        };
    }

    public static <T> Predicate<T> isNotNull() {
        return new Predicate<T>(){

            @Override
            public boolean matches(T t) {
                return null != t;
            }
        };
    }

    public static <T> Predicate<T> instanceOf(final Class cls) {
        return new Predicate<T>(){

            @Override
            public boolean matches(T t) {
                return cls.isAssignableFrom(t.getClass());
            }
        };
    }

    public static <T> Predicate<T> assignableFrom(final Class cls) {
        return new Predicate<T>(){

            @Override
            public boolean matches(T t) {
                return t.getClass().isAssignableFrom(cls);
            }
        };
    }
}

