/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.smooth.iterators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import net.ninjacat.smooth.functions.Procedure;
import net.ninjacat.smooth.iterators.Collector;
import net.ninjacat.smooth.iterators.Iter;

public final class Collectors {
    private Collectors() {
    }

    public static <T> Collector<T> arrayList() {
        return Collectors.anyCollector(new ArrayList());
    }

    public static <T> Collector<T> linkedList() {
        return Collectors.anyCollector(new LinkedList());
    }

    public static <T> Collector<T> hashSet() {
        return Collectors.anyCollector(new HashSet());
    }

    public static <T> Collector<T> treeSet() {
        return Collectors.anyCollector(new TreeSet());
    }

    private static <T> Collector<T> anyCollector(final Collection<T> collection) {
        return new Collector<T>(){

            @Override
            public Collection<T> collect(Iterable<T> iterable) {
                AddToCollection collector = new AddToCollection(collection);
                Iter.of(iterable.iterator()).forEach(collector);
                return collector.getCollection();
            }
        };
    }

    private static final class AddToCollection<T>
    extends Procedure<T> {
        private final Collection<T> collection;

        private AddToCollection(Collection<T> collection) {
            this.collection = collection;
        }

        @Override
        public void call(T t) {
            this.collection.add(t);
        }

        public Collection<T> getCollection() {
            return this.collection;
        }
    }
}

