/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.smooth.iterators;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.ninjacat.smooth.collections.Collect;
import net.ninjacat.smooth.collections.Maps;
import net.ninjacat.smooth.functions.Func;
import net.ninjacat.smooth.functions.Function2;
import net.ninjacat.smooth.functions.Predicate;
import net.ninjacat.smooth.functions.Procedure;
import net.ninjacat.smooth.functions.Promise;
import net.ninjacat.smooth.iterators.Collector;

public class Iter<E>
implements Iterable<E> {
    private final Iterator<E> iterator;

    Iter(Iterator<E> iterator) {
        this.iterator = iterator;
    }

    public static <E> Iter<E> of(Enumeration<E> enumeration) {
        return new Iter<E>(Collect.enumerationToIterator(enumeration));
    }

    public static <E> Iter<E> of(Collection<E> coll) {
        return new Iter<E>(coll.iterator());
    }

    public static <E> Iter<E> of(Iterator<E> iter) {
        return new Iter<E>(iter);
    }

    public static <E> Iter<E> of(E ... data) {
        return Iter.of(Arrays.asList(data));
    }

    public static <E> Iter<E> fromArray(E[] data) {
        return Iter.of(Arrays.asList(data));
    }

    public List<E> toList() {
        return Collect.iteratorToList(this.iterator);
    }

    public Set<E> toSet() {
        return Collect.iteratorToSet(this.iterator);
    }

    public E[] toArray(E[] array) {
        return this.toList().toArray(array);
    }

    public E[] toArray(Class<E> arrayType) {
        List<E> list = this.toList();
        Object[] array = (Object[])Array.newInstance(arrayType, list.size());
        list.toArray(array);
        return array;
    }

    public <R> Iter<R> map(final Func<R, E> func) {
        return new Iter<E>(new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return Iter.this.iterator.hasNext();
            }

            @Override
            public R next() {
                return func.apply(Iter.this.iterator.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Mapped rich iterators does not support remove()");
            }
        });
    }

    @Override
    public void forEach(Procedure<E> executor) {
        while (this.iterator.hasNext()) {
            executor.call(this.iterator.next());
        }
    }

    public <R> R reduce(R starting, Function2<R, R, E> f) {
        R result = starting;
        while (this.iterator.hasNext()) {
            result = f.apply(result, this.iterator.next());
        }
        return result;
    }

    public <R> Promise<R> lazyReduce(final R starting, final Function2<R, R, E> f) {
        return new Promise<R>(){

            @Override
            public R get() {
                Object result = starting;
                while (Iter.this.iterator.hasNext()) {
                    result = f.apply(result, Iter.this.iterator.next());
                }
                return result;
            }
        };
    }

    public Iter<E> filter(final Predicate<E> predicate) {
        return new Iter<E>(new Iterator<E>(){
            private E nextValue;

            @Override
            public boolean hasNext() {
                if (null != this.nextValue) {
                    return true;
                }
                while (Iter.this.iterator.hasNext()) {
                    this.nextValue = Iter.this.iterator.next();
                    if (!predicate.matches(this.nextValue)) continue;
                    return true;
                }
                this.nextValue = null;
                return false;
            }

            @Override
            public E next() {
                if (null != this.nextValue) {
                    Object result = this.nextValue;
                    this.nextValue = null;
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    public E find(Predicate<E> matcher, E defaultValue) {
        while (this.iterator.hasNext()) {
            E next = this.iterator.next();
            if (!matcher.matches(next)) continue;
            return next;
        }
        return defaultValue;
    }

    public Promise<E> lazyFind(final Predicate<E> matcher, final E defaultValue) {
        return new Promise<E>(){

            @Override
            public E get() {
                while (Iter.this.iterator.hasNext()) {
                    Object next = Iter.this.iterator.next();
                    if (!matcher.matches(next)) continue;
                    return next;
                }
                return defaultValue;
            }
        };
    }

    public boolean all(Predicate<E> matcher) {
        while (this.iterator.hasNext()) {
            if (matcher.matches(this.iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean any(Predicate<E> matcher) {
        while (this.iterator.hasNext()) {
            if (!matcher.matches(this.iterator.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return this.iterator;
    }

    public String mkStr(String separator) {
        StringBuilder builder = new StringBuilder();
        while (this.iterator.hasNext()) {
            builder.append(this.iterator.next().toString());
            if (!this.iterator.hasNext()) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public Collection<E> collectWith(Collector<E> collector) {
        return collector.collect(this);
    }

    public <K> Map<K, E> toMap(Func<K, E> keyGenerator) {
        return Maps.toUnmodifiableMap(this, keyGenerator);
    }
}

