/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.smooth.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.ninjacat.smooth.iterators.Iter;

public final class Iters {
    private Iters() {
    }

    public static Iter<Integer> range(final int from, final int to) {
        return Iter.of(new Iterator<Integer>(){
            private int position;
            {
                this.position = from;
            }

            @Override
            public boolean hasNext() {
                return this.position < to;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int result = this.position++;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("ranges does not support remove()");
            }
        });
    }

    public static Iter<Integer> range(int to) {
        return Iters.range(0, to);
    }

    public static <T> Iter<T> repeat(final T value, final int count) {
        return Iter.of(new Iterator<T>(){
            private int position = 0;

            @Override
            public boolean hasNext() {
                return this.position < count;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.position;
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("ranges does not support remove()");
            }
        });
    }
}

