/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.smooth.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.ninjacat.smooth.collections.Collect;
import net.ninjacat.smooth.functions.Func;
import net.ninjacat.smooth.functions.Function2;
import net.ninjacat.smooth.functions.Predicate;
import net.ninjacat.smooth.functions.Promise;
import net.ninjacat.smooth.iterators.Iter;

public class LazyIter<E>
implements Iterable<E> {
    private final Iter<E> collection;

    private LazyIter(Iterable<E> iterable) {
        this.collection = new Iter<E>(iterable.iterator());
    }

    private LazyIter(Iterator<E> iterable) {
        this.collection = new Iter<E>(iterable);
    }

    public static <E> LazyIter<E> of(Collection<E> coll) {
        return new LazyIter<E>(Collections.unmodifiableCollection(coll));
    }

    public static <E> LazyIter<E> of(E head, Collection<E> tail) {
        ArrayList<E> holder = new ArrayList<E>(tail.size() + 1);
        holder.add(head);
        holder.addAll(tail);
        return new LazyIter(holder);
    }

    public static <E> LazyIter<E> of(E ... data) {
        return LazyIter.of(Arrays.asList(data));
    }

    public List<E> toList() {
        return Collect.iteratorToList(this.collection.iterator());
    }

    public Set<E> toSet() {
        return Collect.iteratorToSet(this.collection.iterator());
    }

    public E[] toArray(E[] array) {
        return this.toList().toArray(array);
    }

    @Override
    public Iterator<E> iterator() {
        return this.collection.iterator();
    }

    public <R> LazyIter<R> map(Func<R, E> func) {
        return new LazyIter<R>(this.collection.map(func));
    }

    public <R> Promise<R> reduce(final R starting, final Function2<R, R, E> f) {
        return new Promise<R>(){

            @Override
            public R get() {
                return LazyIter.this.collection.reduce(starting, f);
            }
        };
    }

    public LazyIter<E> filter(Predicate<E> predicate) {
        return new LazyIter<E>(this.collection.filter(predicate));
    }

    public E head() {
        return this.collection.iterator().next();
    }

    public LazyIter<E> tail() {
        Iterator<E> iter = this.collection.iterator();
        iter.next();
        return new LazyIter<E>(iter);
    }

    public Promise<E> find(final Predicate<E> matcher, final E defaultValue) {
        return new Promise<E>(){

            @Override
            public E get() {
                return LazyIter.this.collection.find(matcher, defaultValue);
            }
        };
    }

    public Promise<Boolean> all(final Predicate<E> matcher) {
        return new Promise<Boolean>(){

            @Override
            public Boolean get() {
                return LazyIter.this.collection.all(matcher);
            }
        };
    }

    public Promise<Boolean> any(final Predicate<E> matcher) {
        return new Promise<Boolean>(){

            @Override
            public Boolean get() {
                return LazyIter.this.collection.any(matcher);
            }
        };
    }
}

