/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.smooth.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class MultiIterable<T>
implements Iterable<T> {
    private final List<Iterable<T>> collections;

    public MultiIterable(Iterable<T> ... iterables) {
        this.collections = new ArrayList<Iterable<T>>(Arrays.asList(iterables));
    }

    public MultiIterable() {
        this.collections = new ArrayList<Iterable<T>>();
    }

    public void append(Iterable<T> iterable) {
        this.collections.add(iterable);
    }

    @Override
    public Iterator<T> iterator() {
        return new MultiIterator();
    }

    private class MultiIterator
    implements Iterator<T> {
        private final Iterator<Iterable<T>> masterIterator;
        private Iterator<T> slaveIterator;
        private boolean noMoreItems;

        private MultiIterator() {
            this.masterIterator = MultiIterable.this.collections.iterator();
            this.noMoreItems = !this.moveToNextCollection();
        }

        @Override
        public boolean hasNext() {
            if (this.noMoreItems) {
                return false;
            }
            if (this.slaveIterator.hasNext()) {
                return true;
            }
            if (this.moveToNextCollection()) {
                return this.slaveIterator.hasNext();
            }
            this.noMoreItems = true;
            return false;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                return this.slaveIterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean moveToNextCollection() {
            if (this.masterIterator.hasNext()) {
                this.slaveIterator = this.masterIterator.next().iterator();
                return true;
            }
            return false;
        }
    }
}

