/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.smooth.strings;

import java.util.Set;
import net.ninjacat.smooth.strings.Trie;
import net.ninjacat.smooth.strings.TrieNode;
import net.ninjacat.smooth.utils.Option;

public class ImmutableTrie<T>
implements Trie<T> {
    private final TrieNode<T> root;

    public ImmutableTrie() {
        this.root = new TrieNode();
    }

    private ImmutableTrie(TrieNode<T> root) {
        this.root = root;
    }

    @Override
    public void put(String text, T value) {
        throw new UnsupportedOperationException("Cannot change immutable Trie");
    }

    @Override
    public boolean contains(String text) {
        return this.root.contains(text);
    }

    @Override
    public Set<String> keySet() {
        return this.root.toSet();
    }

    @Override
    public Set<String> startingWith(String text) {
        return this.root.startingWith(text);
    }

    @Override
    public Option<T> get(String text) {
        return this.root.get(text);
    }

    public static class Builder<T> {
        private final TrieNode<T> root = new TrieNode();

        public Builder<T> put(String key, T value) {
            this.root.put(key, value);
            return this;
        }

        public ImmutableTrie<T> build() {
            return new ImmutableTrie(this.root);
        }
    }
}

