/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.smooth.strings;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.ninjacat.smooth.utils.Option;

final class TrieNode<T> {
    private final Map<Character, TrieNode<T>> children = new ConcurrentHashMap<Character, TrieNode<T>>();
    private Option<T> value = Option.absent();

    TrieNode() {
    }

    TrieNode(String text, T value) {
        this.put(text, value);
    }

    public void put(String text, T nodeValue) {
        if (text == null || text.isEmpty()) {
            if (this.value.isPresent()) {
                throw new IllegalStateException("Cannot modify trie node");
            }
            this.value = Option.of(nodeValue);
            return;
        }
        Character head = Character.valueOf(text.charAt(0));
        String tail = text.substring(1);
        if (this.children.containsKey(head)) {
            this.children.get(head).put(tail, nodeValue);
        } else {
            this.children.put(head, new TrieNode<T>(tail, nodeValue));
        }
    }

    public int count() {
        int count = 0;
        for (TrieNode<T> node : this.children.values()) {
            count += node.isTerminal() ? 1 : node.count();
        }
        return count;
    }

    public boolean contains(String text) {
        return this.internalContains(text, "");
    }

    public Option<T> get(String text) {
        return this.internalGet(text, "");
    }

    public Set<String> startingWith(String text) {
        HashSet<String> results = new HashSet<String>();
        this.internalStartingWith(text, "", results);
        return results;
    }

    public Set<String> toSet() {
        HashSet<String> results = new HashSet<String>();
        this.internalToList("", results);
        return results;
    }

    boolean isTerminal() {
        return this.children.isEmpty();
    }

    private boolean internalContains(String text, String heading) {
        if (text == null || text.isEmpty()) {
            return this.isTerminal();
        }
        Character head = Character.valueOf(text.charAt(0));
        String tail = text.substring(1);
        if (this.children.containsKey(head)) {
            return super.internalContains(tail, heading + head);
        }
        return heading.equals(text);
    }

    private Option<T> internalGet(String text, String heading) {
        if (text == null || text.isEmpty()) {
            return this.isTerminal() ? this.value : Option.absent();
        }
        Character head = Character.valueOf(text.charAt(0));
        String tail = text.substring(1);
        if (this.children.containsKey(head)) {
            return super.internalGet(tail, heading + head);
        }
        return Option.absent();
    }

    private void internalStartingWith(String text, String heading, Set<String> results) {
        if (text == null || text.isEmpty()) {
            this.internalToList(heading, results);
            return;
        }
        Character head = Character.valueOf(text.charAt(0));
        String tail = text.substring(1);
        if (this.children.containsKey(head)) {
            super.internalStartingWith(tail, heading + head, results);
        } else {
            results.add(heading);
        }
    }

    private void internalToList(String heading, Set<String> results) {
        if (this.isTerminal()) {
            results.add(heading);
            return;
        }
        for (Map.Entry<Character, TrieNode<T>> entry : this.children.entrySet()) {
            super.internalToList(heading + entry.getKey(), results);
        }
    }
}

