/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.smooth.utils;

public abstract class Either<F, S> {
    private Either() {
    }

    public static <F, S> Either<F, S> first(F val) {
        return new First(val);
    }

    public static <F, S> Either<F, S> second(S val) {
        return new Second(val);
    }

    public abstract boolean hasFirst();

    public abstract boolean hasSecond();

    public abstract F getFirst();

    public abstract S getSecond();

    public static final class Second<F, S>
    extends Either<F, S> {
        private final S second;

        private Second(S second) {
            this.second = second;
        }

        @Override
        public boolean hasFirst() {
            return false;
        }

        @Override
        public boolean hasSecond() {
            return true;
        }

        @Override
        public F getFirst() {
            throw new IllegalStateException("Has no first");
        }

        @Override
        public S getSecond() {
            return this.second;
        }
    }

    public static final class First<F, S>
    extends Either<F, S> {
        private final F first;

        private First(F first) {
            this.first = first;
        }

        @Override
        public boolean hasFirst() {
            return true;
        }

        @Override
        public boolean hasSecond() {
            return false;
        }

        @Override
        public F getFirst() {
            return this.first;
        }

        @Override
        public S getSecond() {
            throw new IllegalStateException("Has no second");
        }
    }
}

