/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.smooth.utils;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import net.ninjacat.smooth.iterators.Iter;

public class Joiner {
    public static final Joiner PATH_JOINER = Joiner.on(File.separator).skipNulls().noDuplicateSeparators();
    private final String separator;
    private final String nullValue;
    private final boolean skipNulls;
    private final boolean duplicateSeparators;

    private Joiner(String separator, String nullValue, boolean skipNulls, boolean duplicateSeparators) {
        this.separator = separator;
        this.nullValue = nullValue;
        this.skipNulls = skipNulls;
        this.duplicateSeparators = duplicateSeparators;
    }

    public static Joiner on(String separator) {
        return new Joiner(separator, null, false, true);
    }

    public Joiner useForNulls(String forNulls) {
        return this.skipNulls ? this : new Joiner(this.separator, forNulls, false, this.duplicateSeparators);
    }

    public Joiner skipNulls() {
        return new Joiner(this.separator, this.nullValue, true, this.duplicateSeparators);
    }

    public Joiner noDuplicateSeparators() {
        return new Joiner(this.separator, this.nullValue, this.skipNulls, false);
    }

    public String join(Object ... parts) {
        StringBuilder builder = new StringBuilder();
        try {
            this.appendIterableTo(builder, Iter.of(parts));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return builder.toString();
    }

    public String joinIterable(Iterable<?> parts) {
        StringBuilder builder = new StringBuilder();
        try {
            this.appendIterableTo(builder, parts);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return builder.toString();
    }

    public <A extends Appendable> void appendTo(A appendable, Object ... parts) throws IOException {
        this.appendIterableTo(appendable, Iter.of(parts));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <A extends Appendable> void appendIterableTo(A appendable, Iterable<?> parts) throws IOException {
        boolean notFirstPart = false;
        Iterator<?> iterator = parts.iterator();
        while (iterator.hasNext()) {
            String partValue;
            Object part = iterator.next();
            if (null == part) {
                if (this.skipNulls) continue;
                if (null == this.nullValue) throw new IllegalArgumentException("Cannot join null parts");
                partValue = this.nullValue;
            } else {
                partValue = part.toString();
            }
            boolean hasNext = iterator.hasNext();
            if (this.duplicateSeparators) {
                appendable.append(partValue);
                if (hasNext) {
                    appendable.append(this.separator);
                }
            } else {
                String updatedPart = partValue;
                if (notFirstPart && partValue.startsWith(this.separator)) {
                    updatedPart = updatedPart.substring(this.separator.length());
                }
                if (partValue.endsWith(this.separator) && hasNext) {
                    updatedPart = updatedPart.substring(0, updatedPart.length() - this.separator.length());
                }
                appendable.append(updatedPart);
                if (hasNext) {
                    appendable.append(this.separator);
                }
            }
            notFirstPart = true;
        }
    }
}

