/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.smooth.utils;

import net.ninjacat.smooth.functions.Func;
import net.ninjacat.smooth.functions.Procedure;
import net.ninjacat.smooth.functions.Provider;
import net.ninjacat.smooth.utils.Try;

public class Option<T> {
    private static final Option<?> ABSENT = new Option<Object>(null);
    private final T ref;

    Option(T ref) {
        this.ref = ref;
    }

    public static <T> Option<T> absent() {
        return ABSENT;
    }

    public static <T> Option<T> of(T value) {
        return new Option<T>(value);
    }

    public boolean isPresent() {
        return null != this.ref;
    }

    public void ifPresent(Procedure<T> proc) {
        if (this.isPresent()) {
            proc.apply((Object)this.ref);
        }
    }

    public T or(T alternative) {
        return this.isPresent() ? this.ref : alternative;
    }

    public T orGet(Provider<T> provider) {
        return this.isPresent() ? this.ref : provider.get();
    }

    public T orNull() {
        return this.isPresent() ? (T)this.ref : null;
    }

    public T get() {
        if (null == this.ref) {
            throw new NullPointerException("No value");
        }
        return this.ref;
    }

    public <K> Option<K> map(Func<K, T> transform) {
        if (this.isPresent()) {
            return Try.execute(transform).with(this.ref).get();
        }
        return Option.absent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        Option option = (Option)o;
        return !(null != this.ref ? !this.ref.equals(option.ref) : null != option.ref);
    }

    public int hashCode() {
        return null != this.ref ? this.ref.hashCode() : 0;
    }

    public String toString() {
        if (this.isPresent()) {
            return "Option{" + this.ref + '}';
        }
        return "Option{ absent }";
    }
}

