/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.smooth.utils;

import java.util.concurrent.Callable;
import net.ninjacat.smooth.functions.Func;
import net.ninjacat.smooth.utils.Option;

public abstract class Try<T> {
    private Try() {
    }

    public static <T> Try<T> execute(Callable<T> code) {
        try {
            return Try.success(code.call());
        }
        catch (Throwable thr) {
            return Try.failure(thr);
        }
    }

    public static <T> Try<T> success(T value) {
        return new Success<T>(value);
    }

    public static <T> Try<T> failure(Throwable fail) {
        return new Failure(fail);
    }

    public static <P, T> FunctionExecutor<T, P> execute(Func<T, P> func) {
        return new FunctionExecutor(func);
    }

    public abstract boolean isSuccessful();

    public abstract T getValue();

    public abstract Throwable getFailure();

    public <S> Try<S> then(Func<S, T> mapper) {
        if (this.isSuccessful()) {
            return Try.execute(mapper).with(this.getValue());
        }
        return new Failure(this.getFailure());
    }

    public Try<T> recover(Callable<T> recoverCode) {
        if (this.isSuccessful()) {
            return this;
        }
        return Try.execute(recoverCode);
    }

    public Option<T> get() {
        if (this.isSuccessful()) {
            return Option.of(this.getValue());
        }
        return Option.absent();
    }

    public static final class FunctionExecutor<R, P> {
        private final Func<R, P> function;

        private FunctionExecutor(Func<R, P> function) {
            this.function = function;
        }

        public Try<R> with(P parameter) {
            try {
                return Try.success(this.function.apply(parameter));
            }
            catch (Throwable thr) {
                return Try.failure(thr);
            }
        }
    }

    static final class Failure<T>
    extends Try<T> {
        private final Throwable failure;

        Failure(Throwable failure) {
            this.failure = failure;
        }

        @Override
        public Throwable getFailure() {
            return this.failure;
        }

        @Override
        public boolean isSuccessful() {
            return false;
        }

        @Override
        public T getValue() {
            throw new IllegalStateException("Failure does not contain result");
        }
    }

    static final class Success<T>
    extends Try<T> {
        private final T value;

        Success(T value) {
            this.value = value;
        }

        @Override
        public boolean isSuccessful() {
            return true;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public Throwable getFailure() {
            throw new IllegalStateException("Success does not contain failure");
        }
    }
}

