/*
 * Decompiled with CFR 0.152.
 */
package net.ninjacat.smooth.validator;

import net.ninjacat.smooth.validator.Predicates;

public final class Validators {
    private Validators() {
    }

    public static <T, E extends Exception> void validateNotNull(T o, E onFailure) throws E {
        if (Predicates.matchesNull().matches(o)) {
            throw onFailure;
        }
    }

    public static <T, E extends Exception> void validateNull(T o, E onFailure) throws E {
        if (!Predicates.matchesNull().matches(o)) {
            throw onFailure;
        }
    }

    public static <T> void validateNotNull(T o) {
        if (Predicates.matchesNull().matches(o)) {
            throw new NullPointerException("Value should not be null");
        }
    }

    public static <T> void validateNull(T o) {
        if (!Predicates.matchesNull().matches(o)) {
            throw new IllegalStateException("Value should be null");
        }
    }
}

