/*
 * Decompiled with CFR 0.152.
 */
package nodebox.graphics;

import com.google.common.base.Function;
import java.util.Iterator;
import nodebox.graphics.AbstractTransformable;
import nodebox.graphics.IGeometry;
import nodebox.graphics.Point;

public abstract class AbstractGeometry
extends AbstractTransformable
implements IGeometry {
    @Override
    public void extend(Iterator<Point> points) {
        while (points.hasNext()) {
            Point point = points.next();
            this.addPoint(point);
        }
    }

    @Override
    public void extend(Point[] points) {
        for (Point point : points) {
            this.addPoint(point);
        }
    }

    @Override
    public Point[] makePoints() {
        return this.makePoints(100, false);
    }

    @Override
    public Point[] makePoints(int amount) {
        return this.makePoints(amount, false);
    }

    protected double pointDelta(int amount, boolean closed) {
        double delta = 1.0;
        if (closed) {
            if (amount > 0) {
                delta = 1.0 / (double)amount;
            }
        } else if (amount > 2) {
            delta = 1.0 / ((double)amount - 1.0);
        }
        return delta;
    }

    public abstract Point pointAt(double var1);

    @Override
    public abstract IGeometry clone();

    public abstract AbstractGeometry mapPoints(Function<Point, Point> var1);
}

