/*
 * Decompiled with CFR 0.152.
 */
package nodebox.graphics;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import nodebox.graphics.Color;
import nodebox.graphics.ContextTransformDelegate;
import nodebox.graphics.Contour;
import nodebox.graphics.Geometry;
import nodebox.graphics.GraphicsContext;
import nodebox.graphics.Grob;
import nodebox.graphics.Image;
import nodebox.graphics.NodeBoxError;
import nodebox.graphics.Path;
import nodebox.graphics.Point;
import nodebox.graphics.Rect;
import nodebox.graphics.Size;
import nodebox.graphics.Text;
import nodebox.graphics.Transform;
import nodebox.graphics.TransformDelegate;

public abstract class AbstractGraphicsContext
implements GraphicsContext {
    protected Color.Mode colorMode;
    protected double colorRange;
    protected Color fillColor;
    protected Color strokeColor;
    protected double strokeWidth;
    protected Path path;
    protected boolean autoClosePath;
    protected boolean pathClosed;
    protected Transform.Mode transformMode;
    protected Transform transform = new Transform();
    protected ArrayList<Transform> transformStack;
    protected String fontName;
    protected double fontSize;
    protected double lineHeight;
    protected Text.Align align;
    protected GraphicsContext.RectMode rectMode = GraphicsContext.RectMode.CORNER;
    protected GraphicsContext.EllipseMode ellipseMode = GraphicsContext.EllipseMode.CORNER;

    public void resetContext() {
        this.colorMode = Color.Mode.RGB;
        this.colorRange = 1.0;
        this.fillColor = new Color();
        this.strokeColor = null;
        this.strokeWidth = 1.0;
        this.path = null;
        this.autoClosePath = true;
        this.transformMode = Transform.Mode.CENTER;
        this.transform = new Transform();
        this.transformStack = new ArrayList();
        this.fontName = "Helvetica";
        this.fontSize = 24.0;
        this.lineHeight = 1.2;
        this.align = Text.Align.LEFT;
    }

    @Override
    public GraphicsContext.RectMode rectmode() {
        return this.rectMode;
    }

    @Override
    public GraphicsContext.RectMode rectmode(GraphicsContext.RectMode m) {
        this.rectMode = m;
        return this.rectMode;
    }

    @Override
    public GraphicsContext.RectMode rectmode(String m) {
        try {
            GraphicsContext.RectMode newMode;
            this.rectMode = newMode = GraphicsContext.RectMode.valueOf(m.toUpperCase(Locale.US));
            return this.rectMode;
        }
        catch (IllegalArgumentException e) {
            throw new NodeBoxError("rectmode: available types for rectmode() are CORNER, CENTER, CORNERS and RADIUS\\n\"");
        }
    }

    @Override
    public GraphicsContext.RectMode rectmode(int m) {
        try {
            GraphicsContext.RectMode newMode;
            this.rectMode = newMode = GraphicsContext.RectMode.values()[m];
            return this.rectMode;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NodeBoxError("rectmode: available types for rectmode() are CORNER, CENTER, CORNERS and RADIUS\\n\"");
        }
    }

    private Path createPath() {
        Path p = new Path();
        p.setTransformDelegate(new ContextTransformDelegate(this));
        return p;
    }

    public Path Path() {
        return this.createPath();
    }

    public Path BezierPath() {
        return this.createPath();
    }

    @Override
    public Path rect(Rect r) {
        return this.rect(r.getX(), r.getY(), r.getWidth(), r.getHeight(), true);
    }

    public Path rect(Rect r, boolean draw) {
        return this.rect(r.getX(), r.getY(), r.getWidth(), r.getHeight(), draw);
    }

    @Override
    public Path rect(double x, double y, double width, double height) {
        return this.rect(x, y, width, height, true);
    }

    public Path rect(double x, double y, double width, double height, boolean draw) {
        Path p = this.createPath();
        switch (this.rectMode) {
            case CENTER: {
                p.rect(x, y, width, height);
                break;
            }
            case CORNER: {
                p.cornerRect(x, y, width, height);
            }
        }
        this.inheritFromContext(p);
        if (draw) {
            this.addPath(p);
        }
        return p;
    }

    @Override
    public Path rect(Rect r, double roundness) {
        return this.rect(r.getX(), r.getY(), r.getWidth(), r.getHeight(), roundness, roundness, true);
    }

    public Path rect(Rect r, double roundness, boolean draw) {
        return this.rect(r.getX(), r.getY(), r.getWidth(), r.getHeight(), roundness, roundness, draw);
    }

    @Override
    public Path rect(double x, double y, double width, double height, double roundness) {
        return this.rect(x, y, width, height, roundness, roundness, true);
    }

    public Path rect(double x, double y, double width, double height, double roundness, boolean draw) {
        return this.rect(x, y, width, height, roundness, roundness, draw);
    }

    @Override
    public Path rect(double x, double y, double width, double height, double rx, double ry) {
        return this.rect(x, y, width, height, rx, ry, true);
    }

    public Path rect(double x, double y, double width, double height, double rx, double ry, boolean draw) {
        Path p = this.createPath();
        switch (this.rectMode) {
            case CENTER: {
                p.rect(x, y, width, height, rx, ry);
                break;
            }
            case CORNER: {
                p.cornerRect(x, y, width, height, rx, ry);
            }
        }
        this.inheritFromContext(p);
        if (draw) {
            this.addPath(p);
        }
        return p;
    }

    @Override
    public GraphicsContext.EllipseMode ellipsemode() {
        return this.ellipseMode;
    }

    @Override
    public GraphicsContext.EllipseMode ellipsemode(GraphicsContext.EllipseMode m) {
        this.ellipseMode = m;
        return this.ellipseMode;
    }

    @Override
    public GraphicsContext.EllipseMode ellipsemode(String m) {
        try {
            GraphicsContext.EllipseMode newMode;
            this.ellipseMode = newMode = GraphicsContext.EllipseMode.valueOf(m.toUpperCase(Locale.US));
            return this.ellipseMode;
        }
        catch (IllegalArgumentException e) {
            throw new NodeBoxError("ellipsemode: available types for ellipsemode() are CORNER, CENTER, CORNERS and RADIUS\\n\"");
        }
    }

    @Override
    public GraphicsContext.EllipseMode ellipsemode(int m) {
        try {
            GraphicsContext.EllipseMode newMode;
            this.ellipseMode = newMode = GraphicsContext.EllipseMode.values()[m];
            return this.ellipseMode;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NodeBoxError("ellipsemode: available types for ellipsemode() are CORNER, CENTER, CORNERS and RADIUS\\n\"");
        }
    }

    @Override
    public Path oval(double x, double y, double width, double height) {
        return this.ellipse(x, y, width, height, true);
    }

    @Override
    public Path oval(double x, double y, double width, double height, boolean draw) {
        return this.ellipse(x, y, width, height, draw);
    }

    @Override
    public Path ellipse(double x, double y, double width, double height) {
        return this.ellipse(x, y, width, height, true);
    }

    @Override
    public Path ellipse(double x, double y, double width, double height, boolean draw) {
        Path p = this.createPath();
        switch (this.ellipseMode) {
            case CENTER: {
                p.ellipse(x, y, width, height);
                break;
            }
            case CORNER: {
                p.cornerEllipse(x, y, width, height);
            }
        }
        this.inheritFromContext(p);
        if (draw) {
            this.addPath(p);
        }
        return p;
    }

    @Override
    public Path line(double x1, double y1, double x2, double y2) {
        return this.line(x1, y1, x2, y2, true);
    }

    @Override
    public Path line(double x1, double y1, double x2, double y2, boolean draw) {
        Path p = this.createPath();
        p.line(x1, y1, x2, y2);
        this.inheritFromContext(p);
        if (draw) {
            this.addPath(p);
        }
        return p;
    }

    @Override
    public Path star(double cx, double cy) {
        return this.star(cx, cy, 20, 100.0, 50.0, true);
    }

    @Override
    public Path star(double cx, double cy, int points) {
        return this.star(cx, cy, points, 100.0, 50.0, true);
    }

    @Override
    public Path star(double cx, double cy, int points, double outer) {
        return this.star(cx, cy, points, outer, 50.0, true);
    }

    @Override
    public Path star(double cx, double cy, int points, double outer, double inner) {
        return this.star(cx, cy, points, outer, inner, true);
    }

    @Override
    public Path star(double cx, double cy, int points, double outer, double inner, boolean draw) {
        double PI = Math.PI;
        Path p = this.createPath();
        p.moveto(cx, cy + outer);
        for (int i = 1; i < points * 2; ++i) {
            double angle = (double)i * PI / (double)points;
            double x = Math.sin(angle);
            double y = Math.cos(angle);
            double radius = i % 2 == 0 ? outer : inner;
            x += cx + radius * x;
            y += cy + radius * y;
            p.lineto(x, y);
        }
        p.close();
        this.inheritFromContext(p);
        if (draw) {
            this.addPath(p);
        }
        return p;
    }

    @Override
    public Path arrow(double x, double y) {
        return this.arrow(x, y, 100.0, GraphicsContext.ArrowType.NORMAL, true);
    }

    @Override
    public Path arrow(double x, double y, GraphicsContext.ArrowType type) {
        return this.arrow(x, y, 100.0, type, true);
    }

    @Override
    public Path arrow(double x, double y, String type) {
        return this.arrow(x, y, 100.0, type, true);
    }

    @Override
    public Path arrow(double x, double y, int type) {
        return this.arrow(x, y, 100.0, type, true);
    }

    @Override
    public Path arrow(double x, double y, double width) {
        return this.arrow(x, y, width, "NORMAL", true);
    }

    @Override
    public Path arrow(double x, double y, double width, boolean draw) {
        return this.arrow(x, y, width, "NORMAL", draw);
    }

    @Override
    public Path arrow(double x, double y, double width, GraphicsContext.ArrowType type) {
        return this.arrow(x, y, width, type, true);
    }

    @Override
    public Path arrow(double x, double y, double width, String type) {
        return this.arrow(x, y, width, type, true);
    }

    @Override
    public Path arrow(double x, double y, double width, int type) {
        return this.arrow(x, y, width, type, true);
    }

    @Override
    public Path arrow(double x, double y, double width, String type, boolean draw) {
        try {
            GraphicsContext.ArrowType arrowType = GraphicsContext.ArrowType.valueOf(type.toUpperCase(Locale.US));
            return this.arrow(x, y, width, arrowType, draw);
        }
        catch (IllegalArgumentException e) {
            throw new NodeBoxError("arrow: available types for arrow() are NORMAL and FORTYFIVE\\n\"");
        }
    }

    @Override
    public Path arrow(double x, double y, double width, int type, boolean draw) {
        try {
            GraphicsContext.ArrowType arrowType = GraphicsContext.ArrowType.values()[type];
            return this.arrow(x, y, width, arrowType, draw);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NodeBoxError("arrow: available types for arrow() are NORMAL and FORTYFIVE\\n\"");
        }
    }

    @Override
    public Path arrow(double x, double y, double width, GraphicsContext.ArrowType type, boolean draw) {
        if (type == GraphicsContext.ArrowType.NORMAL) {
            return this.arrowNormal(x, y, width, draw);
        }
        return this.arrowFortyFive(x, y, width, draw);
    }

    private Path arrowNormal(double x, double y, double width, boolean draw) {
        double head = width * 0.4;
        double tail = width * 0.2;
        Path p = this.createPath();
        p.moveto(x, y);
        p.lineto(x - head, y + head);
        p.lineto(x - head, y + tail);
        p.lineto(x - width, y + tail);
        p.lineto(x - width, y - tail);
        p.lineto(x - head, y - tail);
        p.lineto(x - head, y - head);
        p.lineto(x, y);
        p.close();
        this.inheritFromContext(p);
        if (draw) {
            this.addPath(p);
        }
        return p;
    }

    private Path arrowFortyFive(double x, double y, double width, boolean draw) {
        double head = 0.3;
        double tail = 1.0 + head;
        Path p = this.createPath();
        p.moveto(x, y);
        p.lineto(x, y + width * (1.0 - head));
        p.lineto(x - width * head, y + width);
        p.lineto(x - width * head, y + width * tail * 0.4);
        p.lineto(x - width * tail * 0.6, y + width);
        p.lineto(x - width, y + width * tail * 0.6);
        p.lineto(x - width * tail * 0.4, y + width * head);
        p.lineto(x - width, y + width * head);
        p.lineto(x - width * (1.0 - head), y);
        p.lineto(x, y);
        p.close();
        this.inheritFromContext(p);
        if (draw) {
            this.addPath(p);
        }
        return p;
    }

    @Override
    public void beginpath() {
        this.path = this.createPath();
        this.pathClosed = false;
    }

    @Override
    public void beginpath(double x, double y) {
        this.beginpath();
        this.moveto(x, y);
    }

    @Override
    public void moveto(double x, double y) {
        if (this.path == null) {
            throw new NodeBoxError("No current path. Use beginpath() first.");
        }
        this.path.moveto(x, y);
    }

    @Override
    public void lineto(double x, double y) {
        if (this.path == null) {
            throw new NodeBoxError("No current path. Use beginpath() first.");
        }
        this.path.lineto(x, y);
    }

    @Override
    public void curveto(double x1, double y1, double x2, double y2, double x3, double y3) {
        if (this.path == null) {
            throw new NodeBoxError("No current path. Use beginPath() first.");
        }
        this.path.curveto(x1, y1, x2, y2, x3, y3);
    }

    @Override
    public void closepath() {
        if (this.path == null) {
            throw new NodeBoxError("No current path. Use beginpath() first.");
        }
        if (!this.pathClosed) {
            this.path.close();
            this.pathClosed = true;
        }
    }

    @Override
    public Path endpath() {
        return this.endpath(true);
    }

    @Override
    public Path endpath(boolean draw) {
        if (this.path == null) {
            throw new NodeBoxError("No current path. Use beginpath() first.");
        }
        if (this.autoClosePath) {
            this.closepath();
        }
        Path p = this.path;
        this.inheritFromContext(p);
        if (draw) {
            this.addPath(p);
        }
        this.path = null;
        this.pathClosed = false;
        return p;
    }

    @Override
    public void drawpath(Path path) {
        this.inheritFromContext(path);
        this.addPath(path);
    }

    @Override
    public void drawpath(Iterable<Point> points) {
        Path path = this.createPath();
        for (Point pt : points) {
            path.addPoint(pt);
        }
        this.inheritFromContext(path);
        this.addPath(path);
    }

    @Override
    public boolean autoclosepath() {
        return this.autoClosePath;
    }

    @Override
    public boolean autoclosepath(boolean c) {
        this.autoClosePath = c;
        return this.autoClosePath;
    }

    @Override
    public Path findpath(List<Point> points) {
        return this.findpath(points, 1.0);
    }

    @Override
    public Path findpath(List<Point> points, double curvature) {
        Path path = Path.findPath(points, curvature);
        this.inheritFromContext(path);
        this.addPath(path);
        return path;
    }

    @Override
    public void beginclip(Path p) {
        throw new RuntimeException("beginclip is not implemented yet.");
    }

    @Override
    public void endclip() {
        throw new RuntimeException("endclip is not implemented yet.");
    }

    @Override
    public Transform.Mode transform() {
        return this.transformMode;
    }

    @Override
    public Transform.Mode transform(Transform.Mode mode) {
        this.transformMode = mode;
        return this.transformMode;
    }

    @Override
    public Transform.Mode transform(String mode) {
        try {
            Transform.Mode newMode;
            this.transformMode = newMode = Transform.Mode.valueOf(mode.toUpperCase(Locale.US));
            return this.transformMode;
        }
        catch (IllegalArgumentException e) {
            throw new NodeBoxError("transform: available types for transform() are CORNER and CENTER\\n\"");
        }
    }

    @Override
    public Transform.Mode transform(int mode) {
        try {
            Transform.Mode newMode;
            this.transformMode = newMode = Transform.Mode.values()[mode];
            return this.transformMode;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NodeBoxError("transform: available types for transform() are CORNER and CENTER\\n\"");
        }
    }

    @Override
    public void push() {
        this.transformStack.add(0, this.transform.clone());
    }

    @Override
    public void pop() {
        if (this.transformStack.isEmpty()) {
            throw new NodeBoxError("Pop: too many pops!");
        }
        this.transform = this.transformStack.get(0);
        this.transformStack.remove(0);
    }

    @Override
    public void reset() {
        this.transformStack.clear();
        this.transform = new Transform();
    }

    @Override
    public void translate(double tx, double ty) {
        this.transform.translate(tx, ty);
    }

    @Override
    public void rotate(double r) {
        this.transform.rotate(r);
    }

    @Override
    public void scale(double scale) {
        this.transform.scale(scale);
    }

    @Override
    public void scale(double sx, double sy) {
        this.transform.scale(sx, sy);
    }

    @Override
    public void skew(double skew) {
        this.transform.skew(skew);
    }

    @Override
    public void skew(double kx, double ky) {
        this.transform.skew(kx, ky);
    }

    @Override
    public String outputmode() {
        throw new RuntimeException("outputmode is not implemented yet.");
    }

    @Override
    public String outputmode(String mode) {
        throw new RuntimeException("outputmode is not implemented yet.");
    }

    @Override
    public Color.Mode colormode() {
        return this.colorMode;
    }

    @Override
    public Color.Mode colormode(Color.Mode mode) {
        this.colorMode = mode;
        return this.colorMode;
    }

    @Override
    public Color.Mode colormode(Color.Mode mode, double range) {
        this.colorRange = range;
        this.colorMode = mode;
        return this.colorMode;
    }

    @Override
    public Color.Mode colormode(String mode) {
        return this.colormode(mode, this.colorRange);
    }

    @Override
    public Color.Mode colormode(String mode, double range) {
        try {
            Color.Mode newMode = Color.Mode.valueOf(mode.toUpperCase(Locale.US));
            return this.colormode(newMode, range);
        }
        catch (IllegalArgumentException e) {
            throw new NodeBoxError("colormode: available types for colormode() are RGB, HSB and CMYK\\n\"");
        }
    }

    @Override
    public Color.Mode colormode(int mode) {
        return this.colormode(mode, this.colorRange);
    }

    @Override
    public Color.Mode colormode(int mode, double range) {
        try {
            Color.Mode newMode = Color.Mode.values()[mode];
            return this.colormode(newMode, range);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NodeBoxError("colormode: available types for colormode() are RGB, HSB and CMYK\\n\"");
        }
    }

    @Override
    public double colorrange() {
        return this.colorRange;
    }

    @Override
    public double colorrange(double range) {
        this.colorRange = range;
        return this.colorRange;
    }

    @Override
    public Color color() {
        return new Color();
    }

    @Override
    public Color color(double x) {
        double nx = this.normalize(x);
        return new Color(nx, nx, nx);
    }

    @Override
    public Color color(double x, double y) {
        double nx = this.normalize(x);
        return new Color(nx, nx, nx, this.normalize(y));
    }

    @Override
    public Color color(double x, double y, double z) {
        return new Color(this.normalize(x), this.normalize(y), this.normalize(z), this.colormode());
    }

    @Override
    public Color color(double x, double y, double z, double a) {
        return new Color(this.normalize(x), this.normalize(y), this.normalize(z), this.normalize(a), this.colormode());
    }

    @Override
    public Color color(Color c) {
        return c == null ? new Color(0.0, 0.0, 0.0, 0.0) : c.clone();
    }

    @Override
    public Color fill() {
        return this.fillColor;
    }

    @Override
    public Color fill(double x) {
        double nx = this.normalize(x);
        this.fillColor = new Color(nx, nx, nx);
        return this.fillColor;
    }

    @Override
    public Color fill(double x, double y) {
        double nx = this.normalize(x);
        this.fillColor = new Color(nx, nx, nx, this.normalize(y));
        return this.fillColor;
    }

    @Override
    public Color fill(double x, double y, double z) {
        this.fillColor = new Color(this.normalize(x), this.normalize(y), this.normalize(z), this.colormode());
        return this.fillColor;
    }

    @Override
    public Color fill(double x, double y, double z, double a) {
        this.fillColor = new Color(this.normalize(x), this.normalize(y), this.normalize(z), this.normalize(a), this.colormode());
        return this.fillColor;
    }

    @Override
    public Color fill(Color c) {
        this.fillColor = c == null ? null : c.clone();
        return this.fillColor;
    }

    @Override
    public void nofill() {
        this.fillColor = null;
    }

    @Override
    public Color stroke() {
        return this.strokeColor;
    }

    @Override
    public Color stroke(double x) {
        double nx = this.normalize(x);
        this.strokeColor = new Color(nx, nx, nx);
        return this.strokeColor;
    }

    @Override
    public Color stroke(double x, double y) {
        double nx = this.normalize(x);
        this.strokeColor = new Color(nx, nx, nx, this.normalize(y));
        return this.strokeColor;
    }

    @Override
    public Color stroke(double x, double y, double z) {
        this.strokeColor = new Color(this.normalize(x), this.normalize(y), this.normalize(z), this.colormode());
        return this.strokeColor;
    }

    @Override
    public Color stroke(double x, double y, double z, double a) {
        this.strokeColor = new Color(this.normalize(x), this.normalize(y), this.normalize(z), this.normalize(a), this.colormode());
        return this.strokeColor;
    }

    @Override
    public Color stroke(Color c) {
        this.strokeColor = c == null ? null : c.clone();
        return this.strokeColor;
    }

    @Override
    public void nostroke() {
        this.strokeColor = null;
    }

    @Override
    public double strokewidth() {
        return this.strokeWidth;
    }

    @Override
    public double strokewidth(double w) {
        this.strokeWidth = w;
        return this.strokeWidth;
    }

    @Override
    public Image image(String path, double x, double y) {
        throw new RuntimeException("'image' is not applicable to this type of GraphicsContext.");
    }

    @Override
    public Image image(String path, double x, double y, double width) {
        throw new RuntimeException("'image' is not applicable to this type of GraphicsContext.");
    }

    @Override
    public Image image(String path, double x, double y, double width, double height) {
        throw new RuntimeException("'image' is not applicable to this type of GraphicsContext.");
    }

    @Override
    public Image image(String path, double x, double y, double width, double height, double alpha) {
        throw new RuntimeException("'image' is not applicable to this type of GraphicsContext.");
    }

    @Override
    public Image image(String path, double x, double y, double width, double height, boolean draw) {
        throw new RuntimeException("'image' is not applicable to this type of GraphicsContext.");
    }

    @Override
    public Image image(String path, double x, double y, double width, double height, double alpha, boolean draw) {
        throw new RuntimeException("'image' is not applicable to this type of GraphicsContext.");
    }

    @Override
    public Image image(Image img, double x, double y, double width, double height, double alpha, boolean draw) {
        throw new RuntimeException("'image' is not applicable to this type of GraphicsContext.");
    }

    @Override
    public Image image(BufferedImage img, double x, double y, double width, double height, double alpha, boolean draw) {
        throw new RuntimeException("'image' is not applicable to this type of GraphicsContext.");
    }

    @Override
    public Size imagesize(String path) {
        throw new RuntimeException("'imagesize' is not applicable to this type of GraphicsContext.");
    }

    @Override
    public Size imagesize(Image img) {
        throw new RuntimeException("'imagesize' is not applicable to this type of GraphicsContext.");
    }

    @Override
    public Size imagesize(BufferedImage img) {
        throw new RuntimeException("'imagesize' is not applicable to this type of GraphicsContext.");
    }

    @Override
    public String font() {
        return this.fontName;
    }

    @Override
    public String font(String fontName) {
        if (!Text.fontExists(fontName)) {
            throw new NodeBoxError("Font '" + fontName + "' does not exist.");
        }
        this.fontName = fontName;
        return this.fontName;
    }

    @Override
    public String font(String fontName, double fontSize) {
        this.font(fontName);
        this.fontsize(fontSize);
        return fontName;
    }

    @Override
    public double fontsize() {
        return this.fontSize;
    }

    @Override
    public double fontsize(double s) {
        this.fontSize = s;
        return this.fontSize;
    }

    @Override
    public double lineheight() {
        return this.lineHeight;
    }

    @Override
    public double lineheight(double lineHeight) {
        this.lineHeight = lineHeight;
        return this.lineHeight;
    }

    @Override
    public Text.Align align() {
        return this.align;
    }

    @Override
    public Text.Align align(Text.Align align) {
        this.align = align;
        return this.align;
    }

    @Override
    public Text.Align align(String align) {
        try {
            Text.Align newAlign;
            this.align = newAlign = Text.Align.valueOf(align.toUpperCase(Locale.US));
            return this.align;
        }
        catch (IllegalArgumentException e) {
            throw new NodeBoxError("align: available types for align() are LEFT, RIGHT, CENTER and JUSTIFY\\n\"");
        }
    }

    @Override
    public Text.Align align(int align) {
        try {
            Text.Align newAlign;
            this.align = newAlign = Text.Align.values()[align];
            return this.align;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NodeBoxError("align: available types for align() are LEFT, RIGHT, CENTER and JUSTIFY\\n\"");
        }
    }

    @Override
    public Text text(String text, double x, double y) {
        return this.text(text, x, y, 0.0, 0.0, true);
    }

    @Override
    public Text text(String text, double x, double y, double width) {
        return this.text(text, x, y, width, 0.0, true);
    }

    @Override
    public Text text(String text, double x, double y, double width, double height) {
        return this.text(text, x, y, width, height, true);
    }

    @Override
    public Text text(String text, double x, double y, double width, double height, boolean draw) {
        Text t = new Text(text, x, y, width, height);
        t.setTransformDelegate(new ContextTransformDelegate(this));
        this.inheritFromContext(t);
        if (draw) {
            this.addText(t);
        }
        return t;
    }

    @Override
    public Path textpath(String text, double x, double y) {
        return this.textpath(text, x, y, 0.0, 0.0);
    }

    @Override
    public Path textpath(String text, double x, double y, double width) {
        return this.textpath(text, x, y, width, 0.0);
    }

    @Override
    public Path textpath(String text, double x, double y, double width, double height) {
        Text t = new Text(text, x, y, width, height);
        this.inheritFontAttributesFromContext(t);
        Path path = t.getPath();
        path.setTransformDelegate(new ContextTransformDelegate(this));
        this.inheritFromContext(path);
        return path;
    }

    @Override
    public Rect textmetrics(String text) {
        return this.textmetrics(text, 0.0, 0.0);
    }

    @Override
    public Rect textmetrics(String text, double width) {
        return this.textmetrics(text, width, 0.0);
    }

    @Override
    public Rect textmetrics(String text, double width, double height) {
        Text t = new Text(text, 0.0, 0.0, width, height);
        this.inheritFromContext(t);
        return t.getMetrics();
    }

    @Override
    public double textwidth(String text) {
        return this.textmetrics(text, 0.0, 0.0).getWidth();
    }

    @Override
    public double textwidth(String text, double width) {
        return this.textmetrics(text, width).getWidth();
    }

    @Override
    public double textheight(String text) {
        return this.textmetrics(text, 0.0, 0.0).getHeight();
    }

    @Override
    public double textheight(String text, double width) {
        return this.textmetrics(text, width).getHeight();
    }

    @Override
    public void var(String name, GraphicsContext.VarType type) {
        this.var(name, type, null, 0.0, 1000.0);
    }

    @Override
    public void var(String name, String type) {
        this.var(name, type, null, 0.0, 1000.0);
    }

    @Override
    public void var(String name, int type) {
        this.var(name, type, (Object)0, 0.0, 1000.0);
    }

    @Override
    public void var(String name, GraphicsContext.VarType type, Object value) {
        this.var(name, type, value, 0.0, 1000.0);
    }

    @Override
    public void var(String name, String type, Object value) {
        this.var(name, type, value, 0.0, 1000.0);
    }

    @Override
    public void var(String name, int type, Object value) {
        this.var(name, type, value, 0.0, 1000.0);
    }

    @Override
    public void var(String name, String type, Object value, double min, double max) {
        try {
            this.var(name, GraphicsContext.VarType.valueOf(type.toUpperCase(Locale.US)), value, min, max);
        }
        catch (IllegalArgumentException e) {
            throw new NodeBoxError("var: available types for var() are NUMBER, TEXT, BOOLEAN and FONT \\n\"");
        }
    }

    @Override
    public void var(String name, int type, Object value, double min, double max) {
        try {
            this.var(name, GraphicsContext.VarType.values()[type], value, min, max);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NodeBoxError("var: available types for var() are NUMBER, TEXT, BOOLEAN and FONT \\n\"");
        }
    }

    @Override
    public void var(String name, GraphicsContext.VarType type, Object value, double min, double max) {
    }

    @Override
    public Object findVar(String name) {
        return null;
    }

    protected double normalize(double v) {
        if (this.colorRange == 1.0) {
            return v;
        }
        return v / this.colorRange;
    }

    @Override
    public double random() {
        return Math.random();
    }

    @Override
    public long random(int max) {
        return Math.round(Math.random() * (double)max);
    }

    @Override
    public long random(int min, int max) {
        return Math.round((double)min + Math.random() * (double)(max - min));
    }

    @Override
    public double random(double max) {
        return Math.random() * max;
    }

    @Override
    public double random(double min, double max) {
        return min + Math.random() * (max - min);
    }

    @Override
    public Object choice(List objects) {
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        return objects.get((int)this.random(objects.size() - 1));
    }

    @Override
    public Iterator<Point> grid(int columns, int rows) {
        return this.grid(columns, rows, 1.0, 1.0);
    }

    public Iterator<Point> grid(double columns, double rows) {
        return this.grid(Math.round(columns), Math.round(rows), 1.0, 1.0);
    }

    public Iterator<Point> grid(double columns, double rows, double columnSize, double rowSize) {
        return this.grid(Math.round(columns), Math.round(rows), columnSize, rowSize);
    }

    @Override
    public Iterator<Point> grid(final int columns, final int rows, final double columnSize, final double rowSize) {
        return new Iterator<Point>(){
            int x = 0;
            int y = 0;

            @Override
            public boolean hasNext() {
                return this.y < rows;
            }

            @Override
            public Point next() {
                Point pt = new Point((double)this.x * columnSize, (double)this.y * rowSize);
                ++this.x;
                if (this.x >= columns) {
                    this.x = 0;
                    ++this.y;
                }
                return pt;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public void draw(Grob g) {
        if (g instanceof Path) {
            this.addPath((Path)g);
        } else if (g instanceof Geometry) {
            for (Path path : ((Geometry)g).getPaths()) {
                this.addPath(path);
            }
        } else if (g instanceof Contour) {
            this.addPath(((Contour)g).toPath());
        } else if (g instanceof Text) {
            this.addText((Text)g);
        } else {
            throw new IllegalArgumentException("Don't know how to add a " + g + " to the current context.");
        }
    }

    protected abstract void addPath(Path var1);

    protected abstract void addText(Text var1);

    protected void inheritFromContext(Path p) {
        p.setFillColor(this.fillColor == null ? null : this.fillColor.clone());
        p.setStrokeColor(this.strokeColor == null ? null : this.strokeColor.clone());
        p.setStrokeWidth(this.strokeWidth);
        TransformDelegate d = p.getTransformDelegate();
        d.transform(p, this.transform, true);
    }

    protected void inheritFromContext(Text t) {
        t.setFillColor(this.fillColor == null ? null : this.fillColor.clone());
        this.inheritFontAttributesFromContext(t);
        TransformDelegate d = t.getTransformDelegate();
        d.transform(t, this.transform, true);
    }

    private void inheritFontAttributesFromContext(Text t) {
        t.setFontName(this.fontName);
        t.setFontSize(this.fontSize);
        t.setLineHeight(this.lineHeight);
        t.setAlign(this.align);
    }
}

