/*
 * Decompiled with CFR 0.152.
 */
package nodebox.graphics;

import nodebox.graphics.DefaultTransformDelegate;
import nodebox.graphics.Grob;
import nodebox.graphics.Transform;
import nodebox.graphics.TransformDelegate;

public abstract class AbstractTransformable
implements Grob {
    private TransformDelegate transformDelegate = DefaultTransformDelegate.getDefaultDelegate();
    private Transform transform;

    @Override
    public void translate(double tx, double ty) {
        Transform t = Transform.translated(tx, ty);
        this.transformDelegate.transform(this, t);
    }

    @Override
    public void rotate(double degrees) {
        Transform t = Transform.rotated(degrees);
        this.transformDelegate.transform(this, t);
    }

    @Override
    public void rotateRadians(double radians) {
        Transform t = Transform.rotatedRadians(radians);
        this.transformDelegate.transform(this, t);
    }

    @Override
    public void scale(double scale) {
        Transform t = Transform.scaled(scale);
        this.transformDelegate.transform(this, t);
    }

    @Override
    public void scale(double sx, double sy) {
        Transform t = Transform.scaled(sx, sy);
        this.transformDelegate.transform(this, t);
    }

    @Override
    public void skew(double skew) {
        Transform t = Transform.skewed(skew);
        this.transformDelegate.transform(this, t);
    }

    @Override
    public void skew(double kx, double ky) {
        Transform t = Transform.skewed(kx, ky);
        this.transformDelegate.transform(this, t);
    }

    @Override
    public TransformDelegate getTransformDelegate() {
        return this.transformDelegate;
    }

    @Override
    public void setTransformDelegate(TransformDelegate d) {
        this.transformDelegate = d;
    }

    @Override
    public abstract Grob clone();
}

