/*
 * Decompiled with CFR 0.152.
 */
package nodebox.graphics;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import nodebox.graphics.AbstractTransformable;
import nodebox.graphics.Color;
import nodebox.graphics.Drawable;
import nodebox.graphics.Geometry;
import nodebox.graphics.GraphicsContext;
import nodebox.graphics.Grob;
import nodebox.graphics.PDFRenderer;
import nodebox.graphics.Path;
import nodebox.graphics.Rect;
import nodebox.graphics.Text;
import nodebox.graphics.Transform;

public class Canvas
extends AbstractTransformable {
    public static final double DEFAULT_WIDTH = 1000.0;
    public static final double DEFAULT_HEIGHT = 1000.0;
    private Color background = new Color(1.0, 1.0, 1.0);
    private double offsetX;
    private double offsetY;
    private double width;
    private double height;
    private ArrayList<Grob> items = new ArrayList();

    public Canvas() {
        this(1000.0, 1000.0);
    }

    public Canvas(double width, double height) {
        this.setSize(width, height);
    }

    public Canvas(Canvas other) {
        this.offsetX = other.offsetX;
        this.offsetY = other.offsetY;
        this.width = other.width;
        this.height = other.height;
        this.background = other.background == null ? null : other.background.clone();
        for (Grob g : other.items) {
            this.add(g.clone());
        }
    }

    public Geometry asGeometry() {
        return this.asGeometry(true);
    }

    public Geometry asGeometry(boolean clone) {
        Geometry g = new Geometry();
        for (Grob item : this.items) {
            if (item instanceof Path) {
                g.add((Path)(clone ? item.clone() : item));
                continue;
            }
            if (item instanceof Text) {
                g.add(((Text)item).getPath());
                continue;
            }
            if (!(item instanceof Geometry)) continue;
            g.extend((Geometry)(clone ? item.clone() : item));
        }
        return g;
    }

    public Color getBackground() {
        return this.background;
    }

    public Color setBackground(Color background) {
        this.background = background;
        return this.background;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(double offsetX) {
        this.offsetX = offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(double offsetY) {
        this.offsetY = offsetY;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public void setSize(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public void add(Grob g) {
        this.items.add(g);
    }

    public int size() {
        return this.items.size();
    }

    public void clear() {
        this.items.clear();
    }

    public List<Grob> getItems() {
        return this.items;
    }

    public Grob get(int index) {
        try {
            return this.items.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public void extend(Canvas c) {
        for (Grob grob : c.getItems()) {
            this.add(grob.clone());
        }
    }

    @Override
    public void transform(Transform t) {
        for (Grob g : this.items) {
            g.transform(t);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public Rect getBounds() {
        return new Rect(-this.width / 2.0 + this.offsetX, -this.height / 2.0 + this.offsetY, this.width, this.height);
    }

    @Override
    public Canvas clone() {
        return new Canvas(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Canvas)) {
            return false;
        }
        Canvas other = (Canvas)obj;
        return this.width == other.width && this.height == other.height && this.background.equals(other.background) && super.equals(other);
    }

    public void inheritFromContext(GraphicsContext ctx) {
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.background != null) {
            g.setColor(this.background.getAwtColor());
            g.fill(this.getBounds().getRectangle2D());
        }
        g.clip(this.getBounds().getRectangle2D());
        for (Grob grob : this.items) {
            grob.draw(g);
        }
    }

    public BufferedImage asImage() {
        Rect bounds = this.getBounds();
        BufferedImage img = new BufferedImage((int)Math.round(bounds.getWidth()), (int)Math.round(bounds.getHeight()), 2);
        Graphics2D g = img.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.translate(-bounds.getX(), -bounds.getY());
        this.draw(g);
        img.flush();
        return img;
    }

    public void save(File file) {
        if (file.getName().endsWith(".pdf")) {
            PDFRenderer.render((Drawable)this, this.getBounds(), file);
        } else {
            try {
                ImageIO.write((RenderedImage)this.asImage(), this.getFileExtension(file), file);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write image file " + file, e);
            }
        }
    }

    private String getFileExtension(File file) {
        String fileName = file.getName();
        String ext = null;
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            ext = fileName.substring(i + 1).toLowerCase(Locale.US);
        }
        return ext;
    }

    public String toString() {
        return "<" + this.getClass().getSimpleName() + ": " + this.width + ", " + this.height + ">";
    }
}

