/*
 * Decompiled with CFR 0.152.
 */
package nodebox.graphics;

import java.awt.image.BufferedImage;
import nodebox.graphics.AbstractGraphicsContext;
import nodebox.graphics.Canvas;
import nodebox.graphics.Color;
import nodebox.graphics.ContextTransformDelegate;
import nodebox.graphics.Grob;
import nodebox.graphics.Image;
import nodebox.graphics.Path;
import nodebox.graphics.Size;
import nodebox.graphics.Text;
import nodebox.graphics.TransformDelegate;

public class CanvasContext
extends AbstractGraphicsContext {
    public static final double DEFAULT_WIDTH = 1000.0;
    public static final double DEFAULT_HEIGHT = 1000.0;
    protected ImageMode imageMode = ImageMode.CORNER;
    private Canvas canvas;

    public CanvasContext() {
        this.canvas = new Canvas(1000.0, 1000.0);
        this.resetContext(true);
    }

    public CanvasContext(Canvas canvas) {
        this.canvas = canvas;
        this.resetContext(false);
    }

    @Override
    public void resetContext() {
        this.resetContext(true);
    }

    public void resetContext(boolean resetBackground) {
        super.resetContext();
        if (resetBackground) {
            this.canvas.setBackground(new Color(1.0, 1.0, 1.0));
        }
    }

    public ImageMode imagemode() {
        return this.imageMode;
    }

    public ImageMode imagemode(ImageMode m) {
        this.imageMode = m;
        return this.imageMode;
    }

    public void size(double width, double height) {
        this.canvas.setWidth(width);
        this.canvas.setHeight(height);
    }

    public double getWidth() {
        return this.canvas.getWidth();
    }

    public double getHeight() {
        return this.canvas.getHeight();
    }

    public double getWIDTH() {
        return this.canvas.getWidth();
    }

    public double getHEIGHT() {
        return this.canvas.getHeight();
    }

    public Color background() {
        return this.canvas.getBackground();
    }

    public Color background(double x) {
        double nx = this.normalize(x);
        return this.canvas.setBackground(new Color(nx, nx, nx));
    }

    public Color background(double x, double y) {
        double nx = this.normalize(x);
        return this.canvas.setBackground(new Color(nx, nx, nx, this.normalize(y)));
    }

    public Color background(double x, double y, double z) {
        return this.canvas.setBackground(new Color(this.normalize(x), this.normalize(y), this.normalize(z), this.colormode()));
    }

    public Color background(double x, double y, double z, double a) {
        return this.canvas.setBackground(new Color(this.normalize(x), this.normalize(y), this.normalize(z), this.normalize(a), this.colormode()));
    }

    public Color background(Color c) {
        return this.canvas.setBackground(c == null ? null : c.clone());
    }

    public void nobackground() {
        this.canvas.setBackground(null);
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    @Override
    public Image image(String path, double x, double y) {
        return this.image(path, x, y, 0.0, 0.0, 1.0, true);
    }

    @Override
    public Image image(String path, double x, double y, double width) {
        return this.image(path, x, y, width, 0.0, 1.0, true);
    }

    @Override
    public Image image(String path, double x, double y, double width, double height) {
        return this.image(path, x, y, width, height, 1.0, true);
    }

    @Override
    public Image image(String path, double x, double y, double width, double height, double alpha) {
        return this.image(path, x, y, width, height, alpha, true);
    }

    @Override
    public Image image(String path, double x, double y, double width, double height, boolean draw) {
        return this.image(path, x, y, width, height, 1.0, draw);
    }

    @Override
    public Image image(String path, double x, double y, double width, double height, double alpha, boolean draw) {
        return this.loadImage(new Image(path), x, y, width, height, alpha, draw);
    }

    @Override
    public Image image(Image img, double x, double y, double width, double height, double alpha, boolean draw) {
        return this.loadImage(img.clone(), x, y, width, height, alpha, draw);
    }

    @Override
    public Image image(BufferedImage img, double x, double y, double width, double height, double alpha, boolean draw) {
        return this.loadImage(new Image(img), x, y, width, height, alpha, draw);
    }

    private Image loadImage(Image img, double x, double y, double width, double height, double alpha, boolean draw) {
        if (width != 0.0) {
            img.setWidth(width);
        }
        if (height != 0.0) {
            img.setHeight(height);
        }
        switch (this.imageMode) {
            case CORNER: {
                double w = img.getWidth();
                double h = img.getHeight();
                img.setX(x + w / 2.0);
                img.setY(y + h / 2.0);
                break;
            }
            case CENTER: {
                img.setX(x);
                img.setY(y);
            }
        }
        img.setTransformDelegate(new ContextTransformDelegate(this));
        this.inheritFromContext(img);
        if (alpha != 1.0) {
            img.setAlpha(alpha);
        }
        if (draw) {
            this.canvas.add(img);
        }
        return img;
    }

    @Override
    public Size imagesize(String path) {
        Image img = new Image(path);
        return img.getSize();
    }

    @Override
    public Size imagesize(Image img) {
        return img.getSize();
    }

    @Override
    public Size imagesize(BufferedImage img) {
        return new Size(img.getWidth(), img.getHeight());
    }

    @Override
    public void draw(Grob grob) {
        this.canvas.add(grob);
    }

    @Override
    protected void addPath(Path p) {
        this.canvas.add(p);
    }

    @Override
    protected void addText(Text t) {
        this.canvas.add(t);
    }

    protected void addImage(Image i) {
        this.canvas.add(i);
    }

    protected void inheritFromContext(Image i) {
        TransformDelegate d = i.getTransformDelegate();
        d.transform(i, this.transform, true);
    }

    public static enum ImageMode {
        CORNERS,
        CORNER,
        RADIUS,
        CENTER;

    }
}

